/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.workspace;

import java.util.Map;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public interface Properties {

	/**
	 * @return the properties id.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	public String getId() throws InternalErrorException;
	
	/**
	 * @param propertyName the property name.
	 * @return the property value.
	 */
	public String getPropertyValue(String propertyName);
	
	/**
	 * @return the properties map.
	 */
	public Map<String, String> getProperties();
	
	/**
	 * Add a new property.
	 * @param name the property name.
	 * @param value the property value.
	 */
	public void addProperty(String name, String value);

}
