/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.consistency.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.portlets.user.homelibrary.consistency.statistics.WorkspaceCheckStatistics;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;

public class HomeCheckStatistics {
    protected int checkedUsers = 0;
    protected Map<String, WorkspaceCheckStatistics> workspacesStatistics = new LinkedHashMap<String, WorkspaceCheckStatistics>();
    protected int checkedItems = 0;
    protected int errors = 0;
    protected int folders = 0;
    protected Map<FolderItemType, Integer> folderItemTypesCount = new LinkedHashMap<FolderItemType, Integer>();

    public void addWorkspaceStatistics(String user, WorkspaceCheckStatistics workspaceStatistics) {
        ++this.checkedUsers;
        this.workspacesStatistics.put(user, workspaceStatistics);
        this.checkedItems += workspaceStatistics.getCheckedItems();
        this.errors += workspaceStatistics.getErrors();
        this.folders += workspaceStatistics.getFolders();
        for (Map.Entry<FolderItemType, Integer> entry : workspaceStatistics.getFolderItemTypesCount().entrySet()) {
            if (!this.folderItemTypesCount.containsKey(entry.getKey())) {
                this.folderItemTypesCount.put(entry.getKey(), entry.getValue());
                continue;
            }
            int count = this.folderItemTypesCount.get(entry.getKey());
            this.folderItemTypesCount.put(entry.getKey(), count += entry.getValue().intValue());
        }
    }

    public int getCheckedUsers() {
        return this.checkedUsers;
    }

    public Map<String, WorkspaceCheckStatistics> getWorkspacesStatistics() {
        return this.workspacesStatistics;
    }

    public int getCheckedItems() {
        return this.checkedItems;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFolders() {
        return this.folders;
    }

    public Map<FolderItemType, Integer> getFolderItemTypesCount() {
        return this.folderItemTypesCount;
    }
}

