/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.internaltest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.gcube.portlets.user.homelibrary.examples.ExamplesUtil;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.util.WorkspaceTreeVisitor;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class TestAquaMapsItemCreation {
    public static void main(String[] args) throws Exception {
        String perstistenceRoot = "/tmp/home_library_persistence";
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory((String)perstistenceRoot);
        Workspace workspace = ExamplesUtil.createWorkspace(factory, "/test", "federico.defaveri");
        WorkspaceFolder root = workspace.getRoot();
        LinkedHashMap<String, FileInputStream> images = new LinkedHashMap<String, FileInputStream>();
        String dirName = "test/org/gcube/portlets/user/homelibrary/testdata/resources/aquamapitems/ai1/images";
        File dir = new File(dirName);
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            images.put(file.getName(), new FileInputStream(file));
        }
        String metadataFile = "test/org/gcube/portlets/user/homelibrary/testdata/resources/aquamapitems/ai1/metadata.xml";
        FileInputStream is = new FileInputStream(metadataFile);
        root.createAquaMapsItem(WorkspaceUtil.getUniqueName((String)"My AquamapsItem", (WorkspaceFolder)root), "this is my first ami", "mapName", "mapType", "author", 100, "boundingBox", 0.5f, 12, (InputStream)is, images);
        WorkspaceTreeVisitor wtv = new WorkspaceTreeVisitor();
        wtv.visitVerbose(root);
        String gpodId = null;
        for (WorkspaceItem item : root.getChildren()) {
            FolderItem folderItem;
            System.out.println("processing: " + item);
            if (item.getType() != WorkspaceItemType.FOLDER_ITEM || (folderItem = (FolderItem)item).getFolderItemType() != FolderItemType.AQUAMAPS_ITEM) continue;
            System.out.println("gpod: " + folderItem);
            gpodId = folderItem.getId();
        }
        workspace.decomposeAquaMapsItem(gpodId, "mytest", workspace.getRoot().getId());
        wtv.visitVerbose(root);
    }
}

