/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.testdata.TestDataManagerUtil;
import org.gcube.portlets.user.homelibrary.testdata.data.DocMetadata;
import org.gcube.portlets.user.homelibrary.testdata.data.ImageDocumentData;
import org.gcube.portlets.user.homelibrary.testdata.data.PDFDocumentData;
import org.gcube.portlets.user.homelibrary.testdata.data.TestData;
import org.gcube.portlets.user.homelibrary.testdata.data.UrlDocumentData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class MetadataDataManager {
    protected Logger logger = Logger.getLogger(MetadataDataManager.class);
    protected XStream xstream;
    protected Random random;
    protected List<MetadataInfo> data;

    public MetadataDataManager() {
        this.configureXStream();
        this.random = new Random();
        this.data = this.loadAllMetadata();
    }

    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("metadata", DocMetadata.class);
        this.xstream.alias("url", UrlDocumentData.class);
        this.xstream.alias("urls", LinkedList.class);
        this.xstream.alias("image", ImageDocumentData.class);
        this.xstream.alias("images", LinkedList.class);
        this.xstream.alias("pdf", PDFDocumentData.class);
        this.xstream.alias("pdfs", LinkedList.class);
    }

    protected List<MetadataInfo> loadAllMetadata() {
        List<TestData> data = this.loadAllData();
        LinkedList<MetadataInfo> metadata = new LinkedList<MetadataInfo>();
        for (TestData testData : data) {
            String name = testData.getName();
            String description = testData.getDescription();
            String oid = TestDataManagerUtil.getUID();
            String collectionName = testData.getCollectionName();
            for (DocMetadata docMetadata : testData.getMetadatas()) {
                metadata.add(new MetadataInfo(name, description, oid, docMetadata.getSchema(), docMetadata.getLanguage(), docMetadata.getFile(), collectionName));
            }
        }
        return metadata;
    }

    protected List<TestData> loadAllData() {
        LinkedList<TestData> data = new LinkedList<TestData>();
        data.addAll(this.loadData("images.xml"));
        data.addAll(this.loadData("pdfs.xml"));
        data.addAll(this.loadData("urls.xml"));
        this.logger.trace((Object)("Loaded " + data.size() + " test data."));
        return data;
    }

    protected List<TestData> loadData(String dataListFile) {
        String dataListPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + dataListFile;
        this.logger.debug((Object)("Loading the data list from: " + dataListPath));
        InputStream dataList = TestDataFactory.class.getResourceAsStream(dataListPath);
        List data = (List)this.xstream.fromXML(dataList);
        this.logger.trace((Object)("Loaded " + data.size() + " test data."));
        return data;
    }

    protected InputStream getMetadataStream(MetadataInfo metadataInfo) {
        this.logger.trace((Object)("getTestDataStream testData: " + metadataInfo));
        String imagePath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + metadataInfo.metadataFile;
        return TestDataFactory.class.getResourceAsStream(imagePath);
    }

    protected Metadata fillMetadata(WorkspaceFolder destinationFolder, MetadataInfo metadataInfo) throws InternalErrorException {
        try {
            InputStream metadataStream = this.getMetadataStream(metadataInfo);
            String metadata = TestDataManagerUtil.loadFileAsString(metadataStream);
            String name = WorkspaceUtil.getUniqueName((String)metadataInfo.name, (WorkspaceFolder)destinationFolder);
            return destinationFolder.createMetadataItem(name, metadataInfo.description, metadataInfo.oid, metadataInfo.schema, metadataInfo.language, metadata, metadataInfo.collectionName);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the metadata", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the metadata", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<Metadata> fillMetadatas(WorkspaceFolder destinationFolder, int numberOfMetadata) throws InternalErrorException {
        LinkedList<Metadata> metadatas = new LinkedList<Metadata>();
        for (int counter = 0; counter < numberOfMetadata; ++counter) {
            int imgIndex = counter % this.data.size();
            MetadataInfo metadataInfo = this.data.get(imgIndex);
            Metadata metadata = this.fillMetadata(destinationFolder, metadataInfo);
            metadatas.add(metadata);
        }
        return metadatas;
    }

    public List<Metadata> fillAllMetadatas(WorkspaceFolder destinationFolder) throws InternalErrorException {
        LinkedList<Metadata> metadatas = new LinkedList<Metadata>();
        for (MetadataInfo metadataInfo : this.data) {
            Metadata metadata = this.fillMetadata(destinationFolder, metadataInfo);
            metadatas.add(metadata);
        }
        return metadatas;
    }

    class MetadataInfo {
        String name;
        String description;
        String oid;
        String schema;
        String language;
        String metadataFile;
        String collectionName;

        public MetadataInfo(String name, String description, String oid, String schema, String language, String metadataFile, String collectionName) {
            this.name = name;
            this.description = description;
            this.oid = oid;
            this.schema = schema;
            this.language = language;
            this.metadataFile = metadataFile;
            this.collectionName = collectionName;
        }
    }
}

