/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.logging;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class MultiLoggerFileAppender
extends FileAppender {
    Map<String, List<LoggingEvent>> loggerEvents = new LinkedHashMap<String, List<LoggingEvent>>();

    public MultiLoggerFileAppender() {
    }

    public MultiLoggerFileAppender(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super(layout, filename, append, bufferedIO, bufferSize);
    }

    public MultiLoggerFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public MultiLoggerFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public synchronized void append(LoggingEvent event) {
        List<Object> events;
        String loggerName = event.getThreadName();
        if (this.loggerEvents.containsKey(loggerName)) {
            events = this.loggerEvents.get(loggerName);
        } else {
            events = new LinkedList();
            this.loggerEvents.put(loggerName, events);
        }
        events.add(event);
    }

    public void close() {
        for (List<LoggingEvent> events : this.loggerEvents.values()) {
            for (LoggingEvent event : events) {
                super.append(event);
            }
        }
        super.close();
    }
}

