/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileCleaner;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.util.zip.ZipFileModelExtractor;
import org.gcube.portlets.user.homelibrary.util.zip.ZipModelToWorkspaceCreator;
import org.gcube.portlets.user.homelibrary.util.zip.ZipModelVisitor;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;

public class UnzipUtil {
    protected static final Logger logger = Logger.getLogger((String)HomeLibrary.class.getPackage().getName());

    public static void unzip(WorkspaceFolder destinationFolder, InputStream is, String zipName) throws IOException {
        logger.trace((Object)("unzip destinationWorkspace: " + destinationFolder + ", zipName: " + zipName));
        logger.trace((Object)"Extracting zip model from zip file.");
        ZipFileModelExtractor zme = new ZipFileModelExtractor(is);
        List<ZipItem> items = zme.getModel();
        logger.trace((Object)"Zip Model:");
        ZipModelVisitor visitor = new ZipModelVisitor(logger);
        visitor.visit(items);
        logger.trace((Object)"Creating the items");
        ZipModelToWorkspaceCreator creator = new ZipModelToWorkspaceCreator();
        creator.create(destinationFolder, items);
    }

    public static void unzip(InputStream is, OutputStream os) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            os.close();
            return;
        }
        throw new Exception("No file entry found");
    }

    public static InputStream unzipToTmp(InputStream is) throws Exception {
        ZipEntry entry;
        File tmpFile = File.createTempFile("unzippedts", "tmp");
        FileOutputStream os = new FileOutputStream(tmpFile);
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            ((OutputStream)os).close();
            FileInputStream tmpis = new FileInputStream(tmpFile);
            FileCleaner.track((File)tmpFile, (Object)tmpis);
            return tmpis;
        }
        throw new Exception("No file entry found");
    }
}

