/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace.test;

import java.io.IOException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class WorkspaceTest
extends AbstractWorkspaceTest {
    public WorkspaceTest(WorkspaceFactory factory) {
        super(factory);
    }

    @Test
    @Ignore(value="Not yet implemented")
    public final void testCreateAnnotation() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testCreateMetadata() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        Metadata metadata = this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
        System.err.println("Child expeted :" + metadata.getId());
        UnitTestUtil.testItemCreation((WorkspaceItem)metadata, (WorkspaceItem)root, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        Assert.assertEquals((String)"Different oid", (Object)expectedOid, (Object)metadata.getURI());
        Assert.assertEquals((String)"Different schema", (Object)expectedSchema, (Object)metadata.getSchema());
        Assert.assertEquals((String)"Different metadata", (Object)expectedMetadata, (Object)metadata.getData());
        Assert.assertEquals((String)"Different collection name", (Object)expectedCollectionName, (Object)metadata.getCollectionName());
        FolderItemType folderItemType = metadata.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.METADATA, (Object)folderItemType);
        long expectedLength = expectedMetadata.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)metadata.getLength());
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateMetadataDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "Test" + this.workspace.getPathSeparator() + "Document";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullCollectionNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument1";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = null;
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument2";
        String expectedDescription = null;
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullDestinationFolderArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String expectedName = "TestDocument3";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullLanguageArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument4";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = null;
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullMetadataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument5";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = null;
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = null;
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullOidArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument6";
        String expectedDescription = "Test document description";
        String expectedOid = null;
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateMetadataNullSchemaArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument7";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = null;
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, root.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateMetadataWrongDestinationFolderIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String expectedName = "TestDocument8";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedMetadata, expectedLanguage, expectedCollectionName, "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateMetadataWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument9";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        Metadata metadata = this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
        this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, metadata.getId());
    }

    @Test
    @Ignore
    public final void testCreateQuery() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testGetCapabilities() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testGetNewFolderBulkCreator() throws InternalErrorException, WrongItemTypeException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        FolderBulkCreator bbc = this.workspace.getNewFolderBulkCreator(root.getId());
        Assert.assertNotNull((String)"FolderBulkCreator null", (Object)bbc);
        Assert.assertEquals((String)"Different destination folders", (Object)root.getId(), (Object)bbc.getDestinationFolder().getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testGetNewFolderBulkCreatorWrongFolderId() throws WrongItemTypeException, InternalErrorException, WorkspaceFolderNotFoundException {
        this.workspace.getNewFolderBulkCreator("");
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetNewFOlderBulkCreatorWrongTargetNullFolderIdArgument() throws WrongItemTypeException, InternalErrorException, WorkspaceFolderNotFoundException {
        this.workspace.getNewFolderBulkCreator(null);
    }

    @Test(expected=WrongItemTypeException.class)
    public final void testGetNewFolderBulkCreatorWrongTargetType() throws WrongItemTypeException, InternalErrorException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceItem wrongDestination = (WorkspaceItem)TestDataFactory.getInstance().fillExternalFiles(root, 1).get(0);
        this.workspace.getNewFolderBulkCreator(wrongDestination.getId());
    }

    @Test
    @Ignore
    public final void testGetOwner() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testGetRoot() throws InternalErrorException {
        WorkspaceFolder root = this.workspace.getRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.getParent());
    }
}

