/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.config.easyconf;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileConfigurationChangedReloadingStrategy
extends FileChangedReloadingStrategy {
    private URL sourceURL;
    private static final Log log = LogFactory.getLog(FileConfigurationChangedReloadingStrategy.class);

    public void setConfiguration(FileConfiguration configuration) {
        super.setConfiguration(configuration);
        this.setSourceURL(configuration.getURL());
    }

    protected void setSourceURL(URL url) {
        this.sourceURL = url;
    }

    protected URL getSourceURL() {
        return this.sourceURL;
    }

    protected void updateLastModified() {
        this.lastModified = this.getFile().lastModified();
    }

    protected boolean hasChanged() {
        File file = this.getFile();
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("File does not exist: " + file));
            }
            return false;
        }
        boolean result = file.lastModified() > this.lastModified;
        this.lastChecked = System.currentTimeMillis();
        return result;
    }

    protected File getFile() {
        if ("file".equals(this.sourceURL.getProtocol())) {
            return new File(this.sourceURL.getPath());
        }
        if ("jar".equals(this.sourceURL.getProtocol())) {
            String path = this.sourceURL.getPath();
            String jarFilePath = path.substring("file:".length(), path.indexOf(33));
            return new File(jarFilePath);
        }
        if (this.configuration != null) {
            return this.configuration.getFile();
        }
        if ("classloader".equals(this.sourceURL.getProtocol())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reloading will not work for files loaded by the classloader: " + this.sourceURL));
            }
            return new File(this.sourceURL.getFile());
        }
        log.warn((Object)("Cannot determine the filesystem file which contains the configuration file for: " + this.sourceURL));
        return new File(this.sourceURL.getFile());
    }
}

