/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.util.zip.WorkspaceToZipModelConverter;
import org.gcube.portlets.user.homelibrary.util.zip.ZipModelVisitor;
import org.gcube.portlets.user.homelibrary.util.zip.ZipModelWriter;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;

public class ZipUtil {
    protected static final Logger logger = Logger.getLogger(ZipUtil.class);

    public static File zipFolder(WorkspaceFolder folder) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(folder);
    }

    public static File zipDocument(Document document) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(document);
    }

    public static File zipTimeSeries(TimeSeries ts) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(ts);
    }

    public static File zipAquaMapsItem(AquaMapsItem aquaMapsItem) throws IOException, InternalErrorException {
        return ZipUtil.zipWorkspaceItem(aquaMapsItem);
    }

    protected static File zipWorkspaceItem(WorkspaceItem workspaceItem) throws InternalErrorException, IOException {
        logger.trace((Object)("Zipping " + workspaceItem));
        logger.trace((Object)"converting to zip model");
        WorkspaceToZipModelConverter zipConverter = new WorkspaceToZipModelConverter();
        ZipItem item = zipConverter.convert(workspaceItem);
        ZipModelVisitor zipModelVisitor = new ZipModelVisitor(logger);
        zipModelVisitor.visitItem(item);
        logger.trace((Object)"writing model");
        ZipModelWriter zipModelWriter = new ZipModelWriter();
        File zipFile = zipModelWriter.writeItem(item);
        logger.trace((Object)("conversion complete in file " + zipFile.getAbsolutePath()));
        return zipFile;
    }

    public static void zip(File input, File output, String entryName) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(output));
        ZipEntry zipEntry = new ZipEntry(entryName);
        out.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)out);
        out.closeEntry();
        out.close();
    }
}

