/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.home;

import java.io.File;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.ApplicationsArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.util.config.HomeLibraryConfiguration;

public class HomeLibrary {
    public static final String HOME_ATTRIBUTE_NAME = "USER_HOME";
    protected static GCUBELog staticLogger = new GCUBELog((Object)"HomeManageFactory");
    protected static HomeManagerFactory instance;

    protected static HomeManagerFactory getHomeManagerFactoryImplementation() throws InternalErrorException {
        try {
            Class<?> homeManagerFactoryClass = HomeLibraryConfiguration.getInstance().getHomeManagerFactoryClass();
            return (HomeManagerFactory)homeManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            staticLogger.error((Object)"An error occured retrieving the HomeManagerFactory implementation.", (Throwable)e);
            throw new InternalErrorException("An error occured retrieving the HomeManagerFactory implementation.", e);
        }
    }

    protected static void checkPersistenceFolder(String persistenceFolder) throws InternalErrorException {
        staticLogger.trace((Object)("persistenceFolder = " + persistenceFolder));
        File persistenceDir = new File(persistenceFolder);
        if (!persistenceDir.exists()) {
            staticLogger.trace((Object)"The persistence folder don't exists, creating it");
            boolean created = persistenceDir.mkdirs();
            if (!created) {
                staticLogger.fatal((Object)("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder));
                System.err.println("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder);
                throw new InternalErrorException("FATAL: the home library can't create his persistence folder!!! " + persistenceFolder);
            }
        } else {
            staticLogger.trace((Object)"The persistence folder exists");
        }
    }

    protected static synchronized HomeManagerFactory createHomeManagerFactoryInstance(String persistenceRoot) throws InternalErrorException {
        HomeLibrary.checkPersistenceFolder(persistenceRoot);
        HomeManagerFactory homeManagerFactory = HomeLibrary.getHomeManagerFactoryImplementation();
        homeManagerFactory.initialize(persistenceRoot);
        return homeManagerFactory;
    }

    public static synchronized HomeManagerFactory getHomeManagerFactory(String persistenceRoot) throws InternalErrorException {
        staticLogger.info((Object)("getInstance persistenceRoot: " + persistenceRoot));
        if (instance == null) {
            instance = HomeLibrary.createHomeManagerFactoryInstance(persistenceRoot);
        }
        return instance;
    }

    public static HomeManagerFactory getHomeManagerFactory() throws InternalErrorException {
        staticLogger.info((Object)"getHomeManagerFactory");
        if (instance != null) {
            return instance;
        }
        String persistenceRoot = HomeLibraryConfiguration.getInstance().getPersistenceFolder();
        return HomeLibrary.getHomeManagerFactory(persistenceRoot);
    }

    public static Workspace getUserWorkspace(ASLSession session) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        if (session == null) {
            staticLogger.error((Object)"Session parameter null");
            throw new IllegalArgumentException("The session can't be null.");
        }
        Home home = HomeLibrary.getUserHome(session);
        return home.getWorkspace();
    }

    public static ApplicationsArea getUserDataArea(ASLSession session) throws InternalErrorException, HomeNotFoundException {
        if (session == null) {
            staticLogger.error((Object)"Session parameter null");
            throw new IllegalArgumentException("The session can't be null.");
        }
        Home home = HomeLibrary.getUserHome(session);
        return home.getDataArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Home getUserHome(ASLSession session) throws InternalErrorException, HomeNotFoundException {
        staticLogger = new GCUBELog(HomeLibrary.class);
        if (session == null) {
            staticLogger.error((Object)"Session parameter null");
            throw new IllegalArgumentException("The session can't be null.");
        }
        ASLSession aSLSession = session;
        synchronized (aSLSession) {
            Home home = (Home)session.getAttribute(HOME_ATTRIBUTE_NAME);
            if (home == null) {
                staticLogger.info((Object)("No data found in ASLSession, loading a new one. (Username: " + session.getUsername() + ", scope: " + session.getScope() + ")"));
                String username = session.getUsername();
                GCUBEScope scope = session.getScope();
                if (username == null) {
                    staticLogger.error((Object)"The username in session is null");
                    throw new IllegalArgumentException("The username returned by session is null.");
                }
                if (scope == null) {
                    staticLogger.error((Object)"The scope in session is null");
                    throw new IllegalArgumentException("The scope in session is null.");
                }
                HomeManagerFactory homeManagerFactory = HomeLibrary.getHomeManagerFactory();
                HomeManager homeManager = homeManagerFactory.getHomeManager();
                User user = homeManager.getUser(username);
                home = homeManager.getHome(user, scope);
                session.setAttribute(HOME_ATTRIBUTE_NAME, (Object)home);
            }
            return home;
        }
    }
}

