/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.testdata.data.DocMetadata;
import org.gcube.portlets.user.homelibrary.testdata.data.TestData;

public class TestDataManagerUtil {
    protected static final Logger logger = Logger.getLogger(TestDataManagerUtil.class);

    public static String loadFileAsString(InputStream file) throws InternalErrorException {
        try {
            StringBuilder sb = new StringBuilder();
            int reads = 0;
            byte[] buffer = new byte[1024];
            while ((reads = file.read(buffer)) >= 0) {
                sb.append(new String(buffer, 0, reads));
            }
            file.close();
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Error loading file from InputStream", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static String loadMetadata(DocMetadata docMetadata) throws InternalErrorException {
        InputStream metadataFile = TestDataFactory.class.getResourceAsStream("/org/gcube/portlets/user/homelibrary/testdata/resources/" + docMetadata.getFile());
        return TestDataManagerUtil.loadFileAsString(metadataFile);
    }

    protected static Map<String, String> loadMetadatas(List<DocMetadata> docMetadatas) throws InternalErrorException {
        LinkedHashMap<String, String> metadatas = new LinkedHashMap<String, String>();
        for (DocMetadata docMetadata : docMetadatas) {
            String data = TestDataManagerUtil.loadMetadata(docMetadata);
            metadatas.put(docMetadata.getName(), data);
        }
        return metadatas;
    }

    protected static InputStream getTestDataStream(TestData testData) {
        logger.trace((Object)("getTestDataStream testData: " + testData));
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + testData.getFile();
        logger.trace((Object)("TestDataStream path: " + testDataPath));
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    public static String getUID() {
        return UUID.randomUUID().toString();
    }
}

