/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.testdata.data.TestData;
import org.gcube.portlets.user.homelibrary.testdata.manager.AquaMapItemDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.DocumentDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.ImageDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.MetadataDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.PDFDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.QueryDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.ReportDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.TemplateDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.TimeSeriesDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.UrlDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.WorkflowReportDataManager;
import org.gcube.portlets.user.homelibrary.testdata.manager.WorkflowTemplateDataManager;

public class TestDataFactory {
    public static final String resourceRoot = "/org/gcube/portlets/user/homelibrary/testdata/resources/";
    protected Logger logger = Logger.getLogger(TestDataFactory.class);
    protected static TestDataFactory instance;
    protected Random random = new Random();
    protected ImageDataManager imageDataManager = new ImageDataManager();
    protected PDFDataManager pdfDataManager = new PDFDataManager();
    protected UrlDataManager urlDataManager = new UrlDataManager();
    protected DocumentDataManager genericDataManager = new DocumentDataManager();
    protected MetadataDataManager metadataDataManager = new MetadataDataManager();
    protected TimeSeriesDataManager timeSeriesDataManager = new TimeSeriesDataManager();
    protected QueryDataManager queryDataManager = new QueryDataManager();
    protected ReportDataManager reportDataManager = new ReportDataManager();
    protected TemplateDataManager templateDataManager = new TemplateDataManager();
    protected AquaMapItemDataManager aquaMapItemDataManager = new AquaMapItemDataManager();
    protected WorkflowReportDataManager workflowReportDataManager = new WorkflowReportDataManager();
    protected WorkflowTemplateDataManager workflowTemplateDataManager = new WorkflowTemplateDataManager();

    public static TestDataFactory getInstance() {
        if (instance == null) {
            instance = new TestDataFactory();
        }
        return instance;
    }

    protected TestDataFactory() {
    }

    public List<FolderItem> fillAllFolderItem(WorkspaceFolder destinationFolder) throws InternalErrorException {
        LinkedList<FolderItem> items = new LinkedList<FolderItem>();
        items.addAll(this.fillAllExternalImages(destinationFolder));
        items.addAll(this.fillAllExternalFiles(destinationFolder));
        items.addAll(this.fillAllExternalPDFFiles(destinationFolder));
        items.addAll(this.fillAllExternalUrls(destinationFolder));
        items.addAll(this.fillAllQueries(destinationFolder));
        items.addAll(this.fillAllReportTemplates(destinationFolder));
        items.addAll(this.fillAllReports(destinationFolder));
        items.addAll(this.fillAllTimeSeries(destinationFolder));
        items.addAll(this.fillAllDocuments(destinationFolder));
        items.addAll(this.fillAllImageDocuments(destinationFolder));
        items.addAll(this.fillAllPDFDocuments(destinationFolder));
        items.addAll(this.fillAllUrlDocuments(destinationFolder));
        items.addAll(this.fillAllMetadata(destinationFolder));
        items.addAll(this.fillAllWorkflowReports(destinationFolder));
        items.addAll(this.fillAllWorkflowTemplates(destinationFolder));
        return items;
    }

    public List<FolderItem> fillWorkspaceFolderItem(WorkspaceFolder destinationFolder, int numberOfItems) throws InternalErrorException {
        LinkedList<FolderItem> items = new LinkedList<FolderItem>();
        items.addAll(this.fillExternalImages(destinationFolder, numberOfItems));
        items.addAll(this.fillExternalFiles(destinationFolder, numberOfItems));
        items.addAll(this.fillExternalPDFFiles(destinationFolder, numberOfItems));
        items.addAll(this.fillExternalUrls(destinationFolder, numberOfItems));
        items.addAll(this.fillQueries(destinationFolder, numberOfItems));
        items.addAll(this.fillReportTemplates(destinationFolder, numberOfItems));
        items.addAll(this.fillReports(destinationFolder, numberOfItems));
        items.addAll(this.fillTimeSeries(destinationFolder, numberOfItems));
        items.addAll(this.fillDocuments(destinationFolder, numberOfItems));
        items.addAll(this.fillImageDocuments(destinationFolder, numberOfItems));
        items.addAll(this.fillPDFDocuments(destinationFolder, numberOfItems));
        items.addAll(this.fillUrlDocuments(destinationFolder, numberOfItems));
        items.addAll(this.fillMetadata(destinationFolder, numberOfItems));
        items.addAll(this.fillWorkflowReports(destinationFolder, numberOfItems));
        items.addAll(this.fillWorkflowTemplates(destinationFolder, numberOfItems));
        return items;
    }

    public List<ImageDocument> fillAllImageDocuments(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.imageDataManager.fillAllDocuments(destinationFolder);
    }

    public List<ExternalImage> fillExternalImages(WorkspaceFolder destinationFolder, int numberOfImages) throws InternalErrorException {
        return this.imageDataManager.fillExternals(destinationFolder, numberOfImages);
    }

    public List<ExternalImage> fillAllExternalImages(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.imageDataManager.fillAllExternals(destinationFolder);
    }

    public List<ImageDocument> fillImageDocuments(WorkspaceFolder destinationFolder, int numberOfImages) throws InternalErrorException {
        return this.imageDataManager.fillDocuments(destinationFolder, numberOfImages);
    }

    public InputStream getRandomImageInputStream() {
        return this.imageDataManager.getRandomInputStream();
    }

    public File getTMPRandomImageFile() throws InternalErrorException {
        return this.imageDataManager.getTMPRandomFile();
    }

    public List<ExternalPDFFile> fillExternalPDFFiles(WorkspaceFolder destinationFolder, int numberOfPDFs) throws InternalErrorException {
        return this.pdfDataManager.fillExternals(destinationFolder, numberOfPDFs);
    }

    public List<ExternalPDFFile> fillAllExternalPDFFiles(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.pdfDataManager.fillAllExternals(destinationFolder);
    }

    public List<PDFDocument> fillPDFDocuments(WorkspaceFolder destinationFolder, int numberOfPDFs) throws InternalErrorException {
        return this.pdfDataManager.fillDocuments(destinationFolder, numberOfPDFs);
    }

    public List<PDFDocument> fillAllPDFDocuments(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.pdfDataManager.fillAllDocuments(destinationFolder);
    }

    protected TestData getRandomTestData() {
        int type = this.random.nextInt(2);
        switch (type) {
            case 0: {
                return this.imageDataManager.getRandomDocumentData();
            }
            case 1: {
                return this.pdfDataManager.getRandomDocumentData();
            }
        }
        return this.imageDataManager.getRandomDocumentData();
    }

    public List<ExternalFile> fillExternalFiles(WorkspaceFolder destinationFolder, int numberOfExternalFiles) throws InternalErrorException {
        return this.genericDataManager.fillExternals(destinationFolder, numberOfExternalFiles);
    }

    public List<ExternalFile> fillAllExternalFiles(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.genericDataManager.fillAllExternals(destinationFolder);
    }

    public List<Document> fillDocuments(WorkspaceFolder destinationFolder, int numberOfDocuments) throws InternalErrorException {
        return this.genericDataManager.fillDocuments(destinationFolder, numberOfDocuments);
    }

    public List<Document> fillAllDocuments(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.genericDataManager.fillAllDocuments(destinationFolder);
    }

    public List<ExternalUrl> fillAllExternalUrls(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.urlDataManager.fillAllExternals(destinationFolder);
    }

    public List<ExternalUrl> fillExternalUrls(WorkspaceFolder destinationFolder, int numberOfExternalUrls) throws InternalErrorException {
        return this.urlDataManager.fillExternals(destinationFolder, numberOfExternalUrls);
    }

    public List<UrlDocument> fillUrlDocuments(WorkspaceFolder destinationFolder, int numberOfUrlDocuments) throws InternalErrorException {
        return this.urlDataManager.fillDocuments(destinationFolder, numberOfUrlDocuments);
    }

    public List<UrlDocument> fillAllUrlDocuments(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.urlDataManager.fillAllDocuments(destinationFolder);
    }

    public List<Metadata> fillMetadata(WorkspaceFolder destinationFolder, int numberOfMetadata) throws InternalErrorException {
        return this.metadataDataManager.fillMetadatas(destinationFolder, numberOfMetadata);
    }

    public List<Metadata> fillAllMetadata(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.metadataDataManager.fillAllMetadatas(destinationFolder);
    }

    public List<TimeSeries> fillTimeSeries(WorkspaceFolder destinationFolder, int numberOfTimeSeries) throws InternalErrorException {
        return this.timeSeriesDataManager.fillDatas(destinationFolder, numberOfTimeSeries);
    }

    public List<TimeSeries> fillAllTimeSeries(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.timeSeriesDataManager.fillAllDatas(destinationFolder);
    }

    public List<Query> fillQueries(WorkspaceFolder destinationFolder, int numberOfQueries) throws InternalErrorException {
        return this.queryDataManager.fillDatas(destinationFolder, numberOfQueries);
    }

    public List<Query> fillAllQueries(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.queryDataManager.fillAllDatas(destinationFolder);
    }

    public List<Report> fillReports(WorkspaceFolder destinationFolder, int numberOfReports) throws InternalErrorException {
        return this.reportDataManager.fillDatas(destinationFolder, numberOfReports);
    }

    public List<Report> fillAllReports(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.reportDataManager.fillAllDatas(destinationFolder);
    }

    public List<ReportTemplate> fillReportTemplates(WorkspaceFolder destinationFolder, int numberOfTemplates) throws InternalErrorException {
        return this.templateDataManager.fillDatas(destinationFolder, numberOfTemplates);
    }

    public List<ReportTemplate> fillAllReportTemplates(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.templateDataManager.fillAllDatas(destinationFolder);
    }

    public List<WorkspaceFolder> fillAquaMapsItems(WorkspaceFolder destinationFolder, int numberOfAquaMapsItems) throws InternalErrorException {
        return this.aquaMapItemDataManager.fillDatas(destinationFolder, numberOfAquaMapsItems);
    }

    public List<WorkspaceFolder> fillAllAquaMapsItems(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.aquaMapItemDataManager.fillAllDatas(destinationFolder);
    }

    public List<WorkflowReport> fillWorkflowReports(WorkspaceFolder destinationFolder, int numberOfWorkflowReports) throws InternalErrorException {
        return this.workflowReportDataManager.fillDatas(destinationFolder, numberOfWorkflowReports);
    }

    public List<WorkflowReport> fillAllWorkflowReports(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.workflowReportDataManager.fillAllDatas(destinationFolder);
    }

    public List<WorkflowTemplate> fillWorkflowTemplates(WorkspaceFolder destinationFolder, int numberOfWorkflowTemplates) throws InternalErrorException {
        return this.workflowTemplateDataManager.fillDatas(destinationFolder, numberOfWorkflowTemplates);
    }

    public List<WorkflowTemplate> fillAllWorkflowTemplates(WorkspaceFolder destinationFolder) throws InternalErrorException {
        return this.workflowTemplateDataManager.fillAllDatas(destinationFolder);
    }

    public InputStream getRandomPDFInputStream() {
        return this.pdfDataManager.getRandomInputStream();
    }

    public File getTMPRandomPDFFile() throws InternalErrorException {
        return this.pdfDataManager.getTMPRandomFile();
    }

    public File getTMPRandomFile() throws InternalErrorException {
        int type = this.random.nextInt(2);
        switch (type) {
            case 0: {
                return this.getTMPRandomImageFile();
            }
            case 1: {
                return this.getTMPRandomPDFFile();
            }
        }
        return this.getTMPRandomImageFile();
    }

    public static void main(String[] args) throws InternalErrorException {
    }
}

