/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace.test;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestItemMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestItemMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testChangeDescriptionNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem", "A test folder");
        String expectedDescription = null;
        this.ownerWorkspace.changeDescription(folder.getId(), expectedDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testChangeDescriptionNullIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        String expectedDescription = "This is a test new description";
        this.ownerWorkspace.changeDescription(null, expectedDescription);
    }

    @Test
    public final void testChangeDescriptionWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem1", "A test folder");
        String expectedDescription = "This is a test new description";
        this.ownerWorkspace.changeDescription(folder.getId(), expectedDescription);
        folder = (WorkspaceFolder)this.ownerWorkspace.getItem(folder.getId());
        Assert.assertEquals((String)"Descriptions are different", (Object)expectedDescription, (Object)folder.getDescription());
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testChangeDescriptionWrongIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        String expectedDescription = "This is a test new description";
        this.ownerWorkspace.changeDescription("", expectedDescription);
    }

    @Test
    public final void testExists() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        boolean exists = this.ownerWorkspace.exists(root.getId());
        Assert.assertTrue((String)"The root has not been found", (boolean)exists);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testExistsNullItemId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        this.ownerWorkspace.getRoot();
        this.ownerWorkspace.exists(null);
    }

    @Test
    public final void testExistsStringString() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongItemTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("Test FolderTestItem2", "test folder");
        boolean exists = this.ownerWorkspace.exists(testFolder.getName(), root.getId());
        Assert.assertTrue((String)"The test folder has not been found", (boolean)exists);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testExistsStringStringFoldeIdNull() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        this.ownerWorkspace.exists("", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testExistsStringStringNameNull() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.exists(null, root.getId());
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testExistsStringStringWrongFolderId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        this.ownerWorkspace.exists("", "");
    }

    @Test
    public final void testExistsStringStringWrongName() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        boolean exists = this.ownerWorkspace.exists("", root.getId());
        Assert.assertFalse((String)"An item with wrong name has been found", (boolean)exists);
    }

    @Test
    public final void testExistsWrongId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        boolean exists = this.ownerWorkspace.exists("");
        Assert.assertFalse((String)"Found item with wrong id", (boolean)exists);
    }

    @Test
    public final void testGetItemFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        TestDataFactory.getInstance().fillPDFDocuments(root, 1);
        WorkspaceItem item = (WorkspaceItem)root.getChildren().get(0);
        WorkspaceItem foundItem = this.ownerWorkspace.getItem(item.getId());
        Assert.assertNotNull((String)"Found item null", (Object)foundItem);
        UnitTestUtil.testWorkspaceItemEquality(item, foundItem);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetItemNullItemId() throws ItemNotFoundException {
        this.ownerWorkspace.getItem(null);
    }

    @Test
    public final void testGetItemFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem3", "A test folder");
        WorkspaceItem foundItem = this.ownerWorkspace.getItem(folder.getId());
        Assert.assertNotNull((String)"Found item null", (Object)foundItem);
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)folder, foundItem);
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testGetItemWrongItemId() throws ItemNotFoundException {
        this.ownerWorkspace.getItem("");
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testMoveDestinationNullArguments() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolderTestItem0", "A test folder");
        this.ownerWorkspace.moveItem(testFolder.getId(), null);
    }

    @Test
    public final void testMoveItemFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolderTestItem4", "This is a test folder");
        WorkspaceFolder destinationFolder = root.createFolder("TestDestinationFolder", "The destination Folder");
        WorkspaceItem item = (WorkspaceItem)TestDataFactory.getInstance().fillPDFDocuments(testFolder, 1).get(0);
        UnitTestUtil.testMoveItem(item, destinationFolder, this.ownerWorkspace);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testMoveItemDuplicateItems() throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        root.createFolder("TestItem", "TestItem duplicate");
        WorkspaceFolder testFolder = root.createFolder("TestFolderTestItem5", "This is a test folder");
        WorkspaceFolder item = testFolder.createFolder("TestItem", "TestItem");
        this.ownerWorkspace.moveItem(item.getId(), root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testMoveItemNullItemIdArguments() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.moveItem(null, root.getId());
    }

    @Test
    public final void testMoveItemFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolderTestItem6", "This is a test folder");
        WorkspaceFolder item = testFolder.createFolder("TestItemNewItem", "TestItem");
        UnitTestUtil.testMoveItem((WorkspaceItem)item, root, this.ownerWorkspace);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRemoveItemNullItemId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        this.ownerWorkspace.getRoot();
        this.ownerWorkspace.removeItem(null);
    }

    @Test
    public final void testRemoveItemFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem7", "A test folder");
        this.ownerWorkspace.removeItem(folder.getId());
        try {
            this.ownerWorkspace.getItem(folder.getId());
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        Assert.fail((String)"Item not removed");
        Assert.assertEquals((String)"Wrong number of children", (long)0L, (long)root.getChildren().size());
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testRemoveItemWrongItemId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        this.ownerWorkspace.removeItem("");
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRenameIllegalCharInNameArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem8", "A Test folder");
        String expectedName = "New" + this.ownerWorkspace.getPathSeparator() + "TestFolder";
        this.ownerWorkspace.renameItem(folder.getId(), expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRenameItemNullItemId() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        String expectedName = "NewTestFolder";
        this.ownerWorkspace.renameItem(null, expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRenameItemNullName() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem9", "A Test Workspace");
        String expectedName = null;
        this.ownerWorkspace.renameItem(folder.getId(), expectedName);
    }

    @Test
    public final void testRenameItemFolder() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem10", "A Test Workspace");
        String expectedName = "NewTestFolder";
        this.ownerWorkspace.renameItem(folder.getId(), expectedName);
        folder = (WorkspaceFolder)this.ownerWorkspace.getItem(folder.getId());
        Assert.assertEquals((String)"Item not renamed", (Object)expectedName, (Object)folder.getName());
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testRenameItemFolderSameName() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderTestItem11", "A Test Workspace");
        String expectedName = "TestFolderTestItem11";
        this.ownerWorkspace.renameItem(folder.getId(), expectedName);
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testRenameItemWrongItemId() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        String expectedName = "NewTestFolder";
        this.ownerWorkspace.renameItem("", expectedName);
    }
}

