/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.client;

import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.client.responsive.ResponsivePanel;
import org.gcube.portlets.user.joinvre.client.ui.LoadingPanel;
import org.gcube.portlets.user.joinvre.client.ui.TabPageDescription;
import org.gcube.portlets.user.joinvre.shared.TabbedPage;
import org.gcube.portlets.user.joinvre.shared.VRE;

public class JoinVRE
implements EntryPoint {
    Logger logger = Logger.getLogger(JoinVRE.class.getName());
    public static final String GET_OID_PARAMETER = "siteId";
    public static final String ORGANISATIONS_LABEL = "Organisations";
    public static final String CATEGORIES_LABEL = "Thematic areas";
    private final JoinServiceAsync joinService = (JoinServiceAsync)GWT.create(JoinService.class);
    private VerticalPanel mainPanel = new VerticalPanel();
    private TabPanel mainTabPanel = new TabPanel(Bootstrap.Tabs.ABOVE);

    public void onModuleLoad() {
        this.checkIsReferral();
    }

    private void checkIsReferral() {
        this.logger.log(Level.INFO, "checkIsReferral()");
        if (this.getSiteLiferayId() == null) {
            this.displayVREs();
        } else {
            Long vreId = -1L;
            try {
                vreId = Long.parseLong(this.getSiteLiferayId());
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "site id is not a number " + ex.getMessage());
                return;
            }
            this.joinService.getSelectedVRE(vreId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private ResponsivePanel displayVREs() {
        ResponsivePanel toReturn = new ResponsivePanel();
        this.mainPanel.setWidth("100%");
        this.mainPanel.add((Widget)toReturn);
        this.joinService.isTabbedPanel((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)"JoinVRE-Container").add((Widget)this.mainPanel);
        return toReturn;
    }

    private void showTabs(ResponsivePanel rp, List<TabbedPage> tabNames) {
        int i = 0;
        for (TabbedPage theTabPage : tabNames) {
            Tab tab2Add = new Tab();
            tab2Add.setHeading(theTabPage.getName());
            if (i == 0) {
                tab2Add.add((Widget)new TabPageDescription(theTabPage));
                tab2Add.add((Widget)rp);
                tab2Add.setActive(true);
            } else {
                tab2Add.add((Widget)new LoadingPanel());
                tab2Add.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.mainTabPanel.add((IsWidget)tab2Add);
            ++i;
        }
        this.mainTabPanel.selectTab(0);
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.mainTabPanel);
        this.addCategoriesTab(this.mainTabPanel);
        this.addOrganisationsTab(this.mainTabPanel);
    }

    private void addOrganisationsTab(TabPanel mainTabPanel) {
        this.joinService.getAllOrganisations((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addCategoriesTab(TabPanel mainTabPanel) {
        this.joinService.getAllCategories((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getSiteLiferayId() {
        return Window.Location.getParameter((String)GET_OID_PARAMETER);
    }

    private void checkInvitation(VRE vre, long groupId, ResponsivePanel rp) {
        this.joinService.isExistingInvite(groupId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ResponsivePanel access$000(JoinVRE x0) {
        return x0.displayVREs();
    }

    static /* synthetic */ void access$100(JoinVRE x0, VRE x1, long x2, ResponsivePanel x3) {
        x0.checkInvitation(x1, x2, x3);
    }

    static /* synthetic */ void access$200(JoinVRE x0, ResponsivePanel x1, List x2) {
        x0.showTabs(x1, x2);
    }
}

