/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.client.ui.InfoPanel;
import org.gcube.portlets.user.joinvre.client.ui.VreThumbnail;
import org.gcube.portlets.user.joinvre.shared.UserBelonging;
import org.gcube.portlets.user.joinvre.shared.VRE;

public class VreThumbnail
extends Composite {
    private static VreThumbnailUiBinder uiBinder = (VreThumbnailUiBinder)GWT.create(VreThumbnailUiBinder.class);
    private final JoinServiceAsync joinService = (JoinServiceAsync)GWT.create(JoinService.class);
    private static final String PUBLIC_VRE_BUTTON_LABEL = "Access this VRE";
    private static final String PRIVATE_VRE_BUTTON_LABEL = "Private";
    private static final String RESTRICTED_VRE_BUTTON_LABEL = "Request Access";
    @UiField
    Heading vreName;
    @UiField
    Image vreImage;
    @UiField
    Button joinButton;
    @UiField
    Button vreInfoButton;
    private VRE myVre;

    public VreThumbnail(VRE vre) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.myVre = vre;
        String name = vre.getName();
        if (name.length() > 22) {
            name = name.substring(0, 17) + "...";
        }
        this.vreName.setText(name);
        switch (2.$SwitchMap$org$gcube$portlets$user$joinvre$shared$VreMembershipType[vre.getMembershipType().ordinal()]) {
            case 1: {
                this.joinButton.setType(ButtonType.DEFAULT);
                this.joinButton.setText(RESTRICTED_VRE_BUTTON_LABEL);
                if (vre.getUserBelonging() != UserBelonging.PENDING) break;
                this.joinButton.setText("Waiting approval");
                this.joinButton.setType(ButtonType.WARNING);
                this.joinButton.setEnabled(false);
                break;
            }
            case 2: {
                this.joinButton.setText(PUBLIC_VRE_BUTTON_LABEL);
                break;
            }
            default: {
                this.joinButton.setEnabled(false);
                this.joinButton.setText(PRIVATE_VRE_BUTTON_LABEL);
            }
        }
        if (vre.getUserBelonging() == UserBelonging.BELONGING) {
            this.joinButton.setType(ButtonType.SUCCESS);
            this.joinButton.setText("Enter this VRE");
            this.joinButton.setEnabled(true);
        }
        this.vreImage.setUrl(vre.getImageURL());
    }

    @UiHandler(value={"joinButton"})
    void handleClick(ClickEvent e) {
        if (this.myVre.getUserBelonging() != UserBelonging.PENDING) {
            this.joinService.joinVRE(Long.valueOf(this.myVre.getId()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"vreInfoButton"})
    void infoClick(ClickEvent e) {
        if (this.myVre.getPublicURL() == null) {
            InfoPanel modal = new InfoPanel(this.myVre);
            modal.show();
        } else {
            Window.open((String)this.myVre.getPublicURL(), (String)"_blank", (String)"");
        }
    }

    public void setPending() {
        this.joinButton.setText("Waiting approval");
        this.joinButton.setType(ButtonType.WARNING);
        this.joinButton.setEnabled(false);
    }

    public VRE getMyVre() {
        return this.myVre;
    }

    static /* synthetic */ VRE access$000(VreThumbnail x0) {
        return x0.myVre;
    }
}

