/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinnew.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.user.joinnew.client.JoinNewService;
import org.gcube.portlets.user.joinnew.server.LoginServiceUtil;
import org.gcube.portlets.user.joinnew.shared.ResearchEnvironment;
import org.gcube.portlets.user.joinnew.shared.UserBelonging;
import org.gcube.portlets.user.joinnew.shared.VO;
import org.gcube.portlets.user.joinnew.shared.VRE;

public class JoinNewServiceImpl
extends RemoteServiceServlet
implements JoinNewService {
    public static final String CACHED_VOS = "CACHED_VOS";
    public String SELECTED_THEMEID = "";
    private VO rootVO = new VO();
    private boolean withinPortal = false;
    private static GCUBEClientLog _log = new GCUBEClientLog(JoinNewServiceImpl.class, new Properties[0]);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user");
            user = "test.user";
        } else {
            this.withinPortal = true;
            _log.info((Object)("LIFERAY PORTAL DETECTED user=" + user));
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ArrayList<VO> getInfrastructureVOs() {
        _log.trace((Object)"getInfrastructureVOs method called");
        if (!this.withinPortal) {
            return LoginServiceUtil.getFakeVOs();
        }
        try {
            User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            try {
                _log.info((Object)("root: " + rootOrganization.getName()));
            }
            catch (NullPointerException e) {
                _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
                return new ArrayList<VO>();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootOrganization.getName());
            this.rootVO.setGroupName("/" + rootOrganization.getName());
            this.rootVO.setRoot(true);
            Group orgGroup = rootOrganization.getGroup();
            String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
            this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
            long logoId = rootOrganization.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            this.rootVO.setImageURL(logoURL);
            if (rootOrganization.getComments() != null) {
                this.rootVO.setDescription(rootOrganization.getComments());
            }
            if (this.hasRole(this.getVoAdminRoleName(), rootOrganization.getName(), currUser)) {
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
            } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)rootOrganization.getOrganizationId())) {
                this.rootVO.setUserBelonging(UserBelonging.PENDING);
            } else {
                this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            }
            for (Organization vOrg : rootOrganization.getSuborganizations()) {
                _log.debug((Object)("FOUND VO: " + vOrg.getName()));
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getName());
                voToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName());
                voToAdd.setRoot(false);
                for (VRE vre : vOrg.getSuborganizations()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setName(vre.getName());
                    vreToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName() + "/" + vre.getName());
                    logoId = vre.getLogoId();
                    logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
                    vreToAdd.setFriendlyURL(this.getPortalBasicUrl() + vreUrl);
                    if (vre.getComments() != null) {
                        vreToAdd.setDescription(vre.getComments());
                    }
                    if (currUser.getOrganizations().contains(vre)) {
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vre.getOrganizationId())) {
                        vreToAdd.setUserBelonging(UserBelonging.PENDING);
                    } else {
                        vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                    }
                    if (currUser.getOrganizations().contains(vre)) continue;
                    voToAdd.addVRE(vreToAdd);
                }
                Group group = vOrg.getGroup();
                String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
                voToAdd.setFriendlyURL(this.getPortalBasicUrl() + url);
                if (vOrg.getComments() != null) {
                    voToAdd.setDescription(vOrg.getComments());
                }
                if (currUser.getOrganizations().contains(vOrg)) {
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vOrg.getOrganizationId())) {
                    voToAdd.setUserBelonging(UserBelonging.PENDING);
                } else {
                    voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                    _log.debug((Object)("VRE FOUND.... " + vre.getName()));
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            _log.debug((Object)"SETTING INFRASTRUCTURE VOS in ASLSession");
            this.getASLSession().setAttribute(CACHED_VOS, toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VO>();
        }
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        String gatewayName = "D4Science Gateway";
        if (this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME") != null) {
            gatewayName = this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME").toString();
            _log.debug((Object)("Gateway Label was Found=" + gatewayName));
        } else {
            _log.debug((Object)"Gateway Label Not Found");
        }
        LoginServiceUtil.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl(), (String)gatewayName);
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        _log.trace((Object)("getPortalBasicUrl: " + toReturn + "queryString: " + request.getQueryString()));
        return toReturn;
    }

    public VO getRootVO() {
        _log.debug((Object)"root called");
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.rootVO;
        }
        Organization rootOrganization = null;
        List organizations = null;
        try {
            organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (Organization organization : organizations) {
            if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        this.rootVO.setName(rootOrganization.getName());
        this.rootVO.setGroupName("/" + rootOrganization.getName());
        this.rootVO.setRoot(true);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Group orgGroup = rootOrganization.getGroup();
        String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
        this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
        return this.rootVO;
    }

    public ResearchEnvironment getSelectedRE() {
        _log.debug((Object)"getting Selected Research Environment");
        HttpSession session = this.getThreadLocalRequest().getSession();
        String selectedGroupName = this.getASLSession().getScopeName();
        ArrayList vos = (ArrayList)session.getAttribute(CACHED_VOS);
        for (VO vo : vos) {
            if (vo.getGroupName().equals(selectedGroupName)) {
                return vo;
            }
            ArrayList vres = vo.getVres();
            for (VRE vre : vres) {
                if (!vre.getGroupName().equals(selectedGroupName)) continue;
                this.setVREBelonginApplication(vre);
                return new ResearchEnvironment(vre.getName(), vre.getDescription(), vre.getImageURL(), vre.getGroupName(), vre.getFriendlyURL(), vre.getUserBelonging());
            }
        }
        return null;
    }

    private String getVoAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
            return true;
        }
        return false;
    }

    public Boolean isLayoutLoaded() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        _log.trace((Object)"Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace((Object)("User login logged to: " + scope));
    }

    private void setVREBelonginApplication(VRE vre) {
        _log.info((Object)"AvailablePortlets stored in session");
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }
}

