package org.gcube.portlets.user.joinvre.portlet;

import org.gcube.portlets.user.joinvre.constants.JoinVREPortletKeys;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.WebKeys;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import java.io.IOException;
import java.io.PrintWriter;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.gcube.portlets.user.joinvre.service.JoinVREService;

/**
 * JoinVRE Portlet - Migrated from Liferay 6.2 to 7.4
 * 
 * @author Massimiliano Assante, ISTI-CNR (original)
 * @author netfarm-m2 (migration to 7.4)
 */
@Component(
	immediate = true,
	property = {
		"com.liferay.portlet.display-category=category.gcube",
		"com.liferay.portlet.header-portlet-css=/css/main.css",
		"com.liferay.portlet.instanceable=true",
		"com.liferay.portlet.preferences-owned-by-group=true",
		"com.liferay.portlet.private-request-attributes=false",
		"com.liferay.portlet.private-session-attributes=false",
		"com.liferay.portlet.render-weight=50",
		"com.liferay.portlet.use-default-template=true",
		"javax.portlet.display-name=Join VRE",
		"javax.portlet.expiration-cache=0",
		"javax.portlet.init-param.template-path=/",
		"javax.portlet.init-param.view-template=/view.jsp",
		"javax.portlet.init-param.config-template=/config.jsp",
		"javax.portlet.name=" + JoinVREPortletKeys.JOINVRE,
		"javax.portlet.resource-bundle=content.Language",
		"javax.portlet.security-role-ref=power-user,user",
		"javax.portlet.version=3.0"
	},
	service = Portlet.class
)
public class JoinVREPortlet extends MVCPortlet {
	
	private static final Log _log = LogFactoryUtil.getLog(JoinVREPortlet.class);
	
	@Reference
	private JoinVREService joinVREService;
	
	@Override
	public void doView(RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		
		try {
			ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest.getAttribute(WebKeys.THEME_DISPLAY);
			
			// Get available VREs from the service
			java.util.List<org.gcube.portlets.user.joinvre.model.VRE> availableVREs = null;
			if (joinVREService != null) {
				availableVREs = joinVREService.getAvailableVREs();
				_log.debug("Retrieved " + (availableVREs != null ? availableVREs.size() : 0) + " VREs");
			} else {
				_log.warn("JoinVREService is not available");
			}
			
			// Set attributes for JSP
			renderRequest.setAttribute("themeDisplay", themeDisplay);
			renderRequest.setAttribute("user", themeDisplay.getUser());
			renderRequest.setAttribute("scopeGroupId", themeDisplay.getScopeGroupId());
			renderRequest.setAttribute("availableVREs", availableVREs);
			
			_log.debug("JoinVRE portlet rendering for user: " + themeDisplay.getUser().getScreenName());
			
		} catch (Exception e) {
			_log.error("Error in JoinVRE portlet doView", e);
		}
		
		// Call parent to render the JSP
		super.doView(renderRequest, renderResponse);
    }
    
    /**
     * Handle membership request actions
     */
    @ProcessAction(name = "requestMembership")
    public void requestMembership(ActionRequest actionRequest, ActionResponse actionResponse)
            throws IOException, PortletException {
        
        try {
            long vreId = ParamUtil.getLong(actionRequest, "vreId");
            
            ThemeDisplay themeDisplay = (ThemeDisplay) actionRequest.getAttribute(WebKeys.THEME_DISPLAY);
            User user = themeDisplay.getUser();
            
            _log.info("Processing membership request for VRE ID: " + vreId + " by user " + user.getScreenName());
            
            boolean ok = (joinVREService != null) && joinVREService.requestMembership(user, vreId, null);
            if (ok) {
                SessionMessages.add(actionRequest, "membership-request-sent");
            } else {
                SessionErrors.add(actionRequest, "membership-request-error");
            }
            
        } catch (Exception e) {
            _log.error("Error processing membership request", e);
            SessionErrors.add(actionRequest, "membership-request-error");
        }
    }
    
    // Rollback: keep only @ProcessAction handler as before, remove serveResource logic
    @Override
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse)
            throws IOException, PortletException {
        super.serveResource(resourceRequest, resourceResponse);
    }
}