/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.portlets.user.joinvre.model.TabbedPage;
import org.gcube.portlets.user.joinvre.model.UserBelonging;
import org.gcube.portlets.user.joinvre.model.VRE;
import org.gcube.portlets.user.joinvre.model.VRECategory;
import org.gcube.portlets.user.joinvre.service.JoinVREService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JoinVREService.class})
public class JoinVREServiceImpl
implements JoinVREService {
    private static final Log _log = LogFactoryUtil.getLog(JoinVREServiceImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    public static final String PREFIX_PUBLIC_URL = "/web";
    public static final String TABBED_LAYOUT_ATTRIBUTE = "TabbedLayout";
    public static final String TAB_NAMES_ATTRIBUTE = "TabName";
    public static final String ORGANIZATION_NAMES_ATTRIBUTE = "OrganisationName";
    public static final String ALLVRES_SESSION_ATTRIBUTE = "ALLVRES_SESSION";

    @Override
    public String joinVRE(Long vreID, User user) {
        try {
            _log.info((Object)("User " + user.getScreenName() + " joining VRE: " + vreID));
            Group group = this._groupLocalService.getGroup(vreID.longValue());
            return PREFIX_PUBLIC_URL + group.getFriendlyURL();
        }
        catch (Exception e) {
            _log.error((Object)("Error joining VRE " + vreID + " for user " + user.getScreenName()), (Throwable)e);
            return "";
        }
    }

    @Override
    public Object readInvite(String inviteId, long siteId) {
        try {
            _log.info((Object)("Reading invite: " + inviteId + " for site: " + siteId));
            return this.createMockUserInfo(inviteId, siteId);
        }
        catch (Exception e) {
            _log.error((Object)("Error reading invite " + inviteId), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getTermsOfUse(long siteId) {
        try {
            _log.debug((Object)("Getting Terms of Use for site: " + siteId));
            Group group = this._groupLocalService.getGroup(siteId);
            return "Terms of Use for " + group.getName() + " (Mock implementation)";
        }
        catch (Exception e) {
            _log.error((Object)("Error getting Terms of Use for site " + siteId), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<TabbedPage> isTabbedPanel(long groupId) {
        try {
            _log.debug((Object)("Checking if group " + groupId + " is tabbed panel"));
            ArrayList<TabbedPage> tabs = new ArrayList<TabbedPage>();
            tabs.add(new TabbedPage("Home", "/web/guest", "Home page", true));
            tabs.add(new TabbedPage("Workspace", "/group/workspace", "Workspace", false));
            return tabs;
        }
        catch (Exception e) {
            _log.error((Object)("Error checking tabbed panel for group " + groupId), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<VRE> getAllVREs(User user) {
        try {
            _log.info((Object)("Getting all VREs for user: " + user.getScreenName()));
            ArrayList<VRE> vres = new ArrayList<VRE>();
            List allGroups = this._groupLocalService.getActiveGroups(this._portal.getDefaultCompanyId(), true);
            List userGroups = this._groupLocalService.getUserGroups(user.getUserId());
            for (Group group : allGroups) {
                if (!group.isSite() || group.isControlPanel() || group.isCompany() || group.isGuest() || group.isUser() || group.isUserGroup() || !group.isActive() || group.getGroupId() == user.getGroupId()) continue;
                String vreName = group.getDescriptiveName(LocaleUtil.getDefault());
                String vreDescription = this.getGroupDescription(group);
                String vreCategory = this.getGroupCategory(group);
                VRE vre = new VRE();
                vre.setId(group.getGroupId());
                vre.setName(vreName);
                vre.setDescription(vreDescription);
                vre.setUrl(PREFIX_PUBLIC_URL + group.getFriendlyURL());
                vre.setPublic(this.hasPublicPages(group));
                vre.setOpen(this.isOpenMembership(group));
                vre.setMembersCount(this.getUsersCount(group));
                vre.setCategoryName(vreCategory);
                UserBelonging belonging = new UserBelonging();
                belonging.setUserId(user.getUserId());
                belonging.setVreId(group.getGroupId());
                if (userGroups.contains(group)) {
                    belonging.setMembershipType(UserBelonging.MembershipType.MEMBER);
                    belonging.setCanJoin(false);
                    belonging.setCanRequest(false);
                } else {
                    belonging.setMembershipType(UserBelonging.MembershipType.NOT_MEMBER);
                    belonging.setCanJoin(this.isOpenMembership(group));
                    belonging.setCanRequest(true);
                }
                vre.setUserBelonging(belonging);
                try {
                    String logoURL = this.getGroupLogoURL(group);
                    vre.setThumbnailURL(logoURL);
                }
                catch (Exception e) {
                    vre.setThumbnailURL(null);
                    _log.debug((Object)("Could not get thumbnail for group " + group.getName()), (Throwable)e);
                }
                vres.add(vre);
                _log.debug((Object)("Added VRE: " + vre.getName() + " (ID: " + vre.getId() + ")"));
            }
            _log.info((Object)("Found " + vres.size() + " VREs for user: " + user.getScreenName()));
            return vres;
        }
        catch (Exception e) {
            _log.error((Object)("Error getting VREs for user " + user.getScreenName()), (Throwable)e);
            return new ArrayList<VRE>();
        }
    }

    @Override
    public List<VRE> getAvailableVREs() {
        try {
            _log.info((Object)"Getting available VREs (public access)");
            ArrayList<VRE> vres = new ArrayList<VRE>();
            List allGroups = this._groupLocalService.getActiveGroups(this._portal.getDefaultCompanyId(), true);
            for (Group group : allGroups) {
                if (!group.isSite() || group.isControlPanel() || group.isCompany() || group.isGuest() || group.isUser() || group.isUserGroup() || !group.isActive()) continue;
                String vreName = group.getName();
                String vreDescription = this.getGroupDescription(group);
                String vreCategory = this.getGroupCategory(group);
                boolean publicPages = this.hasPublicPages(group);
                boolean openMembership = this.isOpenMembership(group);
                String friendlyURL = PREFIX_PUBLIC_URL + group.getFriendlyURL();
                String membershipType = "PRIVATE";
                if (openMembership) {
                    membershipType = "OPEN";
                } else if (publicPages) {
                    membershipType = "RESTRICTED";
                }
                UserBelonging defaultBelonging = new UserBelonging();
                defaultBelonging.setMembershipType(UserBelonging.MembershipType.NOT_MEMBER);
                defaultBelonging.setCanJoin(openMembership);
                defaultBelonging.setCanRequest(true);
                VRE vre = new VRE(group.getGroupId(), vreName, vreDescription, this.getGroupLogoURL(group), friendlyURL, publicPages, openMembership, this.getUsersCount(group), vreCategory, defaultBelonging, membershipType, publicPages, friendlyURL);
                vres.add(vre);
                _log.debug((Object)("Added VRE: " + vre.getName() + " (ID: " + vre.getId() + ")"));
            }
            _log.info((Object)("Found " + vres.size() + " available VREs"));
            return vres;
        }
        catch (Exception e) {
            _log.error((Object)"Error getting available VREs", (Throwable)e);
            return new ArrayList<VRE>();
        }
    }

    private String getGroupDescription(Group group) {
        String description = group.getDescription();
        if (description != null && !description.trim().isEmpty()) {
            return description;
        }
        return this.generateVREDescription(group.getName(), null);
    }

    private String getGroupCategory(Group group) {
        try {
            String category = group.getTypeSettingsProperty("category");
            if (category != null && !category.isEmpty()) {
                return category;
            }
        }
        catch (Exception e) {
            _log.debug((Object)("No category found for group: " + group.getName()));
        }
        return this.generateVRECategory(group.getName());
    }

    private boolean hasPublicPages(Group group) {
        try {
            return group.getPublicLayoutsPageCount() > 0;
        }
        catch (Exception e) {
            _log.debug((Object)("Error checking public pages for group: " + group.getName()));
            return false;
        }
    }

    private boolean isOpenMembership(Group group) {
        try {
            return group.getType() == 1;
        }
        catch (Exception e) {
            _log.debug((Object)("Error checking membership type for group: " + group.getName()));
            return false;
        }
    }

    private int getUsersCount(Group group) {
        try {
            return this._userLocalService.getGroupUsersCount(group.getGroupId());
        }
        catch (Exception e) {
            _log.debug((Object)("Error getting users count for group: " + group.getName()));
            return 0;
        }
    }

    private String getGroupLogoURL(Group group) {
        try {
            LayoutSet privateLayoutSet;
            long logoId = 0L;
            LayoutSet publicLayoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
            if (publicLayoutSet != null) {
                logoId = publicLayoutSet.getLogoId();
            }
            if (logoId <= 0L && (privateLayoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), true)) != null) {
                logoId = privateLayoutSet.getLogoId();
            }
            if (logoId > 0L) {
                String token = WebServerServletTokenUtil.getToken((long)logoId);
                String pathImage = PortalUtil.getPathImage();
                return pathImage + "/group_logo?img_id=" + logoId + "&t=" + token;
            }
        }
        catch (Exception e) {
            _log.debug((Object)("Error getting logo URL for group: " + group.getName()), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<VRECategory> getVRECategories() {
        try {
            _log.debug((Object)"Getting VRE categories");
            ArrayList<VRECategory> categories = new ArrayList<VRECategory>();
            List allGroups = this._groupLocalService.getActiveGroups(this._portal.getDefaultCompanyId(), true);
            HashSet<String> categoryNames = new HashSet<String>();
            for (Group group : allGroups) {
                if (!group.isSite() || group.isControlPanel() || group.isCompany() || group.isGuest() || group.isUser() || group.isUserGroup() || !group.isActive()) continue;
                String categoryName = this.getGroupCategory(group);
                categoryNames.add(categoryName);
            }
            for (String categoryName : categoryNames) {
                VRECategory category = new VRECategory();
                category.setName(categoryName);
                category.setDescription(this.getCategoryDescription(categoryName));
                category.setVres(new ArrayList<VRE>());
                categories.add(category);
            }
            categories.sort((c1, c2) -> c1.getName().compareTo(c2.getName()));
            _log.debug((Object)("Found " + categories.size() + " VRE categories"));
            return categories;
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VRE categories", (Throwable)e);
            return new ArrayList<VRECategory>();
        }
    }

    private String getCategoryDescription(String categoryName) {
        switch (categoryName) {
            case "Testing & Validation": {
                return "Environments for testing and validating research methodologies";
            }
            case "Environmental Sciences": {
                return "Research environments focused on environmental and sustainability studies";
            }
            case "Development & Innovation": {
                return "Platforms for developing next-generation research tools";
            }
            case "Data Management": {
                return "Comprehensive data management and analysis environments";
            }
            case "Life Sciences": {
                return "Research environments for biological and life science studies";
            }
            case "Earth Sciences": {
                return "Platforms for geological and earth science research";
            }
            case "Social Sciences": {
                return "Collaborative environments for social science research";
            }
        }
        return "Research and development environments for " + categoryName.toLowerCase();
    }

    @Override
    public UserBelonging getUserBelonging(User user, long vreId) {
        try {
            _log.debug((Object)("Getting user belonging for user " + user.getScreenName() + " and VRE " + vreId));
            boolean isMember = this._groupLocalService.hasUserGroup(user.getUserId(), vreId);
            UserBelonging belonging = new UserBelonging();
            belonging.setUserId(user.getUserId());
            belonging.setVreId(vreId);
            if (isMember) {
                belonging.setMembershipType(UserBelonging.MembershipType.MEMBER);
                belonging.setCanJoin(false);
                belonging.setCanRequest(false);
            } else {
                belonging.setMembershipType(UserBelonging.MembershipType.NOT_MEMBER);
                belonging.setCanJoin(true);
                belonging.setCanRequest(true);
            }
            return belonging;
        }
        catch (Exception e) {
            _log.error((Object)"Error getting user belonging", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean requestMembership(User user, long vreId, String comments) {
        try {
            _log.info((Object)("User " + user.getScreenName() + " requesting membership to VRE " + vreId));
            Group group = this._groupLocalService.getGroup(vreId);
            if (!group.isActive()) {
                _log.warn((Object)("Cannot request membership to inactive group: " + vreId));
                return false;
            }
            if (this.isOpenMembership(group)) {
                this._userLocalService.addGroupUser(vreId, user.getUserId());
                _log.info((Object)("User " + user.getScreenName() + " added directly to open VRE " + vreId));
                return true;
            }
            _log.info((Object)("Membership request logged for manual processing: User " + user.getScreenName() + " -> VRE " + group.getName() + " (" + vreId + ")"));
            if (comments != null && !comments.trim().isEmpty()) {
                _log.info((Object)("Request comments: " + comments));
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)("Error requesting membership for user " + user.getScreenName() + " to VRE " + vreId), (Throwable)e);
            return false;
        }
    }

    private Object createMockUserInfo(final String inviteId, final long siteId) {
        try {
            User invitedUser = null;
            try {
                invitedUser = this._userLocalService.getUserByEmailAddress(this._portal.getDefaultCompanyId(), inviteId);
            }
            catch (Exception e) {
                try {
                    invitedUser = this._userLocalService.getUserByScreenName(this._portal.getDefaultCompanyId(), inviteId);
                }
                catch (Exception e2) {
                    _log.debug((Object)("User not found for invite ID: " + inviteId));
                }
            }
            final User finalUser = invitedUser;
            Group site = this._groupLocalService.getGroup(siteId);
            return new Object(){

                public String getUsername() {
                    return finalUser != null ? finalUser.getScreenName() : inviteId;
                }

                public String getFullname() {
                    return finalUser != null ? finalUser.getFullName() : "Invited User";
                }

                public String getUserAvatarURL() {
                    if (finalUser != null) {
                        try {
                            return finalUser.getPortraitURL(null);
                        }
                        catch (PortalException e) {
                            _log.debug((Object)("Error getting portrait URL for user: " + finalUser.getScreenName()));
                            return "/images/user_portrait.png";
                        }
                    }
                    return "/images/user_portrait.png";
                }

                public String getAccountURL() {
                    return finalUser != null ? "/web/" + finalUser.getScreenName() : "";
                }

                public String getTermsOfUse() {
                    return JoinVREServiceImpl.this.getTermsOfUse(siteId);
                }

                public boolean isOnline() {
                    return finalUser != null && finalUser.isActive();
                }

                public boolean isAway() {
                    return false;
                }
            };
        }
        catch (Exception e) {
            _log.error((Object)("Error creating user info for invite " + inviteId), (Throwable)e);
            return this.createFallbackUserInfo(inviteId, siteId);
        }
    }

    private Object createFallbackUserInfo(final String inviteId, final long siteId) {
        return new Object(){

            public String getUsername() {
                return inviteId;
            }

            public String getFullname() {
                return "Invited User";
            }

            public String getUserAvatarURL() {
                return "/images/user_portrait.png";
            }

            public String getAccountURL() {
                return "";
            }

            public String getTermsOfUse() {
                return JoinVREServiceImpl.this.getTermsOfUse(siteId);
            }

            public boolean isOnline() {
                return false;
            }

            public boolean isAway() {
                return false;
            }
        };
    }

    private String generateVREDescription(String vreName, String existingDescription) {
        if (existingDescription != null && !existingDescription.trim().isEmpty() && !existingDescription.equals(vreName)) {
            return existingDescription;
        }
        String lowerName = vreName.toLowerCase();
        if (lowerName.contains("gateway") || lowerName.contains("test")) {
            return "A test environment for exploring and validating research methodologies, providing researchers with tools and resources for experimental activities in a controlled setting.";
        }
        if (lowerName.contains("cloud") || lowerName.contains("green")) {
            return "A development environment focused on cloud computing and sustainable technologies, supporting research in environmental sciences and green computing initiatives.";
        }
        if (lowerName.contains("next") || lowerName.contains("dev")) {
            return "A development platform for next-generation research tools and methodologies, providing cutting-edge resources for innovative scientific projects.";
        }
        if (lowerName.contains("data") || lowerName.contains("catalogue")) {
            return "A comprehensive data management environment providing tools for data discovery, cataloguing, and analysis across multiple research domains and disciplines.";
        }
        return "A collaborative research environment providing specialized tools and resources for scientific research and data analysis in the " + vreName + " domain.";
    }

    private String generateVRECategory(String vreName) {
        String lowerName = vreName.toLowerCase();
        if (lowerName.contains("gateway") || lowerName.contains("test")) {
            return "Testing & Validation";
        }
        if (lowerName.contains("cloud") || lowerName.contains("green")) {
            return "Environmental Sciences";
        }
        if (lowerName.contains("next") || lowerName.contains("dev")) {
            return "Development & Innovation";
        }
        if (lowerName.contains("data") || lowerName.contains("catalogue")) {
            return "Data Management";
        }
        if (lowerName.contains("bio") || lowerName.contains("life")) {
            return "Life Sciences";
        }
        if (lowerName.contains("geo") || lowerName.contains("earth")) {
            return "Earth Sciences";
        }
        if (lowerName.contains("social") || lowerName.contains("humanities")) {
            return "Social Sciences";
        }
        return "Research & Development";
    }
}

