<%@ include file="/init.jsp" %>

<%@ page import="java.util.List" %>
<%@ page import="java.util.Set" %>
<%@ page import="java.util.LinkedHashSet" %>
<%@ page import="org.gcube.portlets.user.joinvre.model.VRE" %>
<%@ page import="com.liferay.portal.kernel.util.LocalizationUtil" %>
<%@ page import="com.liferay.portal.kernel.util.LocaleUtil" %>

<!-- Include CSS for portlet styling -->
<link rel="stylesheet" href="<%= request.getContextPath() %>/css/main.css" />

<div class="join-vre-portlet join-vre-wrapper">
    <%
    // Get VREs from request attribute (set by the portlet)
    List<VRE> vres = (List<VRE>) request.getAttribute("availableVREs");
    // Build distinct category set preserving insertion order
    Set<String> categories = new LinkedHashSet<>();
    if (vres != null) {
        for (VRE v : vres) {
            if (v.getCategoryName() != null && !v.getCategoryName().isEmpty()) {
                categories.add(v.getCategoryName());
            }
        }
    }
    %>
    
    <!-- Page Header -->
    <div class="page-header">
        <h1>
            <liferay-ui:message key="explore-virtual-research-environments" />
            <small><liferay-ui:message key="discover-and-join-research-communities" /></small>
        </h1>
    </div>
    
    <!-- Category Filter -->
    <div class="category-filter">
        <div class="filter-title">
            <liferay-ui:message key="filter-by-category" />
        </div>
        <div class="category-buttons">
            <button class="category-btn active" data-category="all">
                <liferay-ui:message key="all-categories" />
            </button>
            <% for (String cat : categories) { %>
                <button class="category-btn" data-category="<%= HtmlUtil.escapeAttribute(cat) %>">
                    <%= HtmlUtil.escape(cat) %>
                </button>
            <% } %>
        </div>
    </div>
    
    <!-- VRE Container -->
    <div id="vre-container">
        <% if (vres != null && !vres.isEmpty()) { %>
            <div class="row">
                <% for (VRE vre : vres) { %>
                    <%
                        // Resolve VRE name using the default locale from Liferay's localization XML if present
                        String rawName = vre.getName();
                        String localizedCandidate = null;
                        try {
                            localizedCandidate = LocalizationUtil.getLocalization(
                                rawName,
                                LocaleUtil.toLanguageId(LocaleUtil.getDefault())
                            );
                        } catch (Exception e) {
                            // ignore and fallback to rawName
                        }
                        String localizedName = HtmlUtil.escape(
                            Validator.isNotNull(localizedCandidate) ? localizedCandidate : rawName
                        );
                    %>
                    <div class="col-md-6 col-lg-4">
                        <div class="card vre-card" data-category="<%= HtmlUtil.escapeAttribute(vre.getCategoryName()) %>">
                            <div class="vre-card-header">
                                <div class="vre-image-box">
                                    <img src="<%= vre.getThumbnailURL() %>" alt="<%= localizedName %> logo" class="vre-logo" onerror="this.onerror=null;this.src='<%= request.getContextPath() %>/images/liferay-logo.svg';" />
                                </div>

                                <div class="vre-card-title">
                                    <h4 class="vre-name"><%= localizedName %></h4>
                                </div>
                            </div>
                            <div class="vre-card-body">
                                <p class="vre-description"><%= HtmlUtil.stripHtml(vre.getDescription()) %></p>
                                <div class="vre-card-meta">
                                    <span class="members-count"><%= vre.getMembersCount() %> members</span>
                                    <% if (vre.isOpen()) { %>
                                        <span class="vre-status open">OPEN</span>
                                    <% } else if (vre.isPublic()) { %>
                                        <span class="vre-status public">PUBLIC</span>
                                    <% } else { %>
                                        <span class="vre-status private">PRIVATE</span>
                                    <% } %>
                                </div>
                            </div>
                            <div class="vre-card-actions">
                                <a href="<%= vre.getUrl() %>" class="btn btn-primary" target="_blank">
                                    <liferay-ui:message key="visit-vre" />
                                </a>
                                <% if (vre.getUserBelongingObject() != null && vre.getUserBelongingObject().isCanRequest()) { %>
                                    <button class="btn btn-outline-secondary request-membership-btn" 
                                            onclick="requestMembershipConfirm('<%= vre.getId() %>', this, '<%= localizedName %>')"
                                            data-vre-id="<%= vre.getId() %>"
                                            data-vre-name="<%= localizedName %>">
                                        <liferay-ui:message key="request-membership" />
                                    </button>
                                <% } else if (vre.getUserBelongingObject() != null && vre.getUserBelongingObject().isCanJoin()) { %>
                                    <a href="<%= vre.getUrl() %>" class="btn btn-success">
                                        <liferay-ui:message key="enter-vre" />
                                    </a>
                                <% } else { %>
                                    <button class="btn btn-secondary" disabled>
                                        <liferay-ui:message key="membership-pending" />
                                    </button>
                                <% } %>
                            </div>
                        </div>
                    </div>
                <% } %>
            </div>
        <% } else { %>
            <div class="empty-state">
                <h3><liferay-ui:message key="no-vres-found" /></h3>
                <p><liferay-ui:message key="no-vres-available-description" /></p>
            </div>
        <% } %>
    </div>

    <!-- Loading Indicator -->
    <div id="loading-indicator" class="loading-spinner" style="display: none;">
        <i class="icon-spinner icon-spin"></i>
        <div><liferay-ui:message key="loading-vres" /></div>
    </div>

    <!-- Notification Area -->
    <div id="notification-area"></div>
</div>

<!-- Include JavaScript for portlet functionality -->
<script src="<%= request.getContextPath() %>/js/main.js"></script>

<script type="text/javascript">
    // Global configuration for JoinVRE
    window.JoinVREConfig = {
        portletNamespace: '<portlet:namespace />',
        userId: '<%= themeDisplay.getUserId() %>',
        groupId: '<%= themeDisplay.getScopeGroupId() %>',
        companyId: '<%= themeDisplay.getCompanyId() %>',
        pathThemeImages: '<%= themeDisplay.getPathThemeImages() %>',
        contextPath: '<%= request.getContextPath() %>',
        actionURL: '<portlet:actionURL name="requestMembership" />'
    };
    
    // Category filter functionality
    document.addEventListener('DOMContentLoaded', function() {
        var categoryButtons = document.querySelectorAll('.category-btn');
        var vreCards = document.querySelectorAll('.vre-card');
        
        categoryButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var category = this.getAttribute('data-category');
                
                // Update active button
                categoryButtons.forEach(function(btn) {
                    btn.classList.remove('active');
                });
                this.classList.add('active');
                
                // Filter VRE cards
                vreCards.forEach(function(card) {
                    if (category === 'all' || card.getAttribute('data-category') === category) {
                        card.parentElement.style.display = 'block';
                    } else {
                        card.parentElement.style.display = 'none';
                    }
                });
            });
        });
    });

    // Confirmation wrapper delegating to main.js
    function requestMembershipConfirm(vreId, buttonEl, vreName) {
        if (confirm('Do you want to request membership for ' + vreName + '?')) {
            if (window.requestMembership) {
                window.requestMembership(vreId, buttonEl);
            } else {
                console.error('requestMembership function not found');
            }
        }
    }
</script>
