/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.client.view.message;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.WidgetComponent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridViewConfig;
import com.extjs.gxt.ui.client.widget.grid.filters.DateFilter;
import com.extjs.gxt.ui.client.widget.grid.filters.Filter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.grid.filters.StringFilter;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.gcube.portlets.user.messages.client.ConstantsPortletMessages;
import org.gcube.portlets.user.messages.client.MessagesApplicationController;
import org.gcube.portlets.user.messages.client.resources.Resources;
import org.gcube.portlets.user.messages.client.view.message.ContextMenuMessages;
import org.gcube.portlets.user.messages.client.view.message.attach.AttachButton;
import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.GXTFolderItemTypeEnum;
import org.gcube.portlets.user.messages.shared.MessageModel;

public class GxtGridMessagesFilterPanel
extends LayoutContainer {
    private ContentPanel cpMessages = new ContentPanel();
    private ContentPanel cpBody = new ContentPanel();
    private ContentPanel north = new ContentPanel();
    private ContentPanel center = new ContentPanel();
    private ListStore<MessageModel> store = new ListStore();
    private Grid<MessageModel> gridMessages;
    private ContextMenuMessages contextMenuMessages;
    private List<Integer> rowBold = new ArrayList();
    private TextArea textBodyValue = new TextArea();
    private String emptyBody = "\nSelect a message...";
    private String headerTitle;
    private String emptyTilte = "From/To: empty - Date: empty";
    private ToolBar toolBarAttachs = new ToolBar();
    private Button buttSaveAttachs = new Button("Save Attachments");
    private static int MAX_LENGTH = 30;
    private int attachButtonWidth = 200;
    private int attachButtonHeight = 23;
    private String currentMessageType = null;
    private HandlerManager eventBus = MessagesApplicationController.getEventBus();

    public GxtGridMessagesFilterPanel() {
        this.textBodyValue.setText(this.emptyBody);
        this.textBodyValue.setSize("99%", "99%");
        this.textBodyValue.getElement().getStyle().setBorderStyle(Style.BorderStyle.NONE);
        this.headerTitle = this.emptyTilte;
        this.initGridMessagesPanel();
        this.addContextMenu();
        this.addListnerOnContextMenu();
        this.createButtonSaveAttach();
    }

    public List<MessageModel> getMessagesSelected() {
        List selected = this.gridMessages.getSelectionModel().getSelectedItems();
        if (selected != null && selected.size() > 0) {
            return selected;
        }
        return null;
    }

    private void addContextMenu() {
        this.contextMenuMessages = new ContextMenuMessages(this.gridMessages);
    }

    private void initGridMessagesPanel() {
        BorderLayout layout = new BorderLayout();
        this.setLayout((Layout)layout);
        ColumnConfig subject = new ColumnConfig("Subject", "Subject", 300);
        ColumnConfig fromLogin = new ColumnConfig("From", "From", 100);
        ColumnConfig sentDate = new ColumnConfig("Date", "Date", 100);
        ColumnConfig numAttachs = new ColumnConfig("Attachs", "Attachs", 100);
        ColumnModel cm = new ColumnModel(Arrays.asList(subject, fromLogin, sentDate, numAttachs));
        this.cpMessages.setBodyBorder(false);
        this.cpMessages.setHeaderVisible(false);
        this.cpMessages.setLayout((Layout)new FitLayout());
        GridFilters filters = new GridFilters();
        filters.setLocal(true);
        StringFilter subjectFilter = new StringFilter("Subject");
        StringFilter fromFilter = new StringFilter("From");
        DateFilter dateFilter = new DateFilter("Date");
        StringFilter attachFilter = new StringFilter("Attachs");
        filters.addFilter((Filter)subjectFilter);
        filters.addFilter((Filter)fromFilter);
        filters.addFilter((Filter)dateFilter);
        filters.addFilter((Filter)attachFilter);
        this.gridMessages = new Grid(this.store, cm);
        this.store.sort("Date", Style.SortDir.DESC);
        this.gridMessages.getView().setViewConfig((GridViewConfig)new /* Unavailable Anonymous Inner Class!! */);
        this.gridMessages.getView().setAutoFill(true);
        this.gridMessages.getView().setForceFit(true);
        this.gridMessages.getView().setEmptyText("EMPTY");
        this.gridMessages.setBorders(false);
        this.gridMessages.setStripeRows(true);
        this.gridMessages.setColumnLines(true);
        this.gridMessages.addPlugin((ComponentPlugin)filters);
        this.gridMessages.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.gridMessages.addListener(Events.RowDoubleClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.gridMessages.addListener(Events.RowClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.cpMessages.add((Widget)this.gridMessages);
        this.cpMessages.setScrollMode(Style.Scroll.AUTOY);
        this.north.setLayout((Layout)new FitLayout());
        this.north.setHeaderVisible(false);
        this.north.add((Widget)this.cpMessages);
        this.center.setLayout((Layout)new FitLayout());
        this.center.setHeaderVisible(true);
        this.center.setHeading(this.headerTitle);
        this.resetToolBarAttach();
        this.toolBarAttachs.setEnabled(false);
        this.toolBarAttachs.setHeight(this.attachButtonHeight + 5);
        this.center.setTopComponent((Component)this.toolBarAttachs);
        this.cpBody.add((Widget)this.textBodyValue);
        this.cpBody.setHeaderVisible(false);
        this.cpBody.setStyleAttribute("padding", "5px");
        this.cpBody.setBodyBorder(false);
        this.cpBody.setScrollMode(Style.Scroll.AUTOY);
        this.center.add((Widget)this.cpBody);
        BorderLayoutData northData = new BorderLayoutData(Style.LayoutRegion.NORTH, 200.0f, 100, 300);
        northData.setCollapsible(true);
        northData.setFloatable(true);
        northData.setHideCollapseTool(true);
        northData.setSplit(true);
        northData.setMargins(new Margins(0));
        BorderLayoutData centerData = new BorderLayoutData(Style.LayoutRegion.CENTER);
        centerData.setMargins(new Margins(0));
        this.add((Widget)this.north, (LayoutData)northData);
        this.add((Widget)this.center, (LayoutData)centerData);
    }

    private void addListnerOnContextMenu() {
        this.gridMessages.addListener(Events.ContextMenu, (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void resetStore() {
        this.store.removeAll();
    }

    public boolean updateStore(List<MessageModel> result) {
        this.rowBold.clear();
        this.resetStore();
        if (result != null) {
            this.store.add(result);
            return true;
        }
        return false;
    }

    public boolean deleteMessage(String identifier) {
        MessageModel messageTarget = this.getMessagedModelByIdentifier(identifier);
        if (messageTarget != null) {
            Record record = this.store.getRecord((ModelData)messageTarget);
            this.store.remove((ModelData)((MessageModel)record.getModel()));
            return true;
        }
        System.out.println("Delete Error: messageTextArea target with " + identifier + " identifier not exist in store");
        return false;
    }

    public MessageModel getMessagedModelByIdentifier(String id) {
        return (MessageModel)this.store.findModel("id", (Object)id);
    }

    public ListStore<MessageModel> getStore() {
        return this.store;
    }

    public void markMessageAsRead(String id, boolean isRead) {
        MessageModel messageTarget = this.getMessagedModelByIdentifier(id);
        if (messageTarget != null) {
            messageTarget.set("IsRead", (Object)("" + isRead));
            this.store.update((ModelData)messageTarget);
        } else {
            System.out.println("Mark Message As Read" + id + " identifier not exist in store");
        }
    }

    public void setBodyValue(String subject, String body) {
        String text = "\nSubject: " + subject + "\n";
        text = text + "\n\n";
        text = text + body;
        this.textBodyValue.setText(text);
    }

    public void resetBody() {
        this.textBodyValue.setText(this.emptyBody);
    }

    public void resetTitle() {
        this.headerTitle = this.emptyTilte;
        this.center.setHeading(this.headerTitle);
    }

    public void setFromTitle(String from, String date, List<String> listTo) {
        this.headerTitle = "From: " + from + "  - Date: " + date + " - To: " + this.getToContact(listTo);
        this.center.setHeading(this.headerTitle);
    }

    public void setToTitle(List<String> listTo, String date) {
        this.headerTitle = "To: " + this.getToContact(listTo);
        this.headerTitle = this.headerTitle + "  - Date: " + date;
        this.center.setHeading(this.headerTitle);
    }

    private String getToContact(List<String> listTo) {
        String toContact = "";
        for (String to : listTo) {
            if (to.length() > MAX_LENGTH) {
                to = to.substring(0, MAX_LENGTH - 1);
                to = to + "...";
            }
            toContact = toContact + to + ";";
        }
        return toContact;
    }

    private void resetToolBarAttach() {
        this.toolBarAttachs.removeAll();
        WidgetComponent imageAttachs = new WidgetComponent((Widget)new Image(Resources.getImageAttachs()));
        this.toolBarAttachs.add((Component)imageAttachs);
    }

    public void setAttachs(List<FileModel> attachs) {
        this.resetToolBarAttach();
        if (attachs == null || attachs.size() == 0) {
            this.toolBarAttachs.setEnabled(false);
            return;
        }
        this.toolBarAttachs.setEnabled(true);
        for (FileModel item : attachs) {
            String itemName = item.getName();
            if (item.getName().length() > MAX_LENGTH) {
                itemName = item.getName().substring(0, MAX_LENGTH - 1);
                itemName = itemName + "...";
            }
            String tooltip = "";
            boolean enabled = true;
            if (!item.isDirectory()) {
                tooltip = "SHOW - " + item.getName();
            } else {
                enabled = false;
            }
            ConstantsPortletMessages.messagesLogger.log(Level.INFO, "in addAttachs item get type : " + item.getType());
            AbstractImagePrototype img = item.isDirectory() ? Resources.getIconFolder() : (item.getType() != null ? Resources.getIconByType((String)item.getType()) : Resources.getIconByFolderItemType((GXTFolderItemTypeEnum)item.getGXTFolderItemType()));
            AttachButton butt = new AttachButton(itemName, tooltip, img);
            butt.setEnabled(enabled);
            butt.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.toolBarAttachs.add((Component)butt);
        }
        this.toolBarAttachs.add((Component)new FillToolItem());
        this.toolBarAttachs.add((Component)this.buttSaveAttachs);
    }

    private void createButtonSaveAttach() {
        this.buttSaveAttachs.setIcon(Resources.getIconSaveAttachments());
        this.buttSaveAttachs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Grid<MessageModel> getGridMessages() {
        return this.gridMessages;
    }

    public void setMessagesType(String messageType) {
        this.currentMessageType = messageType;
    }

    public String getCurrentMessageType() {
        return this.currentMessageType;
    }

    public void setBorderAsOnSearch(boolean bool) {
        if (this.north.getElement("body") != null) {
            if (bool) {
                this.north.getElement("body").getStyle().setBorderColor("#32CD32");
            } else {
                this.north.getElement("body").getStyle().setBorderColor("#99BBE8");
            }
        }
    }

    static /* synthetic */ void access$000(GxtGridMessagesFilterPanel x0) {
        x0.resetToolBarAttach();
    }

    static /* synthetic */ ToolBar access$100(GxtGridMessagesFilterPanel x0) {
        return x0.toolBarAttachs;
    }

    static /* synthetic */ HandlerManager access$200(GxtGridMessagesFilterPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ ContextMenuMessages access$300(GxtGridMessagesFilterPanel x0) {
        return x0.contextMenuMessages;
    }

    static /* synthetic */ Grid access$400(GxtGridMessagesFilterPanel x0) {
        return x0.gridMessages;
    }
}

