/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.panels;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.client.FilterType;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.client.NewsServiceAsync;
import org.gcube.portlets.user.newsfeed.client.event.AddCommentEvent;
import org.gcube.portlets.user.newsfeed.client.event.AddLikeEvent;
import org.gcube.portlets.user.newsfeed.client.event.DeleteCommentEvent;
import org.gcube.portlets.user.newsfeed.client.event.DeleteFeedEvent;
import org.gcube.portlets.user.newsfeed.client.event.EditCommentEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeCommentsEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeLikesEvent;
import org.gcube.portlets.user.newsfeed.client.event.ShowNewUpdatesEvent;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.templates.FilterPanel;
import org.gcube.portlets.user.newsfeed.client.templates.NewFeedsAvailable;
import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;
import org.gcube.portlets.user.newsfeed.shared.EnhancedFeed;

public class NewsFeedPanel
extends Composite {
    private final NewsServiceAsync newsService = (NewsServiceAsync)GWT.create(NewsService.class);
    private final HandlerManager eventBus = new HandlerManager(null);
    private VerticalPanel mainPanel = new VerticalPanel();
    private HorizontalPanel filterPanelWrapper = new HorizontalPanel();
    private FilterPanel filterPanel;
    private SimplePanel newUpdatesPanel = new SimplePanel();
    private VerticalPanel newsPanel = new VerticalPanel();
    private NewFeedsAvailable newsFeedAlert;
    private static final String warning = GWT.getModuleBaseURL() + "../images/warning_blue.png";
    private static final String spacer = GWT.getModuleBaseURL() + "../images/feeds-spacer.gif";
    public static final String loading = GWT.getModuleBaseURL() + "../images/feeds-loader.gif";
    public static final String GET_OID_PARAMETER = "oid";
    public static final String LIKE_LABEL = "Favorite";
    public static final String LIKED_LABEL = "Favorited";
    public static final String COMMENT_LABEL = "Reply";
    public static final String MESSAGE_LABEL = "Message";
    private int delayMillis = 300000;
    private int currNewUpdatesNo = 0;
    private boolean isFirstTweet = false;
    private static final int feedsNoPerCategory = 10;
    private Image loadingImage;
    private UserInfo myUserInfo;
    private FilterType currentFilter;
    private Timer feedsTimer;
    private ArrayList<EnhancedFeed> allUpdates = new ArrayList();
    private ArrayList<EnhancedFeed> tempCacheNewUpdates = new ArrayList();

    private void bind() {
        this.eventBus.addHandler(ShowNewUpdatesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AddLikeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AddCommentEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(EditCommentEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(SeeLikesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(SeeCommentsEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(DeleteCommentEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(DeleteFeedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public NewsFeedPanel() {
        this.bind();
        this.mainPanel.setWidth("600px");
        this.mainPanel.add((Widget)this.filterPanelWrapper);
        this.filterPanelWrapper.setVisible(false);
        this.mainPanel.add((Widget)this.newUpdatesPanel);
        this.mainPanel.add((Widget)this.newsPanel);
        this.filterPanel = new FilterPanel(this, this.newsService);
        this.filterPanelWrapper.add((Widget)this.filterPanel);
        this.initWidget((Widget)this.mainPanel);
        this.newsPanel.clear();
        this.newsPanel.setWidth("100%");
        this.newsPanel.setHeight("300px");
        this.newsPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        this.newsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.loadingImage = new Image(loading);
        this.newsPanel.add((Widget)this.loadingImage);
        this.newsService.getUserSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.feedsTimer = new /* Unavailable Anonymous Inner Class!! */;
        this.feedsTimer.scheduleRepeating(this.delayMillis);
    }

    private void checkForNewUpdates() {
        switch (26.$SwitchMap$org$gcube$portlets$user$newsfeed$client$FilterType[this.currentFilter.ordinal()]) {
            case 1: {
                this.checkAllUpdatesFeeds();
                break;
            }
            case 2: {
                this.showOnlyConnectionsFeeds();
                break;
            }
            case 3: {
                this.showOnlyMyFeeds();
            }
        }
    }

    private String getFeedToShowId() {
        return Window.Location.getParameter((String)GET_OID_PARAMETER);
    }

    private void showSingleFeed(String feedKey) {
        this.newsPanel.clear();
        this.newsService.getSingleFeed(feedKey, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkAllUpdatesFeeds() {
        this.newsService.getAllUpdateUserFeeds(10, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doShowCachedNewUpdates() {
        this.newUpdatesPanel.clear();
        this.newsFeedAlert = null;
        this.currNewUpdatesNo = 0;
        for (int i = this.tempCacheNewUpdates.size(); i > 0; --i) {
            EnhancedFeed feed = (EnhancedFeed)this.tempCacheNewUpdates.get(i - 1);
            TweetTemplate tt = new TweetTemplate(this.myUserInfo, feed, this.eventBus, true);
            this.newsPanel.insert((Widget)tt, 0);
            this.allUpdates.add(0, feed);
            13 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(100);
        }
        String currTitle = Document.get().getTitle();
        Document.get().setTitle(currTitle.startsWith("(") ? currTitle.substring(4) : currTitle);
    }

    public void addJustAddedFeed(ClientFeed cFeed) {
        Feed feed = new Feed(cFeed.getKey(), FeedType.SHARE, cFeed.getUserid(), cFeed.getTime(), "", cFeed.getUri(), cFeed.getLinkUrlThumbnail(), cFeed.getDescription(), PrivacyLevel.CONNECTION, cFeed.getFullName(), cFeed.getEmail(), cFeed.getThumbnailURL(), cFeed.getLinkTitle(), cFeed.getLinkDescription(), cFeed.getLinkHost());
        EnhancedFeed toAdd = new EnhancedFeed(feed, false, true);
        TweetTemplate tt = new TweetTemplate(this.myUserInfo, toAdd, this.eventBus, true);
        if (this.isFirstTweet) {
            this.newsPanel.clear();
            this.newsPanel.add((Widget)new Image(spacer));
            this.isFirstTweet = false;
        }
        this.newsPanel.insert((Widget)tt, 0);
        14 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(500);
        this.allUpdates.add(0, toAdd);
    }

    public void showAllUpdatesFeeds() {
        this.showLoader();
        this.newsService.getAllUpdateUserFeeds(10, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showOnlyConnectionsFeeds() {
        this.showLoader();
        this.newsService.getOnlyConnectionsUserFeeds((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showOnlyMyFeeds() {
        this.showLoader();
        this.newsService.getOnlyMyUserFeeds((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showOnlyLikedFeeds() {
        this.showLoader();
        this.newsService.getOnlyLikedFeeds((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showLoader() {
        this.newsPanel.clear();
        this.newsPanel.setWidth("100%");
        this.newsPanel.setHeight("300px");
        this.newsPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        this.newsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.newsPanel.add((Widget)this.loadingImage);
    }

    private void showProblems() {
        this.newsPanel.clear();
        this.newsPanel.add((Widget)new HTML("<div class=\"nofeed-message\">Ops! There were problems while retrieving your feeds!. <br> Looks like we are not able to communicate with the infrastructure,<br> (or your session expired)<br> please try again in a short while or refresh the page.</div>"));
    }

    private void doAddLike(TweetTemplate owner, String feedId) {
        this.newsService.like(feedId, owner.getMyFeedText(), owner.getMyFeedUserId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doShowLikes(String feedId) {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doAddComment(TweetTemplate owner, String text) {
        this.newsService.comment(owner.getFeedKey(), text, owner.getMyFeedUserId(), owner.isAppFeed(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doEditComment(TweetTemplate owner, Comment edited) {
        this.newsService.editComment(edited, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doShowComments(TweetTemplate owner, boolean commentForm2Add) {
        owner.showLoadingComments();
        this.newsService.getAllCommentsByFeed(owner.getFeedKey(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doDeleteComment(TweetTemplate owner, String commentId) {
        this.newsService.deleteComment(commentId, owner.getFeedKey(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doDeleteFeed(TweetTemplate toDelete) {
        if (Window.confirm((String)"Are you sure you want to delete this feed?")) {
            this.newsService.deleteFeed(toDelete.getFeedKey(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void setCurrentFilter(FilterType currentFilter) {
        this.currentFilter = currentFilter;
    }

    static /* synthetic */ void access$000(NewsFeedPanel x0, TweetTemplate x1, String x2) {
        x0.doAddLike(x1, x2);
    }

    static /* synthetic */ void access$100(NewsFeedPanel x0, TweetTemplate x1, String x2) {
        x0.doAddComment(x1, x2);
    }

    static /* synthetic */ void access$200(NewsFeedPanel x0, TweetTemplate x1, Comment x2) {
        x0.doEditComment(x1, x2);
    }

    static /* synthetic */ void access$300(NewsFeedPanel x0, String x1) {
        x0.doShowLikes(x1);
    }

    static /* synthetic */ void access$400(NewsFeedPanel x0, TweetTemplate x1, boolean x2) {
        x0.doShowComments(x1, x2);
    }

    static /* synthetic */ void access$500(NewsFeedPanel x0, TweetTemplate x1) {
        x0.doDeleteFeed(x1);
    }

    static /* synthetic */ UserInfo access$602(NewsFeedPanel x0, UserInfo x1) {
        x0.myUserInfo = x1;
        return x0.myUserInfo;
    }

    static /* synthetic */ int access$702(NewsFeedPanel x0, int x1) {
        x0.delayMillis = x1;
        return x0.delayMillis;
    }

    static /* synthetic */ String access$800(NewsFeedPanel x0) {
        return x0.getFeedToShowId();
    }

    static /* synthetic */ void access$900(NewsFeedPanel x0, String x1) {
        x0.showSingleFeed(x1);
    }

    static /* synthetic */ FilterPanel access$1000(NewsFeedPanel x0) {
        return x0.filterPanel;
    }

    static /* synthetic */ FilterType access$1102(NewsFeedPanel x0, FilterType x1) {
        x0.currentFilter = x1;
        return x0.currentFilter;
    }

    static /* synthetic */ HorizontalPanel access$1200(NewsFeedPanel x0) {
        return x0.filterPanelWrapper;
    }

    static /* synthetic */ VerticalPanel access$1300(NewsFeedPanel x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ void access$1400(NewsFeedPanel x0) {
        x0.checkForNewUpdates();
    }

    static /* synthetic */ VerticalPanel access$1500(NewsFeedPanel x0) {
        return x0.newsPanel;
    }

    static /* synthetic */ UserInfo access$600(NewsFeedPanel x0) {
        return x0.myUserInfo;
    }

    static /* synthetic */ HandlerManager access$1600(NewsFeedPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ String access$1700() {
        return spacer;
    }

    static /* synthetic */ void access$1800(NewsFeedPanel x0) {
        x0.showProblems();
    }

    static /* synthetic */ ArrayList access$1900(NewsFeedPanel x0) {
        return x0.allUpdates;
    }

    static /* synthetic */ ArrayList access$2002(NewsFeedPanel x0, ArrayList x1) {
        x0.tempCacheNewUpdates = x1;
        return x0.tempCacheNewUpdates;
    }

    static /* synthetic */ ArrayList access$2000(NewsFeedPanel x0) {
        return x0.tempCacheNewUpdates;
    }

    static /* synthetic */ int access$2100(NewsFeedPanel x0) {
        return x0.currNewUpdatesNo;
    }

    static /* synthetic */ NewFeedsAvailable access$2200(NewsFeedPanel x0) {
        return x0.newsFeedAlert;
    }

    static /* synthetic */ NewFeedsAvailable access$2202(NewsFeedPanel x0, NewFeedsAvailable x1) {
        x0.newsFeedAlert = x1;
        return x0.newsFeedAlert;
    }

    static /* synthetic */ SimplePanel access$2300(NewsFeedPanel x0) {
        return x0.newUpdatesPanel;
    }

    static /* synthetic */ int access$2102(NewsFeedPanel x0, int x1) {
        x0.currNewUpdatesNo = x1;
        return x0.currNewUpdatesNo;
    }

    static /* synthetic */ boolean access$2402(NewsFeedPanel x0, boolean x1) {
        x0.isFirstTweet = x1;
        return x0.isFirstTweet;
    }

    static /* synthetic */ String access$2500() {
        return warning;
    }

    static /* synthetic */ Image access$2600(NewsFeedPanel x0) {
        return x0.loadingImage;
    }

    static /* synthetic */ NewsServiceAsync access$2700(NewsFeedPanel x0) {
        return x0.newsService;
    }
}

