package org.gcube.portlets.user.newsfeed.client;

import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapter;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapterException;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusEvent;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusListener;

import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.ClientFeed.ClientFeedJsonizer;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.jsonmaker.gwt.client.Jsonizer;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class NewsFeed implements EntryPoint {

	private final String UNIQUE_DIV = "newsfeedDIV";
	final PageBusAdapter pageBusAdapter = new PageBusAdapter();
	NewsFeedPanel mainPanel;
	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {		
		mainPanel = new NewsFeedPanel();
		resize();
		RootPanel.get(UNIQUE_DIV).add(mainPanel);

		Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				int width = RootPanel.get(UNIQUE_DIV).getOffsetWidth();
				mainPanel.setWidth(""+width);
			}			
		});

		ClientFeed notification = new ClientFeed();
		//Subscribe to message and associate subsequent receptions with custom subscriber data
		try
		{
			pageBusAdapter.PageBusSubscribe("org.gcube.portal.databook.shared", null, null, notification, (Jsonizer)GWT.create(ClientFeedJsonizer.class));
		}
		catch (PageBusAdapterException e1)
		{
			e1.printStackTrace();
		}

		pageBusAdapter.addPageBusSubscriptionCallbackListener(new PageBusListener() {
			public void onPageBusSubscriptionCallback(PageBusEvent event) {
				// translate JavaScript message contents and subscriber data to their Java equivalents
				try {
					ClientFeed feed = (ClientFeed)event.getMessage((Jsonizer)GWT.create(ClientFeedJsonizer.class));
					mainPanel.addJustAddedFeed(feed);

				} catch (PageBusAdapterException e) {
					e.printStackTrace();
				}
			}
			public String getName() {
				return null;
			}
		});
		
		
	}

	private void resize() {
		int width = RootPanel.get(UNIQUE_DIV).getOffsetWidth();
		mainPanel.setWidth(""+width);
	}

}
