package org.gcube.portlets.user.newsfeed.server;

import java.util.ArrayList;

import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class MentionNotificationsThread implements Runnable {
	private static Logger _log = LoggerFactory.getLogger(MentionNotificationsThread.class);
	
	private String postText;
	private String postId;
	private NotificationsManager nm;
	private ArrayList<PickingUser> users;
	
	
	public MentionNotificationsThread(String postId, String postText, NotificationsManager nm, ArrayList<PickingUser> users) {
		super();
		this.postId = postId;
		this.postText = postText;
		this.nm = nm;
		this.users = users;
	}

	@Override
	public void run() {
		for (PickingUser userToNotify : users) {
			boolean result = nm.notifyUserTag(userToNotify.getUsername(), postId, postText);
			_log.trace("Sending Notification for post mention to: " + userToNotify.getUsername() + " result?"+ result);
		}
	}
}
