/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.ShowUserStatisticAction;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.CommentIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.notifications.thread.MentionNotificationsThread;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.server.CustomConfiguration;
import org.gcube.portlets.user.newsfeed.server.NewsServiceImpl;
import org.gcube.portlets.user.newsfeed.shared.MentionedDTO;
import org.gcube.portlets.user.newsfeed.shared.MorePostsBean;
import org.gcube.portlets.user.newsfeed.shared.OperationResult;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.social_networking.social_networking_client_library.FullTextSearchClient;
import org.gcube.social_networking.socialutillibrary.Utils;
import org.gcube.socialnetworking.socialtoken.SocialMessageParser;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeTeam;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsServiceImpl
extends RemoteServiceServlet
implements NewsService {
    private static final Logger _log = LoggerFactory.getLogger(NewsServiceImpl.class);
    private static final String VRE_LABEL = "VRE_LABEL";
    private static final String SHOW_TIMELINE_SOURCE = "SHOW_TIMELINE_SOURCE";
    private static final String REFRESH_TIME = "REFRESH_TIME";
    private static final String SESSION_ADMIN_ATTR = "SESSION_ADMIN_ATTR";
    public static final String NF_ORGANIZATIONUSERS_CACHE = "NF_ORGANIZATIONUSERS_CACHE";
    public static final String LAST_RETRIEVED_TIME = "NF_LAST_RETRIEVED_TIME";
    private String APP_ID;
    private DatabookStore store;
    private static final int MAX_POSTS_NO = 30;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
        this.APP_ID = this.getClass().getName();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public UserSettings getUserSettings() {
        try {
            String profilePageURL;
            PortalContext context = PortalContext.getConfiguration();
            GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
            String username = currUser.getUsername();
            String email = currUser.getEmail();
            String fullName = currUser.getFullname();
            String thumbnailURL = currUser.getUserAvatarURL();
            String groupName = context.getCurrentGroupName(this.getThreadLocalRequest());
            String accountURL = profilePageURL = "/group" + PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest()) + "/profile";
            UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, email, accountURL, true, this.isAdmin(), null);
            CustomConfiguration config = this.getUserConfiguration();
            UserSettings toReturn = new UserSettings(userInfo, config.getRefreshTime(), groupName, config.getVreLabel(), this.isInfrastructureScope(), config.isShowTimelineSource());
            return toReturn;
        }
        catch (Exception e) {
            _log.warn("Could not read user Settings");
            return new UserSettings();
        }
    }

    private boolean isInfrastructureScope() throws UserManagementSystemException, GroupRetrievalFault {
        PortalContext context = PortalContext.getConfiguration();
        String scope = context.getCurrentScope(this.getThreadLocalRequest());
        long groupId = context.getCurrentGroupId(this.getThreadLocalRequest());
        boolean isInfrastructureScope = new LiferayGroupManager().isRootVO(groupId);
        _log.debug("isInfrastructureScope? " + scope + " groupId=" + groupId + " ? i say " + isInfrastructureScope);
        return isInfrastructureScope;
    }

    public ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int postsNoPerCategory) {
        ArrayList<Feed> toMerge = new ArrayList<Feed>();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        try {
            GCubeUser currUser = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest());
            _log.info("****** retrieving posts for user: " + currUser.getUsername());
            if (this.isInfrastructureScope()) {
                _log.debug("****** risInfrastructureScope() = true");
                LiferayGroupManager gm = new LiferayGroupManager();
                for (Object group : gm.listGroupsByUserAndSite(currUser.getUserId(), this.getThreadLocalRequest().getServerName())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    _log.debug("Reading posts for VRE: " + vreid);
                    ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, postsNoPerCategory);
                    for (Feed post : OrganizationFeeds) {
                        feedsMap.put(post.getKey(), post);
                    }
                }
                ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
                for (Feed post : portalFeeds) {
                    feedsMap.put(post.getKey(), post);
                }
            } else {
                PortalContext context = PortalContext.getConfiguration();
                String vreid = context.getCurrentScope(this.getThreadLocalRequest());
                _log.trace("News Feed in VRE, Reading posts for VRE: " + vreid);
                ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, 30);
                for (Feed post : OrganizationFeeds) {
                    feedsMap.put(post.getKey(), post);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add((Feed)feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList<Feed> toReturn = new ArrayList<Feed>();
            if (toMerge.size() > 30) {
                for (int i = 0; i < 30; ++i) {
                    toReturn.add((Feed)toMerge.get(i));
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found " + e.getMessage());
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found " + e.getMessage());
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getPostsByHashtag(String hashtag) {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String currentScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        try {
            ArrayList<Feed> toMerge = new ArrayList<Feed>();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            String lowerCaseHashtag = hashtag.toLowerCase();
            ArrayList<String> contexts = new ArrayList<String>();
            if (this.isInfrastructureScope()) {
                LiferayGroupManager gm = new LiferayGroupManager();
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(userName);
                Set vresInPortal = gm.listGroupsByUserAndSite(user.getUserId(), this.getThreadLocalRequest().getServerName());
                _log.debug("Contexts in this site are per user " + vresInPortal);
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(currentScope);
            }
            _log.debug("Contexts for hashtags is " + contexts);
            for (String context : contexts) {
                ArrayList posts = (ArrayList)this.store.getVREFeedsByHashtag(context, lowerCaseHashtag);
                for (Feed post : posts) {
                    feedsMap.put(post.getKey(), post);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add((Feed)feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList<Feed> toReturn = new ArrayList<Feed>();
            if (toMerge.size() > 30) {
                for (int i = 0; i < 30; ++i) {
                    toReturn.add((Feed)toMerge.get(i));
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found ", (Throwable)e);
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found ", (Throwable)e);
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found ", (Throwable)e);
        }
        catch (Exception e) {
            _log.error("Error while retrieving posts for hashtag ", (Throwable)e);
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getPostsByQuery(String query, int from, int quantity) {
        _log.debug("\n\n IN getPostsByQuery ");
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String currentScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        try {
            if (userName.compareTo("test.user") == 0) {
                _log.debug("Found " + userName + " returning nothing");
                return null;
            }
            HashSet<String> vres = new HashSet<String>();
            if (this.isInfrastructureScope()) {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser currUser = um.getUserByUsername(userName);
                LiferayGroupManager gm = new LiferayGroupManager();
                for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    vres.add(vreid);
                }
            } else {
                vres.add(currentScope);
            }
            FullTextSearchClient sClient = new FullTextSearchClient();
            ArrayList enhancedFeeds = sClient.search(query, from, quantity);
            List likedPosts = this.store.getAllLikedPostIdsByUser(userName);
            for (EnhancedFeed enhancedFeed : enhancedFeeds) {
                if (this.isUsers(enhancedFeed.getFeed(), userName)) {
                    enhancedFeed.setUsers(true);
                }
                if (!likedPosts.contains(enhancedFeed.getFeed().getKey())) continue;
                enhancedFeed.setLiked(true);
            }
            return enhancedFeeds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<EnhancedFeed> getOnlyConnectionsUserPosts() {
        block10: {
            ArrayList<Feed> toMerge = new ArrayList<Feed>();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            PortalContext pContext = PortalContext.getConfiguration();
            String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
            try {
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed post : this.store.getRecentFeedsByUser(userid, 9)) {
                        feedsMap.put(post.getKey(), post);
                    }
                }
                for (String key : feedsMap.keySet()) {
                    toMerge.add((Feed)feedsMap.get(key));
                }
                Collections.sort(toMerge, Collections.reverseOrder());
                ArrayList<Feed> toReturn = new ArrayList<Feed>();
                if (toMerge.size() > 30) {
                    for (int i = 0; i < 30; ++i) {
                        toReturn.add((Feed)toMerge.get(i));
                    }
                    break block10;
                }
                return this.enhanceFeeds(toMerge, 2);
            }
            catch (PrivacyLevelTypeNotFoundException e) {
                _log.error("Privacy Level not Found " + e.getMessage());
            }
            catch (FeedTypeNotFoundException e) {
                _log.error("Feed Type not Found " + e.getMessage());
            }
            catch (ColumnNameNotFoundException e) {
                _log.error("Column name not Found " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EnhancedFeed getSinglePost(String postKey) {
        Feed post = null;
        try {
            if (postKey != null && (post = this.store.readFeed(postKey)) != null) {
                ArrayList<Feed> toEnhance = new ArrayList<Feed>();
                toEnhance.add(post);
                return (EnhancedFeed)this.enhanceFeeds(toEnhance, -1).get(0);
            }
        }
        catch (Exception e) {
            _log.debug("Error while trying to fetch post with key " + postKey + " returning nothing");
            return new EnhancedFeed();
        }
        return new EnhancedFeed();
    }

    public MorePostsBean getMorePosts(int start, int quantity) {
        ArrayList<Feed> toMerge = new ArrayList<Feed>();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        PortalContext pContext = PortalContext.getConfiguration();
        String vreid = pContext.getCurrentScope(this.getThreadLocalRequest());
        _log.debug("\n\nAsking more post for Timeline " + vreid + " from " + start + " get other " + quantity);
        RangeFeeds rangeFeeds = null;
        try {
            rangeFeeds = this.store.getRecentFeedsByVREAndRange(vreid, start, quantity);
            ArrayList organizationFeeds = rangeFeeds.getFeeds();
            if (organizationFeeds != null) {
                for (Feed post : organizationFeeds) {
                    feedsMap.put(post.getKey(), post);
                }
            }
        }
        catch (Exception e) {
            _log.warn("Could not get more posts ...", (Throwable)e);
            return null;
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add((Feed)feedsMap.get(key));
        }
        Collections.sort(toMerge, Collections.reverseOrder());
        ArrayList toReturn = this.enhanceFeeds(toMerge, 2);
        return new MorePostsBean(rangeFeeds.getLastReturnedFeedTimelineIndex(), toReturn);
    }

    public ArrayList<EnhancedFeed> getOnlyMyUserPosts() {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        _log.trace("getOnly UserFeeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 15);
        }
        catch (Exception e) {
            _log.error("Could not read recent posts for this user " + userName);
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyLikedPosts() {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        _log.trace("getLiked Feeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getAllLikedFeedsByUser(userName, 25);
        }
        catch (Exception e) {
            _log.error("Could not read liked posts for this user " + userName);
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public boolean like(String postid, String postText, String postOwnerId) {
        boolean likeCommitResult = false;
        UserInfo user = this.getUserSettings().getUserInfo();
        String username = user.getUsername();
        if (username.compareTo("test.user") == 0) {
            return false;
        }
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), postid, user.getFullName(), user.getAvatarId());
        try {
            likeCommitResult = this.store.like(toLike);
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Post not Found for this like " + e.getMessage());
            return false;
        }
        if (likeCommitResult) {
            PortalContext pContext = PortalContext.getConfiguration();
            String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
            if (!user.getUsername().equals(postOwnerId)) {
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), currScope, new SocialNetworkingUser(username, user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
                ArrayList mentionedUsers = new ArrayList();
                SocialMessageParser messageParser = new SocialMessageParser(postText);
                String siteLandingPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
                String escapedPostText = messageParser.getParsedMessage(mentionedUsers, siteLandingPagePath);
                boolean nResult = nm.notifyLikedPost(postOwnerId, postid, escapedPostText);
                _log.trace("Like Notification added? " + nResult);
            }
        }
        return likeCommitResult;
    }

    public boolean unlike(String postid, String postText, String postOwnerId) {
        UserInfo user = this.getUserSettings().getUserInfo();
        try {
            for (Like like : this.store.getAllLikesByFeed(postid)) {
                if (like.getUserid().compareTo(user.getUsername()) != 0) continue;
                _log.trace("Trying unlike of " + postText + " for " + user.getFullName());
                this.store.unlike(user.getUsername(), like.getKey(), postid);
                return true;
            }
        }
        catch (ColumnNameNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | LikeIDNotFoundException | PrivacyLevelTypeNotFoundException e) {
            _log.error("Either Post or Like not Found " + e.getMessage());
            return false;
        }
        return false;
    }

    public OperationResult comment(String feedid, String commentText, HashSet<MentionedDTO> mentionedItemsSet, String feedOwnerId, boolean isAppFeed) {
        boolean commentCommitResult = false;
        _log.trace("Trying to add this comment " + commentText);
        UserInfo user = this.getUserSettings().getUserInfo();
        if (user.getUsername().compareTo("test.user") == 0) {
            return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
        }
        ArrayList mentionedUsers = new ArrayList();
        if (mentionedItemsSet != null && mentionedItemsSet.size() > 0) {
            ArrayList<MentionedDTO> mentionedItems = new ArrayList<MentionedDTO>();
            mentionedItems.addAll(mentionedItemsSet);
            if (mentionedItemsSet != null && !mentionedItemsSet.isEmpty()) {
                mentionedUsers = this.getMentionsBean(mentionedItems);
            }
        }
        SocialMessageParser messageParser = new SocialMessageParser(commentText);
        String siteLandingPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
        String escapedCommentText = messageParser.getParsedMessage(mentionedUsers, siteLandingPagePath);
        List hashtags = messageParser.getHashtags();
        Comment comment = new Comment(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, escapedCommentText, user.getFullName(), user.getAvatarId());
        try {
            if (this.store.addComment(comment)) {
                commentCommitResult = true;
            }
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Related post not found for this comment " + e.getMessage());
            return new OperationResult(Boolean.valueOf(false), "Related post not found for this comment", comment);
        }
        try {
            if (hashtags != null && !hashtags.isEmpty()) {
                this.store.saveHashTagsComment(comment.getKey(), this.store.readFeed(comment.getFeedid()).getVreid(), hashtags);
            }
        }
        catch (ColumnNameNotFoundException | CommentIDNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | PrivacyLevelTypeNotFoundException e1) {
            _log.error("Unable to save hashtags for this comment " + e1.getMessage());
        }
        if (commentCommitResult && this.isWithinPortal()) {
            PortalContext pContext = PortalContext.getConfiguration();
            String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), currScope, new SocialNetworkingUser(user.getUsername(), user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
            if (!user.getUsername().equals(feedOwnerId) && !isAppFeed) {
                boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedid, escapedCommentText, comment.getKey());
                _log.trace("Comment Notification to post owner added? " + result);
            }
            ArrayList favorites = this.getAllLikesByPost(feedid);
            Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(escapedCommentText, (NotificationsManager)nm, favorites, feedOwnerId, comment.getKey()));
            likesThread.start();
            Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.store, (UserManager)new LiferayUserManager(), user.getUsername(), comment.getFeedid(), escapedCommentText, (NotificationsManager)nm, feedOwnerId, comment.getKey(), favorites));
            commentsNotificationthread.start();
            if (mentionedUsers != null && mentionedUsers.size() > 0) {
                ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
                HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
                LiferayUserManager um = new LiferayUserManager();
                for (ItemBean bean : mentionedUsers) {
                    if (bean.isItemGroup()) {
                        try {
                            List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                            for (GCubeUser userTeam : teamUsers) {
                                if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                                uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(userTeam.getUserId() + "", userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                            }
                            continue;
                        }
                        catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            _log.error("Unable to retrieve team information", e);
                            continue;
                        }
                    }
                    if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
                    uniqueUsersToNotify.put(bean.getName(), bean);
                }
                for (Map.Entry userEntry : uniqueUsersToNotify.entrySet()) {
                    ItemBean userBean = (ItemBean)userEntry.getValue();
                    toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
                }
                Thread thread = new Thread((Runnable)new MentionNotificationsThread(comment.getFeedid(), escapedCommentText, (NotificationsManager)nm, null, toPass));
                thread.start();
            }
        }
        return new OperationResult(Boolean.valueOf(true), "OK", comment);
    }

    public OperationResult editComment(String text, Comment toEdit, HashSet<MentionedDTO> mentionedItemsSet) {
        Comment edited;
        block15: {
            edited = null;
            boolean commentCommitResult = false;
            try {
                _log.debug("in edit Comment ... ");
                UserInfo user = this.getUserSettings().getUserInfo();
                if (user.getUsername().compareTo("test.user") == 0) {
                    return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
                }
                String vreIdFeed = this.store.readFeed(toEdit.getFeedid()).getVreid();
                String oldText = this.store.readCommentById(toEdit.getKey()).getText();
                _log.debug("Old text for this comment is " + oldText);
                System.out.println("Old text for this comment is " + oldText);
                List oldHashtags = Utils.getHashTags((String)Utils.removeHTMLFromText((String)oldText));
                if (oldHashtags != null && !oldHashtags.isEmpty()) {
                    _log.debug("The comment has hashtags, attempting to delete them ... " + oldHashtags.toString());
                    boolean deletedHashtag = this.store.deleteHashTagsComment(toEdit.getKey(), vreIdFeed, oldHashtags);
                    _log.debug("deletedHashtag? " + deletedHashtag);
                }
                ArrayList mentionedUsers = new ArrayList();
                if (mentionedItemsSet != null && mentionedItemsSet.size() > 0) {
                    ArrayList<MentionedDTO> mentionedItems = new ArrayList<MentionedDTO>();
                    mentionedItems.addAll(mentionedItemsSet);
                    if (mentionedItemsSet != null && !mentionedItemsSet.isEmpty()) {
                        mentionedUsers = this.getMentionsBean(mentionedItems);
                    }
                }
                SocialMessageParser messageParser = new SocialMessageParser(text);
                String siteLandingPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
                String escapedCommentText = messageParser.getParsedMessage(mentionedUsers, siteLandingPagePath);
                List newHashtags = messageParser.getHashtags();
                if (newHashtags != null && !newHashtags.isEmpty()) {
                    this.store.saveHashTagsComment(toEdit.getKey(), vreIdFeed, newHashtags);
                }
                if (commentCommitResult = this.store.editComment(edited = new Comment(toEdit.getKey(), toEdit.getUserid(), toEdit.getTime(), toEdit.getFeedid(), escapedCommentText, user.getFullName(), user.getAvatarId(), true, new Date()))) {
                    PortalContext pContext = PortalContext.getConfiguration();
                    String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
                    ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), currScope, new SocialNetworkingUser(user.getUsername(), user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
                    if (mentionedUsers != null && mentionedUsers.size() > 0) {
                        ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
                        HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
                        LiferayUserManager um = new LiferayUserManager();
                        for (ItemBean bean : mentionedUsers) {
                            if (bean.isItemGroup()) {
                                try {
                                    List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                                    for (GCubeUser userTeam : teamUsers) {
                                        if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                                        uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(userTeam.getUserId() + "", userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                                    }
                                    continue;
                                }
                                catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                                    _log.error("Unable to retrieve team information", e);
                                    continue;
                                }
                            }
                            if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
                            uniqueUsersToNotify.put(bean.getName(), bean);
                        }
                        for (Map.Entry userEntry : uniqueUsersToNotify.entrySet()) {
                            ItemBean userBean = (ItemBean)userEntry.getValue();
                            toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
                        }
                        Thread thread = new Thread((Runnable)new MentionNotificationsThread(toEdit.getFeedid(), escapedCommentText, (NotificationsManager)nm, null, toPass));
                        thread.start();
                    }
                    break block15;
                }
                return new OperationResult(Boolean.valueOf(false), "Exception on the server, could not deliver the edited comment to storage", null);
            }
            catch (Exception e) {
                return new OperationResult(Boolean.valueOf(false), "Exception on the server: " + e.getMessage(), null);
            }
        }
        return new OperationResult(Boolean.valueOf(true), "OK", edited);
    }

    private ArrayList<EnhancedFeed> enhanceFeeds(ArrayList<Feed> toEnhance, int commentsNumberPerFeed) {
        ArrayList<EnhancedFeed> toReturn = new ArrayList<EnhancedFeed>();
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String LINK_TO_REPLACE = "data-e-infrastructure-gateway";
        String siteLandinPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
        String tokenTosubstitute = siteLandinPagePath.replace("/group/", "");
        ArrayList likedFeeds = (ArrayList)this.store.getAllLikedFeedIdsByUser(userName);
        boolean skip = false;
        for (Feed feed : toEnhance) {
            String currPostText = feed.getDescription().replace("data-e-infrastructure-gateway", tokenTosubstitute);
            feed.setDescription(currPostText);
            boolean isMultiFileUpload = feed.isMultiFileUpload();
            ArrayList attachments = new ArrayList();
            if (isMultiFileUpload) {
                try {
                    attachments = (ArrayList)this.store.getAttachmentsByFeedId(feed.getKey());
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("It looks like sth wrong with this feedid having attachments, could not find feedId = " + feed.getKey() + "\n" + e.getMessage());
                }
            }
            skip = false;
            if (!feed.isApplicationFeed()) {
                String thumb = this.getUserImagePortraitUrlLocal(feed.getEntityId());
                if (thumb == null) {
                    _log.warn(feed.getEntityId() + " is not avaialble on this portal, skipping this feed: " + feed.getKey());
                    skip = true;
                } else {
                    feed.setThumbnailURL(thumb);
                }
            }
            boolean liked = likedFeeds.contains(feed.getKey());
            int commentsNo = 0;
            try {
                commentsNo = Integer.parseInt(feed.getCommentsNo());
            }
            catch (NumberFormatException e) {
                commentsNo = 0;
                _log.error("NumberFormatException while reading comments number " + e.getMessage());
            }
            if (skip) continue;
            if (commentsNo == 0) {
                EnhancedFeed toAdd = null;
                toAdd = feed.isApplicationFeed() ? new EnhancedFeed(feed, liked, this.checkisAdminUser()) : new EnhancedFeed(feed, liked, this.isUsers(feed, userName));
                toAdd.setAttachments(attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments = this.getAllCommentsByPost(feed.getKey());
            Collections.sort(comments);
            int currCommentsNumber = comments.size();
            if (currCommentsNumber < commentsNumberPerFeed || commentsNumberPerFeed == -1) {
                EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, userName), comments, attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList<Comment> comments2Attach = new ArrayList<Comment>();
            for (int i = currCommentsNumber - commentsNumberPerFeed; i < currCommentsNumber; ++i) {
                comments2Attach.add((Comment)comments.get(i));
            }
            EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, userName), comments2Attach, attachments);
            toReturn.add(toAdd);
        }
        _log.trace("ENHANCED FEEDS TOTAL= " + toReturn.size() + " for user: " + userName);
        return toReturn;
    }

    private String getUserImagePortraitUrlLocal(String screenName) {
        if (!this.isWithinPortal()) {
            return "";
        }
        String thumbnailURL = "";
        try {
            thumbnailURL = new LiferayUserManager().getUserByUsername(screenName).getUserAvatarURL();
        }
        catch (UserManagementSystemException | UserRetrievalFault e) {
            _log.warn("User " + screenName + " could not be found in this portal DB");
        }
        return thumbnailURL;
    }

    public ArrayList<Like> getAllLikesByPost(String postid) {
        ArrayList toReturn = (ArrayList)this.store.getAllLikesByFeed(postid);
        _log.trace("Asking likes for " + postid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Like like;
            String thumb = this.getUserImagePortraitUrlLocal((like = (Like)iterator.next()).getUserid());
            like.setThumbnailURL(thumb == null ? "" : thumb);
        }
        return toReturn;
    }

    public ArrayList<Comment> getAllCommentsByPost(String postid) {
        _log.trace("Asking comments for " + postid);
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(postid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Comment comment;
            String thumb = this.getUserImagePortraitUrlLocal((comment = (Comment)iterator.next()).getUserid());
            comment.setThumbnailURL(thumb == null ? "" : thumb);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    public boolean deleteComment(String commentid, String feedid) {
        _log.trace("Attempting to delete comment " + commentid);
        try {
            Comment toDelete = this.store.readCommentById(commentid);
            String vreIdFeed = this.store.readFeed(toDelete.getFeedid()).getVreid();
            List hashtags = Utils.getHashTags((String)Utils.removeHTMLFromText((String)toDelete.getText()));
            if (hashtags != null && !hashtags.isEmpty()) {
                _log.debug("The comment has hashtags, attempting to delete them ... " + hashtags.toString());
                boolean deletedHashtag = this.store.deleteHashTagsComment(toDelete.getKey(), vreIdFeed, hashtags);
                _log.debug("deletedHashtag? " + deletedHashtag);
            }
            _log.debug("Attempting to delete comment " + commentid);
            return this.store.deleteComment(commentid, feedid);
        }
        catch (Exception e) {
            _log.error("Failed to delete comment " + commentid);
            return false;
        }
    }

    public boolean deletePost(String postid) {
        _log.debug("Called delete post " + postid);
        try {
            List hashtags;
            boolean hasComments;
            Feed toDelete = this.store.readFeed(postid);
            boolean bl = hasComments = Integer.parseInt(toDelete.getCommentsNo()) > 0;
            if (hasComments) {
                _log.debug("Deleting post comments and their hashtags");
                List comments = this.store.getAllCommentByFeed(postid);
                for (Comment comment : comments) {
                    this.deleteComment(comment.getKey(), postid);
                }
            }
            if ((hashtags = Utils.getHashTags((String)Utils.removeHTMLFromText((String)toDelete.getDescription()))) != null && !hashtags.isEmpty()) {
                _log.debug("The post has hashtags, attempting to delete them ... " + hashtags.toString());
                boolean deletedHashtag = this.store.deleteHashTags(postid, toDelete.getVreid(), hashtags);
                _log.debug("deletedHashtag? " + deletedHashtag);
            }
            _log.debug("Attempting to delete post " + postid);
            return this.store.deleteFeed(postid);
        }
        catch (Exception e) {
            _log.debug("Failed to delete post " + postid);
            return false;
        }
    }

    public ArrayList<ItemBean> getOrganizationUsers() {
        ArrayList<ItemBean> portalBeans = new ArrayList<ItemBean>();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        String userName = currentUser.getUsername();
        LiferayUserManager um = new LiferayUserManager();
        LiferayGroupManager gm = new LiferayGroupManager();
        long currentGroupId = pContext.getCurrentGroupId(this.getThreadLocalRequest());
        HashSet users = new HashSet();
        List teams = new ArrayList();
        try {
            if (gm.isRootVO(currentGroupId).booleanValue()) {
                Set userGroups = gm.listGroupsByUserAndSite(currentUser.getUserId(), this.getThreadLocalRequest().getServerName());
                for (GCubeGroup userGroup : userGroups) {
                    if (!gm.isVRE(userGroup.getGroupId()).booleanValue()) continue;
                    users.addAll(um.listUsersByGroup(userGroup.getGroupId()));
                    _log.debug("getOrganizationUsers added users of group " + userGroup.getGroupId());
                }
            } else if (this.isWithinPortal()) {
                users.addAll(um.listUsersByGroup(currentGroupId));
                teams = new LiferayRoleManager().listTeamsByGroup(currentGroupId);
            } else {
                ArrayList<GCubeUser> forDev = new ArrayList<GCubeUser>();
                for (int i = 0; i < 10; ++i) {
                    forDev.add(new GCubeUser(1L, "username" + i, "email", "firstName" + i, "middleNam", "lastName" + i, "fullname test" + i, 0L, "url", true, "jobTitle", null));
                }
                users.addAll(forDev);
            }
        }
        catch (GroupRetrievalFault | UserManagementSystemException | UserRetrievalFault | VirtualGroupNotExistingException e) {
            e.printStackTrace();
        }
        for (GCubeUser user : users) {
            if (user.getUsername().compareTo("test.user") == 0 || user.getUsername().compareTo(userName) == 0) continue;
            portalBeans.add(new ItemBean(user.getUserId() + "", user.getUsername(), user.getFullname(), user.getUserAvatarURL()));
        }
        for (GCubeTeam gCubeTeam : teams) {
            portalBeans.add(new ItemBean(gCubeTeam.getTeamId() + "", gCubeTeam.getTeamName()));
        }
        _log.trace("Returning " + portalBeans.size() + " users for scope groupid =  " + currentGroupId);
        return portalBeans;
    }

    private boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }

    private boolean checkisAdminUser() {
        if (this.getThreadLocalRequest().getSession().getAttribute(SESSION_ADMIN_ATTR) == null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.isAdmin();
            }
            catch (Exception e) {
                _log.error("Could not check isAdmin");
            }
            this.getThreadLocalRequest().getSession().setAttribute(SESSION_ADMIN_ATTR, (Object)isAdmin);
            return isAdmin;
        }
        return (Boolean)this.getThreadLocalRequest().getSession().getAttribute(SESSION_ADMIN_ATTR);
    }

    private ArrayList<ItemBean> getMentionsBean(ArrayList<MentionedDTO> mentions) {
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>();
        if (mentions == null) {
            return toReturn;
        }
        LiferayUserManager um = new LiferayUserManager();
        LiferayRoleManager rm = new LiferayRoleManager();
        try {
            for (MentionedDTO mentioned : mentions) {
                if (mentioned.getType().equalsIgnoreCase("user")) {
                    long userId = Long.parseLong(mentioned.id);
                    GCubeUser user = um.getUserById(userId);
                    toReturn.add(new ItemBean(user.getUserId() + "", user.getUsername(), user.getFullname(), user.getUserAvatarURL()));
                    continue;
                }
                long teamId = Long.parseLong(mentioned.id);
                GCubeTeam gCubeTeam = rm.getTeam(teamId);
                toReturn.add(new ItemBean(gCubeTeam.getTeamId() + "", gCubeTeam.getTeamName()));
            }
        }
        catch (Exception e) {
            _log.error("getMentionsBean Error: ", (Throwable)e);
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        if (!this.isWithinPortal()) {
            return false;
        }
        try {
            PortalContext pContext = PortalContext.getConfiguration();
            GCubeUser curUser = pContext.getCurrentUser(this.getThreadLocalRequest());
            return new LiferayRoleManager().isAdmin(curUser.getUserId());
        }
        catch (Exception e) {
            _log.error("Could not check if the user is an Administrator, returning false");
            return false;
        }
    }

    private CustomConfiguration getUserConfiguration() {
        CustomConfiguration toReturn = null;
        _log.info("Trying to read custom config fr News Feed (REFRESH_TIME, VRE Label and show timeline source)");
        Properties props = new Properties();
        int minutes = 0;
        String label = "";
        boolean showTimelineSource = true;
        String propertyfile = "";
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            propertyfile = contextPath + "conf" + File.separator + "settings.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            try {
                minutes = Integer.parseInt(props.getProperty(REFRESH_TIME));
                minutes = minutes * 60 * 1000;
            }
            catch (ClassCastException ex) {
                minutes = 300000;
                _log.error("REFRESH_TIME must be a number (in minutes) returning 5 minutes");
            }
            label = props.getProperty(VRE_LABEL);
            try {
                showTimelineSource = Boolean.parseBoolean(props.getProperty(SHOW_TIMELINE_SOURCE));
            }
            catch (ClassCastException ex) {
                showTimelineSource = true;
                _log.error(showTimelineSource + " must be true or false, returning true");
            }
        }
        catch (IOException e) {
            minutes = 300000;
            _log.error("settings.properties file not found under " + propertyfile + ", returning 5 minutes");
        }
        toReturn = new CustomConfiguration(minutes, label, showTimelineSource);
        _log.debug("Read Configuration from property file: " + toReturn);
        return toReturn;
    }

    public ArrayList<EnhancedFeed> getPostsRelatedToUserStatistics(ShowUserStatisticAction action, int from, int quantity) {
        PortalContext pContext = PortalContext.getConfiguration();
        String userid = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String scope = pContext.getCurrentScope(this.getThreadLocalRequest());
        if (userid == "test.user") {
            return null;
        }
        try {
            Calendar oneYearAgo = Calendar.getInstance();
            oneYearAgo.set(1, oneYearAgo.get(1) - 1);
            ArrayList feeds = null;
            switch (1.$SwitchMap$org$gcube$portal$databook$shared$ShowUserStatisticAction[action.ordinal()]) {
                case 1: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 2: {
                    feeds = (ArrayList)this.store.getRecentLikedFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 3: {
                    feeds = (ArrayList)this.store.getRecentCommentedFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 4: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    Iterator feedsIteratorLikes = feeds.iterator();
                    while (feedsIteratorLikes.hasNext()) {
                        Feed feed = (Feed)feedsIteratorLikes.next();
                        if (Integer.parseInt(feed.getLikesNo()) != 0) continue;
                        feedsIteratorLikes.remove();
                    }
                    break;
                }
                case 5: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    Iterator feedsIteratorComments = feeds.iterator();
                    while (feedsIteratorComments.hasNext()) {
                        Feed feed = (Feed)feedsIteratorComments.next();
                        if (Integer.parseInt(feed.getCommentsNo()) != 0) continue;
                        feedsIteratorComments.remove();
                    }
                    break;
                }
                default: {
                    return new ArrayList<EnhancedFeed>();
                }
            }
            ArrayList<String> contexts = new ArrayList<String>();
            if (this.isInfrastructureScope()) {
                LiferayGroupManager groupManager = new LiferayGroupManager();
                long userIdLong = new LiferayUserManager().getUserId(userid);
                Set vresInPortal = groupManager.listGroupsByUserAndSite(userIdLong, this.getThreadLocalRequest().getServerName());
                _log.debug("Contexts in this site are " + vresInPortal);
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(groupManager.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(scope);
            }
            Iterator iteratorScope = feeds.iterator();
            while (iteratorScope.hasNext()) {
                Feed feed = (Feed)iteratorScope.next();
                if (contexts.contains(feed.getVreid())) continue;
                iteratorScope.remove();
            }
            Collections.sort(feeds, Collections.reverseOrder());
            int upperIndex = from + quantity >= feeds.size() ? feeds.size() : from + quantity;
            feeds = new ArrayList(feeds.subList(from, upperIndex));
            return this.enhanceFeeds(feeds, -1);
        }
        catch (Exception e) {
            _log.error("Error while retrieving feeds for user " + userid + " and action " + action.toString(), (Throwable)e);
            return null;
        }
    }
}

