package org.gcube.portlets.user.notifications.client.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;


import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.notifications.client.NotificationsService;
import org.gcube.portlets.user.notifications.client.NotificationsServiceAsync;
import org.gcube.portlets.user.notifications.client.view.templates.DayWrapper;
import org.gcube.portlets.user.notifications.client.view.templates.SingleNotificationView;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Position;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class NotificationsPanel extends Composite {
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final NotificationsServiceAsync notificationService = GWT.create(NotificationsService.class);

	public static final String loading = GWT.getModuleBaseURL() + "../images/feeds-loader.gif";
	private static final String spacer = GWT.getModuleBaseURL() + "../images/feeds-spacer.gif";
	private static final String warning = GWT.getModuleBaseURL() + "../images/warning_blue.png";
	private UserInfo myUserInfo;
	private Image loadingImage;

	private VerticalPanel container = new VerticalPanel();
	private HorizontalPanel settingsPanel = new HorizontalPanel();

	private VerticalPanel loadingPanel = new VerticalPanel();

	private VerticalPanel mainPanel;

	private HTML notificationSettings = new HTML("<a style=\"padding-right: 15px;\" class=\"notification-btn\">Notification Settings</a>");

	public NotificationsPanel() {
		notificationSettings.setVisible(false);
		mainPanel = new VerticalPanel();
		mainPanel.setWidth("100%");
		container.setWidth("100%");
		settingsPanel.setWidth("100%");
		settingsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		settingsPanel.add(notificationSettings);
		container.add(settingsPanel);
		container.add(mainPanel);
		loadingImage = new Image(loading);
		showLoader();

		notificationService.getUserInfo(new AsyncCallback<UserInfo>() {

			public void onFailure(Throwable caught) {				
			}
			public void onSuccess(UserInfo result) {
				myUserInfo = result;	
				if (result.getUsername().equals("test.user")) {
					Window.alert("Your session has expired, please log out and login again");
				} 
				else {
					showUserNotifications();
				}
			}
		});
		initWidget(container);

		notificationSettings.addClickHandler(new ClickHandler() {			
			@Override
			public void onClick(ClickEvent event) {
				showSettingsLoader(true);
				notificationService.getUserNotificationPreferences(new AsyncCallback<LinkedHashMap<String,ArrayList<NotificationPreference>>>() {
					@Override
					public void onFailure(Throwable caught) { 
						showSettingsLoader(false);
					}

					@Override
					public void onSuccess(LinkedHashMap<String, ArrayList<NotificationPreference>> result) {
						NotificationSettingsDialog dlg = new NotificationSettingsDialog(result, notificationService);
						dlg.center();
						dlg.show();			
						showSettingsLoader(false);
					}
				});				
			}
		});
	}



	private void showUserNotifications() {
		showLoader();
		notificationService.getUserNotifications(new AsyncCallback<HashMap<Date, ArrayList<Notification>>>() {

			public void onFailure(Throwable caught) {

			}

			public void onSuccess(HashMap<Date, ArrayList<Notification>> notificationsPerDay) {
				notificationSettings.setVisible(true);
				if (notificationsPerDay != null) {
					mainPanel.clear();
					if (notificationsPerDay.size() == 0) { 
						mainPanel.add(new HTML("<div class=\"no-notification-message\">" +
								"Looks like we've got nothing for you at the moment. <br> " +
								"You may begin by <strong>sharing</strong> an update!</div>"));
					}
					else {
						mainPanel.setHeight("");
						mainPanel.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
						mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);

						ArrayList<Date> sortedKeys=new ArrayList<Date>(notificationsPerDay.keySet());
						Collections.sort(sortedKeys, Collections.reverseOrder());

						int notCounter = 0;
						for (Date day : sortedKeys) {
							mainPanel.add(new DayWrapper(day));
							for (Notification notif : notificationsPerDay.get(day))  {
								mainPanel.add(new SingleNotificationView(notif));
								notCounter++;
							}
						}
						setNotificationsRead();
						if (notCounter < 5) {
							mainPanel.add(new Image(spacer));
							mainPanel.add(new Image(spacer));
						}
						if (notCounter > 5 && notCounter < 10)  
							mainPanel.add(new Image(spacer));
					}
				} 
				else
					loadingImage.setUrl(warning);	
			}
		});
	}

	private void showLoader() {
		mainPanel.clear();
		mainPanel.setWidth("100%");
		mainPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
		mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		mainPanel.add(loadingImage);


	}

	private void showSettingsLoader(boolean show) {
		if (show) {
			loadingPanel.setWidth("100%");
			loadingPanel.getElement().getStyle().setPosition(Position.ABSOLUTE);
			loadingPanel.getElement().getStyle().setTop(mainPanel.getAbsoluteTop()+200, Unit.PX);
			loadingPanel.getElement().getStyle().setLeft(mainPanel.getAbsoluteLeft(), Unit.PX);
			loadingPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
			loadingPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			loadingPanel.add(loadingImage);
			mainPanel.add(loadingPanel);
		} else
			mainPanel.remove(loadingPanel);
	}

	Timer t;
	private void setNotificationsRead() {
		t = new Timer() {

			@Override
			public void run() {
				notificationService.setAllUserNotificationsRead(new AsyncCallback<Boolean>() {
					public void onFailure(Throwable caught) {
					}
					public void onSuccess(Boolean result) {
					}
				});

			}
		};

		t.schedule(500);
	}
}
