/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.notifications.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.notifications.client.NotificationsService;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsServiceImpl
extends RemoteServiceServlet
implements NotificationsService {
    private static final Logger _log = LoggerFactory.getLogger(NotificationsServiceImpl.class);
    private static final String TYPE_CATEGORIES_FILENAME = "categorybytype.properties";
    private static final String TYPE_LABELS_FILENAME = "labelbytype.properties";
    private static final String TYPE_DESCRIPTIONS_FILENAME = "descbytype.properties";
    private PortalContext context = PortalContext.getConfiguration();
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    public UserInfo getUserInfo() {
        try {
            GCubeUser currUser = this.context.getCurrentUser(this.getThreadLocalRequest());
            String username = currUser.getUsername();
            String email = currUser.getEmail();
            String fullName = currUser.getFullname();
            String thumbnailURL = currUser.getUserAvatarURL();
            UserInfo toReturn = new UserInfo(username, fullName, thumbnailURL, email, null, true, false, null);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserInfo();
        }
    }

    public HashMap<Date, ArrayList<Notification>> getUserNotifications() {
        HashMap<Date, ArrayList<Notification>> toReturn = new HashMap<Date, ArrayList<Notification>>();
        try {
            for (Notification notification : this.store.getAllNotificationByUser(this.context.getCurrentUser(this.getThreadLocalRequest()).getUsername(), 70)) {
                Date dateWithoutTime = this.removeTimePart(notification.getTime());
                notification.setDescription(this.replaceAmpersand(notification.getDescription()));
                if (!toReturn.containsKey(dateWithoutTime)) {
                    ArrayList<Notification> nots = new ArrayList<Notification>();
                    nots.add(notification);
                    toReturn.put(dateWithoutTime, nots);
                    continue;
                }
                toReturn.get(dateWithoutTime).add(notification);
            }
        }
        catch (Exception e) {
            _log.error("While trying to get User notifications");
            e.printStackTrace();
        }
        return toReturn;
    }

    public HashMap<Date, ArrayList<Notification>> getUserNotificationsByRange(int from, int quantity) {
        HashMap<Date, ArrayList<Notification>> toReturn = new HashMap<Date, ArrayList<Notification>>();
        try {
            for (Notification notification : this.store.getRangeNotificationsByUser(this.context.getCurrentUser(this.getThreadLocalRequest()).getUsername(), from, quantity)) {
                Date dateWithoutTime = this.removeTimePart(notification.getTime());
                if (!toReturn.containsKey(dateWithoutTime)) {
                    ArrayList<Notification> nots = new ArrayList<Notification>();
                    nots.add(notification);
                    toReturn.put(dateWithoutTime, nots);
                    continue;
                }
                toReturn.get(dateWithoutTime).add(notification);
            }
        }
        catch (Exception e) {
            _log.error("While trying to get User notifications");
            e.printStackTrace();
        }
        return toReturn;
    }

    private Date removeTimePart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public boolean setAllUserNotificationsRead() {
        try {
            this.store.setAllNotificationReadByUser(this.context.getCurrentUser(this.getThreadLocalRequest()).getUsername());
        }
        catch (Exception e) {
            _log.error("While trying to set User notifications Read");
            e.printStackTrace();
        }
        return false;
    }

    public LinkedHashMap<String, ArrayList<NotificationPreference>> getUserNotificationPreferences() {
        String userid = this.context.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        Properties categories = this.getCategoriesByType();
        Properties labels = this.getLabelsByType();
        Properties descriptions = this.getDescriptionsByType();
        TreeMap treeMap = new TreeMap();
        try {
            Map storePreferences = this.store.getUserNotificationPreferences(userid);
            for (NotificationType type : storePreferences.keySet()) {
                String category = categories.getProperty(type.toString());
                String typeLabel = labels.getProperty(type.toString());
                String typeDesc = descriptions.getProperty(type.toString());
                if (category == null) continue;
                if (treeMap.containsKey(category)) {
                    ((ArrayList)treeMap.get(category)).add(new NotificationPreference(type, typeLabel, typeDesc, (NotificationChannelType[])storePreferences.get(type)));
                    continue;
                }
                ArrayList<NotificationPreference> toAdd = new ArrayList<NotificationPreference>();
                toAdd.add(new NotificationPreference(type, typeLabel, typeDesc, (NotificationChannelType[])storePreferences.get(type)));
                treeMap.put(category, toAdd);
            }
        }
        catch (Exception e) {
            _log.error("While trying to get getUser Notification Preferences for " + userid);
            e.printStackTrace();
        }
        _log.debug("Got Notification Preferences, returning to the client for user: " + userid);
        LinkedHashMap<String, ArrayList<NotificationPreference>> toReturn = new LinkedHashMap<String, ArrayList<NotificationPreference>>();
        for (String category : treeMap.descendingKeySet()) {
            ArrayList<NotificationPreference> toAdd = new ArrayList<NotificationPreference>();
            for (NotificationPreference pref : (ArrayList)treeMap.get(category)) {
                toAdd.add(pref);
            }
            Collections.sort(toAdd);
            toReturn.put(category, toAdd);
        }
        return toReturn;
    }

    private String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    public boolean setUserNotificationPreferences(Map<NotificationType, NotificationChannelType[]> enabledChannels) {
        return this.store.setUserNotificationPreferences(this.context.getCurrentUser(this.getThreadLocalRequest()).getUsername(), enabledChannels);
    }

    private Properties getCategoriesByType() {
        Properties props = new Properties();
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            String propertyfile = contextPath + File.separator + "conf" + File.separator + TYPE_CATEGORIES_FILENAME;
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            return props;
        }
        catch (IOException e) {
            _log.error("categorybytype.propertiesfile not found under conf dir, returning null");
            return null;
        }
    }

    private Properties getLabelsByType() {
        Properties props = new Properties();
        String propertyfile = "";
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            propertyfile = contextPath + File.separator + "conf" + File.separator + TYPE_LABELS_FILENAME;
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            return props;
        }
        catch (IOException e) {
            _log.error("labelbytype.propertiesfile not found under conf dir, returning null propertyfile -> " + propertyfile);
            return null;
        }
    }

    private Properties getDescriptionsByType() {
        Properties props = new Properties();
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            String propertyfile = contextPath + File.separator + "conf" + File.separator + TYPE_DESCRIPTIONS_FILENAME;
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            return props;
        }
        catch (IOException e) {
            _log.error("descbytype.propertiesfile not found under conf dir, returning null");
            return null;
        }
    }
}

