/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.validator.routines.UrlValidator;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaSeeker;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.htmlparser.beans.StringBean;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class ShareUpdateServiceImpl
extends RemoteServiceServlet
implements ShareUpdateService {
    private static final String ADMIN_ROLE = "Administrator";
    private static GCUBEClientLog _log = new GCUBEClientLog(ShareUpdateServiceImpl.class, new Properties[0]);
    private DatabookStore store;
    private boolean withinPortal = false;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = "test.user";
            this.withinPortal = false;
        } else {
            this.withinPortal = true;
        }
        System.out.println("SessionID = " + sessionID);
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ClientFeed share(String feedText, FeedType feedType, PrivacyLevel pLevel, String vreId, String linkTitle, String linkDesc, String url, String urlThumbnail, String host) {
        String escapedFeedText = this.escapeHtml(feedText);
        String username = this.getASLSession().getUsername();
        String email = String.valueOf(username) + "@isti.cnr.it";
        String fullName = String.valueOf(username) + " FULL";
        String thumbnailURL = "images/Avatar_default.png";
        if (this.withinPortal) {
            try {
                UserInfo user = this.getUserFromSession();
                email = user.getEmailaddress();
                fullName = user.getFullName();
                thumbnailURL = user.getAvatarId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Date feedDate = new Date();
        Feed toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, "", url, urlThumbnail, this.transformUrls(escapedFeedText), pLevel, fullName, email, thumbnailURL, linkTitle, linkDesc, host);
        _log.trace((Object)("Attempting to save Feed with text: " + escapedFeedText + " Level: " + pLevel));
        boolean result = this.store.saveUserFeed(toShare);
        if (pLevel == PrivacyLevel.VRES) {
            _log.trace((Object)"PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
            for (GroupModel vre : this.getUserVREs(username)) {
                String vreScope = this.getScopeByOrganizationId(vre.getGroupId());
                _log.trace((Object)("Attempting to write onto " + vreScope));
                try {
                    this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
                }
                catch (FeedIDNotFoundException e) {
                    _log.error((Object)("Error writing onto VRES Time Line" + vreScope));
                }
                _log.trace((Object)("Success writing onto " + vreScope));
            }
        } else if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0) {
            String vreScope = this.getScopeByOrganizationId(vreId);
            _log.trace((Object)("Attempting to write onto " + vreScope));
            try {
                this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
            }
            catch (FeedIDNotFoundException e) {
                _log.error((Object)("Error writing onto VRES Time Line" + vreScope));
            }
            _log.trace((Object)("Success writing onto " + vreScope));
        }
        if (!result) {
            return null;
        }
        ClientFeed cf = new ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(), this.replaceAmpersand(toShare.getDescription()), fullName, email, thumbnailURL, toShare.getLinkTitle(), toShare.getLinkDescription(), toShare.getUriThumbnail(), toShare.getLinkHost());
        return cf;
    }

    private UserInfo getUserFromSession() {
        return (UserInfo)this.getASLSession().getAttribute("USER_INFO_ATTR");
    }

    private void setUserInSession(UserInfo user) {
        this.getASLSession().setAttribute("USER_INFO_ATTR", (Object)user);
    }

    private String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    public String transformUrls(String feedText) {
        StringBuilder sb = new StringBuilder();
        String[] parts = feedText.split("\\s");
        int i = 0;
        while (i < parts.length) {
            if (parts[i].startsWith("http")) {
                try {
                    URL url = new URL(parts[i]);
                    if (i == 0 && parts.length == 1) {
                        return sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a link.").append("</a> ").toString();
                    }
                    sb.append("<a class=\"link\" style=\"font-size:14px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                }
                catch (MalformedURLException e) {
                    _log.error((Object)"MalformedURLException returning... ");
                    return feedText;
                }
            } else {
                sb.append(parts[i]);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    public UserInfo getUserInfo() {
        try {
            String username = this.getASLSession().getUsername();
            String email = String.valueOf(username) + "@isti.cnr.it";
            String fullName = String.valueOf(username) + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                this.getUserVREs(username);
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                HashMap vreNames = this.getUserVreNames(username);
                UserInfo toReturn = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, this.isAdmin(), vreNames);
                this.setUserInSession(toReturn);
                return toReturn;
            }
            _log.info((Object)"Returning test USER");
            HashMap<String, String> fakeVreNames = new HashMap<String, String>();
            fakeVreNames.put("1", "devVRE");
            return new UserInfo(this.getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserInfo();
        }
    }

    private HashMap<String, String> getUserVreNames(String username) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (GroupModel vre : this.getUserVREs(username)) {
            toReturn.put(vre.getGroupId(), vre.getGroupName());
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(OrganizationsUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        try {
            _log.trace((Object)("root: " + rootOrganization.getName()));
            return this.hasRole(ADMIN_ROLE, rootOrganization.getName(), currUser);
        }
        catch (NullPointerException e) {
            _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
            return false;
        }
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename) != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<GroupModel> getUserVREs(String username) {
        ArrayList<GroupModel> toReturn = new ArrayList<GroupModel>();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            User currUser = OrganizationsUtil.validateUser((String)username);
            for (Organization org : currUser.getOrganizations()) {
                if (!gm.isVRE(String.valueOf(org.getOrganizationId())).booleanValue()) continue;
                GroupModel toAdd = gm.getGroup("" + org.getOrganizationId());
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Failed reading User VREs for : " + username));
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private String getScopeByOrganizationId(String vreid) {
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            return gm.getScope(vreid);
        }
        catch (Exception e) {
            _log.error((Object)("Could not find a scope for this VREid: " + vreid));
            return null;
        }
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public String extractURL(String feedText) {
        String[] parts;
        String[] stringArray = parts = feedText.split("\\s");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.startsWith("http")) {
                try {
                    new URL(item);
                    return item;
                }
                catch (MalformedURLException e) {
                    _log.error((Object)"MalformedURLException returning... ");
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public LinkPreview checkLink(String linkToCheck) {
        URL pageURL;
        LinkPreview toReturn = null;
        _log.info((Object)("to check " + linkToCheck));
        linkToCheck = this.extractURL(linkToCheck);
        if (linkToCheck == null) {
            return null;
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(linkToCheck)) {
            _log.warn((Object)"url is NOT valid, returning nothing");
            return null;
        }
        _log.debug((Object)"url is valid");
        HttpURLConnection siteConnection = null;
        try {
            pageURL = new URL(linkToCheck);
            if (pageURL.getProtocol().equalsIgnoreCase("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                this.trustAllHTTPSConnections();
                siteConnection = (HttpsURLConnection)pageURL.openConnection();
            } else {
                siteConnection = (HttpURLConnection)pageURL.openConnection();
            }
        }
        catch (MalformedURLException e) {
            _log.error((Object)"url is not valid");
            return null;
        }
        catch (IOException e) {
            _log.error((Object)"url is not reachable");
            return null;
        }
        ArrayList imageUrls = new ArrayList();
        String host = pageURL.getHost().replaceAll("www.", "");
        OpenGraph ogLink = null;
        try {
            ogLink = new OpenGraph(linkToCheck, true, (URLConnection)siteConnection);
            if (ogLink != null && ogLink.getContent("title") != null) {
                String title = ogLink.getContent("title");
                String description = ogLink.getContent("description") != null ? ogLink.getContent("description") : "";
                String string = description = description.length() > 256 ? String.valueOf(description.substring(0, 256)) + "..." : description;
                if (ogLink.getContent("image") != null) {
                    imageUrls.add(ogLink.getContent("image"));
                } else {
                    ArrayList images = this.getImagesFromHTML(pageURL);
                    if (!images.isEmpty()) {
                        imageUrls = images;
                    }
                }
                toReturn = new LinkPreview(title, description, linkToCheck, host, imageUrls);
                return toReturn;
            }
            _log.info((Object)"No OpenGraph Found, going Best guess from page content");
            toReturn = this.getInfoFromHTML(pageURL, linkToCheck, host);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private ArrayList<String> getImagesFromHTML(URL pageURL) throws IOException {
        ArrayList<String> toReturn = new ArrayList<String>();
        InputStream input = pageURL.openStream();
        try {
            Document document = new Tidy().parseDOM(input, null);
            NodeList imgs = document.getElementsByTagName("img");
            int upTo = imgs.getLength() > 15 ? 15 : imgs.getLength();
            int i = 0;
            while (i < upTo) {
                System.out.println(i);
                toReturn.add(imgs.item(i).getAttributes().getNamedItem("src").getNodeValue());
                ++i;
            }
        }
        catch (NullPointerException e) {
            _log.error((Object)"Error parsing HTML for images, malformed HTML returning what I found so far ... ");
            return toReturn;
        }
        return toReturn;
    }

    private LinkPreview getInfoFromHTML(URL pageUrl, String link, String host) throws Exception {
        LinkPreview toReturn = null;
        String title = "";
        String description = "";
        InputStream input = pageUrl.openStream();
        Document document = new Tidy().parseDOM(input, null);
        NodeList titles = document.getElementsByTagName("title");
        if (titles != null && titles.getLength() > 0) {
            if (titles.item(0).getFirstChild() == null || titles.item(0).getFirstChild().getNodeValue() == null) {
                _log.error((Object)"[MANUAL-PARSE] Something wrong with the title element, returning ... ");
                return toReturn;
            }
            title = titles.item(0).getFirstChild().getNodeValue();
            MetaSeeker ms = null;
            try {
                ms = new MetaSeeker(link);
            }
            catch (Exception e) {
                _log.error((Object)"[MANUAL-PARSE] Something wrong with the meta seeker returning ... ");
                return toReturn;
            }
            description = ms.getContent("description") != null && !ms.getContent("description").isEmpty() ? ms.getContent("description") : this.createDescriptionFromContent(link);
            ArrayList<String> images = new ArrayList<String>();
            NodeList imgs = document.getElementsByTagName("img");
            int upTo = imgs.getLength() > 15 ? 15 : imgs.getLength();
            int i = 0;
            while (i < upTo) {
                String imageUrl = imgs.item(i).getAttributes().getNamedItem("src").getNodeValue();
                if (imageUrl.startsWith("/")) {
                    imageUrl = String.valueOf(pageUrl.getProtocol()) + "://" + pageUrl.getHost() + imageUrl;
                }
                images.add(imageUrl);
                ++i;
            }
            toReturn = new LinkPreview(title, description, link, host, images);
        }
        return toReturn;
    }

    private String createDescriptionFromContent(String link) {
        StringBean sb = new StringBean();
        sb.setURL(link);
        sb.setLinks(false);
        String description = sb.getStrings();
        description = description.length() > 256 ? String.valueOf(description.substring(0, 256)) + "..." : description;
        return description;
    }

    private void trustAllHTTPSConnections() {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("Error" + e);
        }
    }
}

