package org.gcube.portlets.user.shareupdates.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.storage.UriResolverReaderParameter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.scope.impl.ScopeBean.Type;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.databook.client.GCubeSocialNetworking;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.client.view.ShareUpdateForm;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaSeeker;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.portlets.user.shareupdates.shared.UserSettings;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlparser.beans.StringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.sun.net.ssl.HttpsURLConnection;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class ShareUpdateServiceImpl extends RemoteServiceServlet implements	ShareUpdateService {
	/**
	 * 
	 */
	private static final String ADMIN_ROLE = "Administrator";
	/**
	 * 
	 */

	private static final String STORAGE_OWNER = "gCubeSocialFramework";
	public static final String UPLOAD_DIR = "/social-framework-uploads";
	private static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
	/**
	 * 
	 */
	private static Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);
	/**
	 * The Cassandra store interface
	 */
	private DatabookStore store;
	/**
	 * used for debugging in eclipse
	 */
	private boolean withinPortal = false;
	/**
	 * connect to cassandra at startup
	 */
	public void init() {
		store = new DBCassandraAstyanaxImpl();	
	}

	public void destroy() {
		store.closeConnection();
	}


	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
			user = getDevelopmentUser();
			SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
			withinPortal = false;
		}
		else {
			withinPortal = true;
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	public String getDevelopmentUser() {
		String user = "test.user";
		//user = "massimiliano.assante";
		return user;
	}

	/**
	 * 
	 */
	public ClientFeed share(String postText, FeedType feedType,	PrivacyLevel pLevel, 
			String vreId, LinkPreview preview, String urlThumbnail, ArrayList<String> mentionedUserFullNames,String fileName, String filePathOnServer, boolean notifyGroup) {

		String escapedFeedText = escapeHtml(postText);

		ArrayList<PickingUser> mentionedUsers = null; 
		if (mentionedUserFullNames != null && ! mentionedUserFullNames.isEmpty()) {
			mentionedUsers = getSelectedUserIds(mentionedUserFullNames);
			escapedFeedText = convertMentionPeopleAnchorHTML(escapedFeedText, mentionedUsers);
		}


		ASLSession session = getASLSession();
		String username = session.getUsername();
		String email = username+"@isti.cnr.it";
		String fullName = username+" FULL";
		String thumbnailURL = "images/Avatar_default.png";

		if (withinPortal) {
			try {
				UserInfo user = getUserSettings().getUserInfo();
				email = user.getEmailaddress();
				fullName = user.getFullName();
				thumbnailURL = user.getAvatarId();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String linkTitle = preview.getTitle();
		String linkDesc = preview.getDescription();
		String host = preview.getHost();
		String url = preview.getUrl();

		Date feedDate = new Date();
		//this means the user has shared a file without text in it.
		String textToPost = "";
		if (escapedFeedText.compareTo(ShareUpdateForm.NO_TEXT_FILE_SHARE) == 0) {
			textToPost = convertFileNameAnchorHTML(url);
		} else {
			textToPost = transformUrls(escapedFeedText);
		}

		ScopeBean scope = new ScopeBean(session.getScope());
		String vreId2Set = scope.is(Type.VRE) ? scope.toString() : "";  

		Feed toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate,
				vreId2Set, url, urlThumbnail, textToPost, pLevel, fullName, email, thumbnailURL, linkTitle, linkDesc, host);

		_log.trace("Attempting to save Feed with text: " + escapedFeedText + " Level: " + pLevel);

		boolean result = store.saveUserFeed(toShare);

		//need to put the feed into VRES Timeline too
		if (pLevel == PrivacyLevel.VRES) {
			_log.trace("PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
			for (GroupModel vre : getUserVREs(username)) {					
				String vreScope = getScopeByOrganizationId(vre.getGroupId());
				_log.trace("Attempting to write onto " + vreScope);
				try {
					store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
				} catch (FeedIDNotFoundException e) {
					_log.error("Error writing onto VRES Time Line" + vreScope);
				}  //save the feed
				_log.trace("Success writing onto " + vreScope);				
			}

		} //share on a single VRE Timeline
		//receives a VreId(groupId) get the scope from the groupId
		else if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0) {
			String vreScope = (withinPortal) ? getScopeByOrganizationId(vreId) : "/gcube/devsec/devVRE";
			_log.trace("Attempting to write onto " + vreScope);
			try {
				store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
			} catch (FeedIDNotFoundException e) {
				_log.error("Error writing onto VRES Time Line" + vreScope);
			}  //save the feed
			_log.trace("Success writing onto " + vreScope);				
		}
		if (!result) return null;

		//everything went fine
		ClientFeed cf = new  ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(),
				replaceAmpersand(toShare.getDescription()), fullName, email, thumbnailURL, toShare.getLinkTitle(), toShare.getLinkDescription(), 
				toShare.getUriThumbnail(), toShare.getLinkHost());


		//send the notification about this posts to everyone in the group if notifyGroup is true
		if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0 && notifyGroup) {
			NotificationsManager nm = new ApplicationNotificationsManager(session, NEWS_FEED_PORTLET_CLASSNAME);
			Thread thread = new Thread(new PostNotificationsThread(toShare.getKey(), escapedFeedText, ""+session.getGroupId(), nm));
			thread.start();

		}
		//send the notification to the mentioned users	
		if (mentionedUsers != null && mentionedUsers.size() > 0) {
			NotificationsManager nm = new ApplicationNotificationsManager(session);
			Thread thread = new Thread(new MentionNotificationsThread(toShare.getKey(), escapedFeedText, nm, mentionedUsers));
			thread.start();
		}

		//it means I also should upload a copy on the user's Workspace root folder
		if (fileName != null && filePathOnServer != null) {
			//The workspace uploader Thread starts here asyncronously
			Thread thread = new Thread(new UploadToWorkspaceThread(username, fileName, filePathOnServer));
			thread.start();

		}

		return cf;	

	}

	/**
	 * convert the mentioned people in HTML anchor and also Encode the params Base64
	 * @param escapedFeedText
	 * @param taggedPeople
	 * @return
	 */
	private String convertMentionPeopleAnchorHTML(String escapedFeedText, ArrayList<PickingUser> taggedPeople) {
		for (PickingUser tagged : taggedPeople) {
			String taggedHTML = "<a class=\"link\" style=\"font-size:14px;\" href=\""+GCubeSocialNetworking.USER_PROFILE_LINK
					+"?"+
					new String(Base64.encodeBase64(GCubeSocialNetworking.USER_PROFILE_OID.getBytes()))+"="+
					new String(Base64.encodeBase64(tagged.getUsername().getBytes()))+"\">"+tagged.getFullName()+"</a> ";
			escapedFeedText = escapedFeedText.replace(tagged.getFullName(), taggedHTML);
		}
		return escapedFeedText;
	}

	private void setUserSettingsInSession(UserSettings user) {
		getASLSession().setAttribute(UserInfo.USER_INFO_ATTR, user);
	}
	private String replaceAmpersand(String toReplace) {
		String toReturn = toReplace.replaceAll("&amp;", "&");
		return toReturn;
	}
	/**
	 * utilty method that convert a url ina text in a clickable url by the browser
	 * and if the user has just pasted a link, converts the link in: shared a link
	 * @param feedText
	 * @return the text with the clickable url in it
	 */
	private String transformUrls(String feedText) {
		StringBuilder sb = new StringBuilder();
		// separate input by spaces ( URLs have no spaces )
		String [] parts = feedText.split("\\s");
		// Attempt to convert each item into an URL.
		for (int i = 0; i < parts.length; i++) {
			if (parts[i].startsWith("http")) {
				try {
					URL url = new URL(parts[i]);
					if (i == 0 && parts.length == 1) //then he shared just a link 
						return sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a link.").append("</a> ").toString();
					// If possible then replace with anchor...
					sb.append("<a class=\"link\" style=\"font-size:14px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");    
				} catch (MalformedURLException e) {
					// If there was an URL then it's not valid
					_log.error("MalformedURLException returning... ");
					return feedText;
				}
			} else {
				sb.append(parts[i]);
				sb.append(" ");
			}
		}
		return sb.toString();
	}
	/**
	 * 
	 * @param preview
	 * @return
	 */
	private String convertFileNameAnchorHTML(String url) {
		StringBuilder sb = new StringBuilder();
		sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a file.").append("</a> ").toString();
		return sb.toString();
	}

	@Override
	public UserSettings getUserSettings() {
		try {
			ASLSession session = getASLSession();
			String username = session.getUsername();
			String email = username+"@isti.cnr.it";
			String fullName = username+" FULL";
			String thumbnailURL = "images/Avatar_default.png";

			if (withinPortal) {
				getUserVREs(username);
				com.liferay.portal.model.UserModel user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), username);
				thumbnailURL = "/image/user_male_portrait?img_id="+user.getPortraitId();
				fullName = user.getFirstName() + " " + user.getLastName();
				email = user.getEmailAddress();
				ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
				String accountURL = themeDisplay.getURLMyAccount().toString();
				HashMap<String, String> vreNames = getUserVreNames(username);

				UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, isAdmin(), vreNames);
				UserSettings toReturn = new UserSettings(userInfo, 0, session.getScopeName(), isInfrastructureScope());
				setUserSettingsInSession(toReturn);

				return toReturn;
			}
			else {

				_log.info("Returning test USER = " + session.getUsername());
				HashMap<String, String> fakeVreNames = new  HashMap<String, String>();
				//fakeVreNames.put("/gcube/devsec/devVRE","devVRE");
				//fakeVreNames.put("/gcube/devNext/NexNext","NexNext");

				UserInfo user =  new UserInfo(session.getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
				return new UserSettings(user, 0, session.getScopeName(), false);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new UserSettings();
	}
	/**
	 * generate a preview of the file, upload the file on the storage and shorts the link
	 */
	@Override
	public LinkPreview checkUploadedFile(String fileName, String fileabsolutePathOnServer) {
		LinkPreview toReturn = null;

		String randomUploadFolderName = UUID.randomUUID().toString();
		String remoteFilePath = UPLOAD_DIR + "/" + randomUploadFolderName + "/" + fileName;
		//get the Storage Client
		String currScope = ScopeProvider.instance.get();
		ScopeProvider.instance.set("/"+PortalContext.getConfiguration().getInfrastructureName());
		IClient storageClient = new StorageClient(STORAGE_OWNER, AccessType.SHARED, MemoryType.PERSISTENT).getClient();
		ScopeProvider.instance.set(currScope);	

		String httpURL = "";
		//get the url to show, before actually uploading it
		String smpURI = storageClient.getUrl().RFile(remoteFilePath);

		//The storage uploader Thread starts here asyncronously
		Thread thread = new Thread(new UploadToStorageThread(storageClient, fileName, fileabsolutePathOnServer, remoteFilePath));
		thread.start();


		try {
			String mimeType = getMimeType(new File(fileabsolutePathOnServer), fileName);
			UriResolverReaderParameter resolver = new UriResolverReaderParameter(); 
			//get the url to show (though it could not be ready for download at this stage)
			httpURL = resolver.resolveAsUriRequest(smpURI, fileName, mimeType, true);

			switch (mimeType) {
			case "application/pdf":
				toReturn = FilePreviewer.getPdfPreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);
				break;
			case "application/vnd.openxmlformats-officedocument.wordprocessingml.document":
				mimeType = "application/wordprocessor";
				return FilePreviewer.getUnhandledTypePreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);
			case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":
				mimeType = "application/spreadsheet";
				return FilePreviewer.getUnhandledTypePreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);			
			case "application/vnd.openxmlformats-officedocument.presentationml.presentation":
				mimeType = "application/presentation";
				return FilePreviewer.getUnhandledTypePreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);
			case "image/png":
			case "image/gif":
			case "image/tiff":
			case "image/jpg":
			case "image/jpeg":
			case "image/bmp":
				toReturn = FilePreviewer.getImagePreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);
				break;
			default:
				return FilePreviewer.getUnhandledTypePreview(fileName, fileabsolutePathOnServer, httpURL, mimeType);

			}

		} catch (Exception e) {
			_log.error("Error while resolving or previewing file");
			e.printStackTrace();
		}	

		_log.debug("smpURI=" + smpURI);
		_log.debug("Returning httpURL=" + httpURL);
		return toReturn;
	}


	/**
	 * 
	 * @param file
	 * @return
	 * @throws IOException 
	 * @throws MagicParseException
	 * @throws MagicMatchNotFoundException
	 * @throws MagicException
	 */
	protected static String getMimeType(File file, String filenameWithExtension) throws IOException {
		TikaConfig config = TikaConfig.getDefaultConfig();
		Detector detector = config.getDetector();
		TikaInputStream stream = TikaInputStream.get(file);
		Metadata metadata = new Metadata();
		metadata.add(Metadata.RESOURCE_NAME_KEY, filenameWithExtension);
		MediaType mediaType = detector.detect(stream, metadata);
		return mediaType.getBaseType().toString();
	}

	/**
	 * return the id as key and the names as value of the vre a user is subscribed to
	 * @param username
	 * @return  the id as key and the names as value of the vre a user is subscribed to
	 */
	private HashMap<String, String> getUserVreNames(String username) {
		HashMap<String, String> toReturn = new HashMap<String, String>();
		if (isInfrastructureScope()) {
			for (GroupModel vre : getUserVREs(username)) {		
				toReturn.put(vre.getGroupId(), vre.getGroupName());
			}
		} else {
			for (GroupModel vre : getUserVREs(username)) {		
				if (vre.getGroupName().compareTo(getASLSession().getGroupName())==0)
					toReturn.put(vre.getGroupId(), vre.getGroupName());
			}
		}

		return toReturn;
	}
	/**
	 * tell if the user is a portal administrator or not
	 * @param username
	 * @return true if is admin
	 * @throws SystemException 
	 * @throws PortalException 
	 */
	private boolean isAdmin() throws PortalException, SystemException {
		com.liferay.portal.model.User currUser = OrganizationsUtil.validateUser(getASLSession().getUsername());
		List<Organization> organizations = OrganizationLocalServiceUtil.getOrganizations(0, OrganizationLocalServiceUtil.getOrganizationsCount());
		Organization rootOrganization = null;
		for (Organization organization : organizations) {
			if (organization.getName().equals(OrganizationsUtil.getRootOrganizationName() ) ) {
				rootOrganization = organization;
				break;
			}
		}		
		try {
			_log.trace("root: " + rootOrganization.getName() );
			return (hasRole(ADMIN_ROLE, rootOrganization.getName(), currUser));
		}
		catch (NullPointerException e) {
			_log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
			return false;
		}
	}

	/**
	 * 
	 * @param rolename
	 * @param organizationName
	 * @param user
	 * @return
	 * @throws SystemException 
	 */
	private boolean hasRole(String rolename, String organizationName, com.liferay.portal.model.User user) throws SystemException {
		for (Role role : user.getRoles()) 
			if (role.getName().compareTo(rolename) == 0 ) 
				return true;
		return false;
	}
	/**
	 * 
	 * @param username
	 * @return
	 */
	private ArrayList<GroupModel> getUserVREs(String username) {
		ArrayList<GroupModel> toReturn = new ArrayList<GroupModel>();
		com.liferay.portal.model.User currUser;
		try {
			GroupManager gm = new LiferayGroupManager();
			currUser = OrganizationsUtil.validateUser(username);
			for (Organization org : currUser.getOrganizations()) 
				if (gm.isVRE(org.getOrganizationId()+"")) {
					GroupModel toAdd = gm.getGroup(""+org.getOrganizationId());
					toReturn.add(toAdd);
				}
		} catch (Exception e) {
			_log.error("Failed reading User VREs for : " + username);
			e.printStackTrace();
			return toReturn;
		} 
		return toReturn;
	}

	private String getScopeByOrganizationId(String vreid) {
		GroupManager gm = new LiferayGroupManager();
		try {
			return gm.getScope(vreid);
		} catch (Exception e) {
			_log.error("Could not find a scope for this VREid: " + vreid);
			return null;
		} 
	}
	/**
	 * Escape an html string. Escaping data received from the client helps to
	 * prevent cross-site script vulnerabilities.
	 * 
	 * @param html the html string to escape
	 * @return the escaped string
	 */
	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		String toReturn = html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");

		// then replace all the line breaks by <br/>, and all the double spaces by the html version &nbsp;
		toReturn = toReturn.replaceAll("(\r\n|\n)","<br />");
		toReturn = toReturn.replaceAll("\\s\\s","&nbsp;&nbsp;");

		return toReturn;
	}

	/**
	 * utilty method that extract an url ina text
	 * @param feedText
	 * @return the text with the clickable url in it
	 */
	public String extractURL(String feedText) {
		// separate input by spaces ( URLs have no spaces )
		String [] parts = feedText.split("\\s");
		// Attempt to convert each item into an URL.   
		for( String item : parts ) {
			if (item.startsWith("http")) {
				try {
					new URL(item);
					return item;
				} catch (MalformedURLException e) {
					// If there was an URL then it's not valid
					_log.error("MalformedURLException returning... ");
					return null;
				}
			}
		}
		return null;
	}
	/**
	 * tries the following in the indicated order for Populating the Link preview
	 * Open Graph protocol
	 * Meta "title" and "description" tags
	 * Best guess from page content (not recommended)
	 * 
	 * Schema.org microdata  <-- This is still a TODO
	 */
	public LinkPreview checkLink(String linkToCheck) {
		LinkPreview toReturn = null;
		_log.info("to check " + linkToCheck);
		//look for a url in text
		linkToCheck = extractURL(linkToCheck);
		if (linkToCheck == null)
			return null; //no url

		String[] schemes = {"http","https"};
		UrlValidator urlValidator = new UrlValidator(schemes);
		if (! urlValidator.isValid(linkToCheck)) {
			_log.warn("url is NOT valid, returning nothing");
			return null;
		}
		_log.debug("url is valid");

		URL pageURL;
		URLConnection siteConnection = null;
		try {
			pageURL = new URL(linkToCheck);
			if (pageURL.getProtocol().equalsIgnoreCase("https")) {
				System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
				java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider()); 
				trustAllHTTPSConnections();
				siteConnection = (HttpsURLConnection) pageURL.openConnection();
			}
			else
				siteConnection = (HttpURLConnection) pageURL.openConnection();
		} catch (MalformedURLException e) {
			_log.error("url is not valid");
			return null;
		} catch (IOException e) {
			_log.error("url is not reachable");
			return null;
		}
		//pretend you're a browser (make my request from Java more “browsery-like”.) 
		siteConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");

		String title;
		String description;
		ArrayList<String> imageUrls = new ArrayList<String>();
		//get the host from the url
		String host = pageURL.getHost().replaceAll("www.", "");

		//try openGraph First
		OpenGraph ogLink = null;
		try {
			ogLink = new OpenGraph(linkToCheck, true, siteConnection);
			if (ogLink == null || ogLink.getContent("title") == null) { 
				//there is no OpenGraph for this link
				_log.info("No OpenGraph Found, going Best guess from page content") ;
				toReturn =  getInfoFromHTML(siteConnection, pageURL, linkToCheck, host);				
			} else {
				//there is OpenGraph
				_log.info("OpenGraph Found") ;
				title =  ogLink.getContent("title");
				description = (ogLink.getContent("description") != null)  ? ogLink.getContent("description") : "";
				description = ((description.length() > 256) ? description.substring(0, 256)+"..." : description);
				//look for the image ask the guesser if not present
				if (ogLink.getContent("image") != null) {
					String imageUrl = getImageUrlFromSrcAttribute(pageURL, ogLink.getContent("image"));
					imageUrls.add(imageUrl);
					_log.trace("OpenGraph getImage = " +imageUrl) ;
				}
				else {
					_log.trace("OpenGraph No Image, trying manuale parsing");
					ArrayList<String> images = getImagesWithCleaner(pageURL);
					if (! images.isEmpty())
						imageUrls = images;
				}
				toReturn = new LinkPreview(title, description, linkToCheck, host, imageUrls);
				return toReturn;
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return toReturn;
	}
	/**
	 * to use when OpenGraph is not available, Tries Metadata first, then Best guess from page content 
	 * @param pageUrl
	 * @param link
	 * @param host
	 * @return a LinPreview object instance filled with the extracted information
	 * @throws IOException
	 */
	private LinkPreview getInfoFromHTML(URLConnection connection, URL pageUrl, String link, String host)  throws Exception {
		LinkPreview toReturn = null;
		String title = "";
		String description = "";

		URLConnection conn = pageUrl.openConnection();
		//pretend you're a browser (make my request from Java more “browsery-like”.) 
		conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");

		MetaSeeker ms = null;
		try {
			title = getTitleFromHeader(pageUrl);
			ms = new MetaSeeker(connection, pageUrl);
			
			//try the metadata, otherwise ask the guesser
			description = (ms.getContent("description") != null &&  ! ms.getContent("description").isEmpty()) ?  ms.getContent("description") : createDescriptionFromContent(link);

			ArrayList<String> images = new ArrayList<String>();
			images = getImagesWithCleaner(pageUrl);
			toReturn = new LinkPreview(title, description, link, host, images);
			
		} catch(Exception e) {
			_log.error("[MANUAL-PARSE] Something wrong with the meta seeker returning ... ");
			return toReturn;
		}
		return toReturn;
	}
	/**
	 * @param pageURL
	 * @return the title of the page or null if can't read it
	 * @throws IOException
	 */
	private String getTitleFromHeader(URL pageURL) throws IOException {
		URLConnection conn = pageURL.openConnection();
		//pretend you're a browser (make my request from Java more “browsery-like”.) 
		conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");

		Charset charset = OpenGraph.getConnectionCharset(conn);
		BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
		String inputLine;
		StringBuffer headContents = new StringBuffer();

		// Loop through each line, looking for the closing head element
		while ((inputLine = dis.readLine()) != null)
		{
			if (inputLine.contains("</head>")) {
				inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
				inputLine = inputLine.concat("<body></body></html>");
				headContents.append(inputLine + "\r\n");
				break;
			}
			headContents.append(inputLine + "\r\n");
		}

		String headContentsStr = headContents.toString();
		HtmlCleaner cleaner = new HtmlCleaner();
		// parse the string HTML
		TagNode pageData = cleaner.clean(headContentsStr);
		// open only the title tags
		TagNode[] title = pageData.getElementsByName("title", true);
		if (title != null && title.length > 0) {
			String theTitle = title[0].getChildren().get(0).toString();
			_log.trace("theTitle: " + theTitle);
			return theTitle;
		}
		return null;
	}

	/**
	 * try with HtmlCleaner API to read the images
	 * @param pageURL
	 * @return the title of the page or null if can't read it
	 * @throws IOException
	 */
	private ArrayList<String> getImagesWithCleaner(URL pageURL) throws IOException {
		ArrayList<String> images = new ArrayList<String>();
		URLConnection conn = pageURL.openConnection();
		//pretend you're a browser (make my request from Java more “browsery-like”.) 
		conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");

		Charset charset = OpenGraph.getConnectionCharset(conn);
		BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
		String inputLine;
		StringBuffer headContents = new StringBuffer();

		// Loop through each line, looking for the closing head element
		while ((inputLine = dis.readLine()) != null) {
			headContents.append(inputLine + "\r\n");
		}

		String headContentsStr = headContents.toString();
		HtmlCleaner cleaner = new HtmlCleaner();
		// parse the string HTML
		TagNode pageData = cleaner.clean(headContentsStr);
		// open only the title tags
		TagNode[] imgs = pageData.getElementsByName("img", true);
		int upTo =  (imgs.length > 15) ? 15 : imgs.length;
		for (int i = 0; i < upTo; i++) {
			if (imgs[i].hasAttribute("src")) { 
				String imageUrl = getImageUrlFromSrcAttribute(pageURL, imgs[i].getAttributeByName("src"));
 				images.add(imageUrl);						
				_log.trace("[FOUND image] " + imageUrl);
			}
		}
		return images;
	}
	/**
	 * There are several ways to refer an image in a HTML, this method use an heuristic to get the actual image url
	 * @param pageURL the url 
	 * @param srcAttr the content of the img src attribute
	 * @return the image url ready to be referred outside native environment
	 */
	private String getImageUrlFromSrcAttribute(URL pageURL, String srcAttr) {
		String imageUrl = srcAttr;
		if (imageUrl.startsWith("/")) //referred as absolute path case 
			imageUrl = pageURL.getProtocol()+"://"+pageURL.getHost()+imageUrl;
		else if (imageUrl.startsWith("../")) { //relative path case
			imageUrl = pageURL.toExternalForm().endsWith("/") ? pageURL.toExternalForm() + imageUrl :  pageURL.toExternalForm() + "/" + imageUrl;
		}
		else if (!imageUrl.contains("/")) {  //the image is probably in the same folder
			// e.g. http://www.adomain.com/docrep/018/i3328e/i3328e00.htm?utm_source
			String imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"));
			imageUrl= imageFolder + "/" + imageUrl;
		}
		else if (!imageUrl.startsWith("http") ) { //e.g. http://adomain.com/anImage.png
			imageUrl = pageURL.toExternalForm().endsWith("/") ? pageURL.toExternalForm() + imageUrl :  pageURL.toExternalForm() + "/" + imageUrl;
		}
		return imageUrl;
	}
	/**
	 * generate the description parsing the content (Best Guess)
	 * @param link the link to check
	 * @return the description guessed
	 */
	private String createDescriptionFromContent(String link) {
		StringBean sb = new StringBean();
		sb.setURL(link);
		sb.setLinks(false);
		String description = sb.getStrings();
		description = ((description.length() > 256) ? description.substring(0, 256)+"..." : description);
		return description;
	}
	/**
	 * this method handles the non trusted https connections
	 */
	private void trustAllHTTPSConnections() {
		// Create a trust manager that does not validate certificate chains  
		TrustManager[] trustAllCerts = new TrustManager[]{  
				new X509TrustManager() {  
					public java.security.cert.X509Certificate[] getAcceptedIssuers() {  
						return null;  
					}  

					public void checkClientTrusted(  
							java.security.cert.X509Certificate[] certs, String authType) {  
					}  

					public void checkServerTrusted(  
							java.security.cert.X509Certificate[] certs, String authType) {  
					}  
				}  
		};  
		try {  
			SSLContext sc = SSLContext.getInstance("SSL");  
			sc.init(null, trustAllCerts, new java.security.SecureRandom());  
			HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());  
		} catch (Exception e) {  
			System.out.println("Error" + e);  
		}  		
	}

	/**
	 * Indicates whether the scope is the whole infrastructure.
	 * @return <code>true</code> if it is, <code>false</code> otherwise.
	 */
	private boolean isInfrastructureScope() {
		ScopeBean scope = new ScopeBean(getASLSession().getScope());
		return 	scope.is(Type.INFRASTRUCTURE);
	}

	/**
	 * 
	 * @return the screennames of the addressee (user logins e.g. pino.pini)
	 */
	public ArrayList<PickingUser> getSelectedUserIds(ArrayList<String> fullNames) {
		if (fullNames == null) 
			return new ArrayList<PickingUser>();
		else {
			ArrayList<PickingUser> allUsers = getPortalUsers();
			ArrayList<PickingUser> toReturn = new ArrayList<PickingUser>();
			for (String fullName : fullNames) 
				for (PickingUser puser : allUsers) {					
					if (puser.getFullName().compareTo(fullName) == 0) {
						toReturn.add(puser);
						break;
					}
				}
			return toReturn;
		}
	}

	@Override
	public ArrayList<PickingUser> getPortalUsers() {
		ArrayList<PickingUser> portalUsers = new ArrayList<PickingUser>();
		String currUser = getASLSession().getUsername();
		try {
			if (withinPortal) {
				UserManager um = new LiferayUserManager();
				GroupManager gm = new LiferayGroupManager();
				List<UserModel> users = um.listUsersByGroup(gm.getRootVO().getGroupId());
				for (UserModel user : users) {
					if (user.getScreenName().compareTo("test.user") != 0 && user.getScreenName().compareTo(currUser) != 0)  { //skip test.user & current user
						String thumbnailURL = "";
						com.liferay.portal.model.UserModel lifeUser = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), user.getScreenName());
						thumbnailURL = "/image/user_male_portrait?img_id="+lifeUser.getPortraitId();
						portalUsers.add(new PickingUser(user.getUserId(), user.getScreenName(), user.getFullname(), thumbnailURL));
					}
				}
			}
			else { //test users
				portalUsers.add(new PickingUser("12111", "massimiliano.assante", "Test User #1", ""));
				portalUsers.add(new PickingUser("14111", "massimiliano.assante", "Test Second User #2", ""));
				portalUsers.add(new PickingUser("11511", "massimiliano.assante", "Test Third User", ""));
				portalUsers.add(new PickingUser("11611", "massimiliano.assante", "Test Fourth User", ""));
				portalUsers.add(new PickingUser("11711", "massimiliano.assante", "Test Fifth User", ""));
				portalUsers.add(new PickingUser("11811", "massimiliano.assante", "Test Sixth User", ""));
				portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Ninth Testing User", ""));
				portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Eighth Testing User", ""));
				portalUsers.add(new PickingUser("11211", "giogio.giorgi", "Seventh Test User", ""));
				portalUsers.add(new PickingUser("2222", "pino.pinetti", "Tenth Testing User", ""));
			}
		} catch (Exception e) {
			_log.error("Error in server get all contacts ", e);
		}
		return portalUsers;
	}

}
