/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Date;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;

public class JobGisLayerModel
implements Serializable,
IsSerializable {
    private static final long serialVersionUID = -8982510983374359781L;
    public static final String JOBNAME = "Layer Title";
    public static final String JOBINDENTIFIER = "jobIdentifier";
    public static final String STARTTIME = "Start Time";
    public static final String SUBMITTIME = "Submit Time";
    public static final String PROGRESS = "Progress";
    public static final String ENDTIME = "End Time";
    public static final String ELAPSEDTIME = "Elapsed Time";
    public static final String GISVIEWERAPPLINK = "GisViewerApp Link";
    public static final String LAYERUUID = "Layer UUID";
    public static final String PERCENTAGE = "Percentage";
    public static final String DESCRIPTION = "Description";
    public static final String STATUS = "Status";
    private String jobIdentifier;
    private String jobName;
    private DownloadState downloadState;
    protected Date startTime;
    protected Date submitTime;
    protected Date endTime;
    protected String elapsedTime;
    private String layerDescription;
    private float percentage;
    private long totalPoints;
    private long completedPoints;
    private String layerUUID;
    private String gisViewerAppLink;

    public JobGisLayerModel() {
    }

    public JobGisLayerModel(String jobIdentifier, String layerTitle, DownloadState downloadState, long completedPoints, long totalPoints) {
        this.jobIdentifier = jobIdentifier;
        this.jobName = layerTitle;
        this.downloadState = downloadState;
        this.completedPoints = completedPoints;
        this.totalPoints = totalPoints;
    }

    public JobGisLayerModel(String jobIdentifier, String jobName, DownloadState downloadState, Date startTime, Date submitTime, Date endTime, String elapsedTime, String layerDescription, long completedPoints, long totalPoints, String gisViewerAppLink, String layerUUID) {
        this.jobIdentifier = jobIdentifier;
        this.jobName = jobName;
        this.downloadState = downloadState;
        this.startTime = startTime;
        this.submitTime = submitTime;
        this.endTime = endTime;
        this.elapsedTime = elapsedTime;
        this.layerDescription = layerDescription;
        this.totalPoints = totalPoints;
        this.completedPoints = completedPoints;
        this.gisViewerAppLink = gisViewerAppLink;
        this.layerUUID = layerUUID;
        this.updatePercentage();
    }

    private void updatePercentage() {
        this.percentage = this.completedPoints != 0L && this.totalPoints != 0L ? (float)(this.completedPoints * 100L / this.totalPoints) : 0.0f;
    }

    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    public String getJobName() {
        return this.jobName;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getElapsedTime() {
        return this.elapsedTime;
    }

    public String getLayerDescription() {
        return this.layerDescription;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public long getTotalPoints() {
        return this.totalPoints;
    }

    public long getCompletedPoints() {
        return this.completedPoints;
    }

    public String getLayerUUID() {
        return this.layerUUID;
    }

    public String getGisViewerAppLink() {
        return this.gisViewerAppLink;
    }

    public void setJobIdentifier(String jobIdentifier) {
        this.jobIdentifier = jobIdentifier;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void setLayerDescription(String layerDescription) {
        this.layerDescription = layerDescription;
    }

    public void setTotalPoints(long totalPoints) {
        this.totalPoints = totalPoints;
    }

    public void setCompletedPoints(long completedPoints) {
        this.completedPoints = completedPoints;
        this.updatePercentage();
    }

    public void setLayerUUID(String layerUUID) {
        this.layerUUID = layerUUID;
    }

    public void setGisViewerAppLink(String gisViewerAppLink) {
        this.gisViewerAppLink = gisViewerAppLink;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JobGisLayerModel [jobIdentifier=");
        builder.append(this.jobIdentifier);
        builder.append(", jobName=");
        builder.append(this.jobName);
        builder.append(", downloadState=");
        builder.append(this.downloadState);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", submitTime=");
        builder.append(this.submitTime);
        builder.append(", endTime=");
        builder.append(this.endTime);
        builder.append(", elapsedTime=");
        builder.append(this.elapsedTime);
        builder.append(", layerDescription=");
        builder.append(this.layerDescription);
        builder.append(", percentage=");
        builder.append(this.percentage);
        builder.append(", totalPoints=");
        builder.append(this.totalPoints);
        builder.append(", completedPoints=");
        builder.append(this.completedPoints);
        builder.append(", layerUUID=");
        builder.append(this.layerUUID);
        builder.append(", gisViewerAppLink=");
        builder.append(this.gisViewerAppLink);
        builder.append("]");
        return builder.toString();
    }
}

