/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResult;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ClusterStructuresForResultRow
implements Serializable {
    private static final long serialVersionUID = 1205113606387863736L;
    private ArrayList<String> listResultRowServiceID;
    private ArrayList<String> listFoundDataSources = new ArrayList();
    private HashMap<String, ArrayList<String>> hashScientificNameResultRowServiceID = new HashMap();
    private boolean isReduced;
    private int allResultRowSize;
    private int resultSize;
    private Map<String, ResultRow> hashResult = new HashMap();

    public ClusterStructuresForResultRow() {
    }

    public ClusterStructuresForResultRow(SearchResult<ResultRow> result, boolean isReduced, int totalRow) {
        for (ResultRow row : result.getResults()) {
            this.hashResult.put(row.getServiceId(), row);
        }
        this.isReduced = isReduced;
        this.allResultRowSize = totalRow;
        this.resultSize = result.getResults().size();
        this.createStructures(result.getResults());
    }

    public void createStructures(ArrayList<ResultRow> arrayListRR) {
        if (arrayListRR.size() > 0) {
            for (ResultRow row : arrayListRR) {
                String dataSource;
                String keyScientificName = "Name not found";
                if (row.getParents().get(0) != null) {
                    keyScientificName = ((Taxon)row.getParents().get(0)).getName();
                    keyScientificName = keyScientificName == null || keyScientificName.isEmpty() ? "Undefined" : NormalizeString.lowerCaseUpFirstChar((String)keyScientificName);
                    this.listResultRowServiceID = this.hashScientificNameResultRowServiceID.get(keyScientificName) == null ? new ArrayList() : (ArrayList)this.hashScientificNameResultRowServiceID.get(keyScientificName);
                }
                if ((dataSource = row.getDataSourceName()) == null || dataSource.isEmpty()) {
                    dataSource = "Data Source not found";
                }
                if (this.listFoundDataSources.indexOf(dataSource) == -1) {
                    this.listFoundDataSources.add(dataSource);
                }
                this.listResultRowServiceID.add(row.getServiceId());
                this.hashScientificNameResultRowServiceID.put(keyScientificName, this.listResultRowServiceID);
            }
        }
    }

    public HashMap<String, ArrayList<String>> getHashClusterScientificNameResultRowServiceID() {
        return this.hashScientificNameResultRowServiceID;
    }

    public List<String> getListFoundDataSources() {
        return this.listFoundDataSources;
    }

    public ArrayList<String> getListResultRowID() {
        return this.listResultRowServiceID;
    }

    public void setListResultRowID(ArrayList<String> listResultRowID) {
        this.listResultRowServiceID = listResultRowID;
    }

    public boolean isReduced() {
        return this.isReduced;
    }

    public void setReduced(boolean isReduced) {
        this.isReduced = isReduced;
    }

    public int getAllResultRowSize() {
        return this.allResultRowSize;
    }

    public void setAllResultRowSize(int allResultRowSize) {
        this.allResultRowSize = allResultRowSize;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setResultSize(int resultSize) {
        this.resultSize = resultSize;
    }

    public void setListFoundDataSources(ArrayList<String> listFoundDataSources) {
        this.listFoundDataSources = listFoundDataSources;
    }

    public Map<String, ResultRow> getHashResult() {
        return this.hashResult;
    }

    public void setHashResult(Map<String, ResultRow> hashResult) {
        this.hashResult = hashResult;
    }
}

