/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job.gislayer;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.filters.DateFilter;
import com.extjs.gxt.ui.client.widget.grid.filters.Filter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.Arrays;
import java.util.HashMap;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReSubmitJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerGridJob;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerJobSpeciesProgressBar;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerWindowInfoJobsSpecies;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.window.MessageBoxConfirm;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobGisLayerModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;

public class GisLayerGridJob
extends ContentPanel {
    private static final String REFRESH_LIST = "Refresh List";
    private static final String RE_SUBMIT = "Re-submit";
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private static final String INFO = "Info";
    private static final String OPEN_GIS_LAYER = "Open with Gis Viewer App";
    private ListStore<BaseModelData> store;
    private ToolBar toolBar = new ToolBar();
    private Grid<BaseModelData> grid;
    private HashMap<String, GisLayerWindowInfoJobsSpecies> listWindowInfo = new HashMap();
    private EventBus eventBus;
    private Button buttonInfo;
    private Button buttonCancel;
    private Button buttonSave;
    private Button buttonReSubmit;
    private Button buttonOpenGisViewerApp;
    private Button buttonRefreshList;
    private Menu menu = new Menu();

    public GisLayerGridJob(EventBus eventBus) {
        this.eventBus = eventBus;
        ColumnConfig name = new ColumnConfig("Layer Title", "Layer Title", 220);
        ColumnConfig progress = new ColumnConfig("Progress", "Progress", 150);
        ColumnConfig startDate = new ColumnConfig("Start Time", "Start Time", 140);
        ColumnConfig endTime = new ColumnConfig("End Time", "End Time", 140);
        ColumnConfig layerUUID = new ColumnConfig("Layer UUID", "Layer UUID", 140);
        ColumnConfig gisViewerAppLink = new ColumnConfig("GisViewerApp Link", "GisViewerApp Link", 140);
        ColumnConfig status = new ColumnConfig("Status", "Status", 80);
        ColumnModel cm = new ColumnModel(Arrays.asList(name, progress, status, layerUUID, gisViewerAppLink, startDate, endTime));
        this.setBodyBorder(false);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FitLayout());
        GridFilters filters = new GridFilters();
        filters.setLocal(true);
        DateFilter dateFilterStartDate = new DateFilter("Start Time");
        DateFilter dateFilterSubmitDate = new DateFilter("Submit Time");
        DateFilter dateFilterEnd = new DateFilter("End Time");
        filters.addFilter((Filter)dateFilterStartDate);
        filters.addFilter((Filter)dateFilterSubmitDate);
        filters.addFilter((Filter)dateFilterEnd);
        this.store = new ListStore();
        this.grid = new Grid(this.store, cm);
        this.grid.setLoadMask(true);
        1 downloadStateRenderer = new /* Unavailable Anonymous Inner Class!! */;
        2 jobSpeciesRenderer = new /* Unavailable Anonymous Inner Class!! */;
        progress.setRenderer((GridCellRenderer)jobSpeciesRenderer);
        status.setRenderer((GridCellRenderer)downloadStateRenderer);
        this.grid.getView().setEmptyText("Empty");
        this.grid.getView().setShowDirtyCells(false);
        this.grid.getView().setShowInvalidCells(false);
        this.grid.setBorders(false);
        this.grid.setColumnLines(true);
        this.grid.addPlugin((ComponentPlugin)filters);
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.grid);
        this.createGridToolBar();
        this.createMenuItemsOnGrid();
    }

    public void addJobIntoGrid(JobGisLayerModel jobModel, GisLayerJobSpeciesProgressBar jobProgressBar) {
        BaseModelData baseModelData = new BaseModelData();
        baseModelData.set("jobIdentifier", (Object)jobModel.getJobIdentifier());
        baseModelData.set("Layer Title", (Object)jobModel.getJobName());
        baseModelData.set("Progress", (Object)jobProgressBar);
        baseModelData.set("Status", (Object)jobModel.getDownloadState().toString());
        baseModelData.set("Submit Time", (Object)jobModel.getSubmitTime());
        baseModelData.set("End Time", (Object)jobModel.getEndTime());
        baseModelData.set("Start Time", (Object)jobModel.getStartTime());
        baseModelData.set("Elapsed Time", (Object)jobModel.getElapsedTime());
        baseModelData.set("GisViewerApp Link", (Object)jobModel.getGisViewerAppLink());
        baseModelData.set("Layer UUID", (Object)jobModel.getLayerUUID());
        baseModelData.set(jobModel.getJobIdentifier(), (Object)jobModel);
        this.store.add((ModelData)baseModelData);
        this.updateJobInfo(jobModel);
    }

    private void updateJobInfo(JobGisLayerModel jobModel) {
        GisLayerWindowInfoJobsSpecies win = (GisLayerWindowInfoJobsSpecies)this.listWindowInfo.get(jobModel.getJobIdentifier());
        if (win == null) {
            win = new GisLayerWindowInfoJobsSpecies();
            win.setWindowTitle("Job " + jobModel.getJobName() + " description:");
        }
        win.updateDescription(jobModel);
        this.listWindowInfo.put(jobModel.getJobIdentifier(), win);
    }

    public void updateStatus(JobGisLayerModel jobModel, GisLayerJobSpeciesProgressBar jobProgressBar) {
        BaseModelData job = (BaseModelData)this.store.findModel("jobIdentifier", (Object)jobModel.getJobIdentifier());
        if (job != null) {
            job.set("Progress", (Object)jobProgressBar);
            job.set("Submit Time", (Object)jobModel.getSubmitTime());
            job.set("Status", (Object)jobModel.getDownloadState().toString());
            job.set("End Time", (Object)jobModel.getEndTime());
            job.set("Elapsed Time", (Object)jobModel.getElapsedTime());
            job.set("Start Time", (Object)jobModel.getStartTime());
            job.set("GisViewerApp Link", (Object)jobModel.getGisViewerAppLink());
            job.set("Layer UUID", (Object)jobModel.getLayerUUID());
            this.updateJobInfo(jobModel);
            this.store.update((ModelData)job);
        }
    }

    public void removeGisLayerJobByIdentifier(String jobIdentifier) {
        BaseModelData job = (BaseModelData)this.store.findModel("jobIdentifier", (Object)jobIdentifier);
        if (job != null) {
            this.store.remove((ModelData)job);
        }
    }

    private void viewInfoJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            GisLayerWindowInfoJobsSpecies win = (GisLayerWindowInfoJobsSpecies)this.listWindowInfo.get(baseModelData.get("jobIdentifier"));
            win.show();
        }
    }

    private void cancelJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String name = (String)baseModelData.get("Layer Title");
            MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", "Are you sure you want to delete the job " + name + "?");
            mbc.getMessageBoxConfirm().addCallback((Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void saveJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String load = baseModelData.get("Status").toString();
            if (load.compareTo(DownloadState.COMPLETED.toString()) == 0 || load.compareTo(DownloadState.SAVED.toString()) == 0) {
                String jobIdentifier = (String)baseModelData.get("jobIdentifier");
                JobGisLayerModel jobModel = (JobGisLayerModel)baseModelData.get(jobIdentifier);
                this.eventBus.fireEvent((GwtEvent)new SaveJobEvent(jobIdentifier, jobModel.getJobName(), SearchResultType.GIS_LAYER_POINT, jobModel));
            } else {
                String name = (String)baseModelData.get("Layer Title");
                MessageBox.alert((String)"Alert", (String)("The job " + name + " " + "can not be saved until it has completed!"), null);
            }
        }
    }

    private void resubmitJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String load = baseModelData.get("Status").toString();
            if (load.compareTo(DownloadState.FAILED.toString()) == 0 || load.compareTo(DownloadState.COMPLETED.toString()) == 0 || load.compareTo(DownloadState.SAVED.toString()) == 0) {
                String jobIdentifier = (String)baseModelData.get("jobIdentifier");
                JobGisLayerModel jobModel = (JobGisLayerModel)baseModelData.get(jobIdentifier);
                this.eventBus.fireEvent((GwtEvent)new ReSubmitJobEvent(SearchResultType.GIS_LAYER_POINT, null, null, jobModel));
            } else {
                String name = (String)baseModelData.get("Name");
                MessageBox.alert((String)INFO, (String)("The job " + name + " " + "can not be re-submitted until it has completed!"), null);
            }
        }
    }

    private void createGridToolBar() {
        this.buttonInfo = new Button(INFO);
        this.buttonInfo.setScale(Style.ButtonScale.MEDIUM);
        this.buttonInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getInfoIcon()));
        this.buttonInfo.setStyleAttribute("margin-left", "5px");
        this.buttonInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonCancel = new Button(CANCEL);
        this.buttonCancel.setScale(Style.ButtonScale.MEDIUM);
        this.buttonCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getDelete()));
        this.buttonCancel.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonSave = new Button(SAVE);
        this.buttonSave.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        this.buttonSave.setScale(Style.ButtonScale.MEDIUM);
        this.buttonSave.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonReSubmit = new Button(RE_SUBMIT);
        this.buttonReSubmit.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getReSubmit()));
        this.buttonReSubmit.setScale(Style.ButtonScale.MEDIUM);
        this.buttonReSubmit.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRefreshList = new Button(REFRESH_LIST);
        this.buttonRefreshList.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getRefresh()));
        this.buttonRefreshList.setScale(Style.ButtonScale.MEDIUM);
        this.buttonRefreshList.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonOpenGisViewerApp = new Button(OPEN_GIS_LAYER);
        this.buttonOpenGisViewerApp.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe16()));
        this.buttonOpenGisViewerApp.setScale(Style.ButtonScale.MEDIUM);
        this.buttonOpenGisViewerApp.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolBar.add((Component)this.buttonInfo);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonSave);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonCancel);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonOpenGisViewerApp);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)new FillToolItem());
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonRefreshList);
        this.setTopComponent((Component)this.toolBar);
        this.enableButtonOnClick(false);
    }

    private void openLayerSelectedWithGisViewerApp() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String url = (String)baseModelData.get("GisViewerApp Link");
            if (url == null) {
                Window.alert((String)("The task '" + baseModelData.get("Layer Title") + "' does not contain a valid GisViewer App link, Is it completed?"));
                return;
            }
            Window.open((String)url, (String)"", (String)"");
        }
    }

    public void enableToolBar(boolean bool) {
        this.toolBar.setEnabled(bool);
    }

    public void resetStore() {
        this.store.removeAll();
    }

    public void enableButtonOnClick(boolean bool) {
        this.buttonCancel.setEnabled(bool);
        this.buttonInfo.setEnabled(bool);
        this.buttonSave.setEnabled(bool);
        this.buttonReSubmit.setEnabled(bool);
    }

    public void createMenuItemsOnGrid() {
        MenuItem menuOpenWithGis = new MenuItem();
        menuOpenWithGis.setText(OPEN_GIS_LAYER);
        menuOpenWithGis.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe16()));
        menuOpenWithGis.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuOpenWithGis);
        MenuItem menuInfo = new MenuItem();
        menuInfo.setText(INFO);
        menuInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getInfoIcon()));
        menuInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuInfo);
        MenuItem menuSave = new MenuItem();
        menuSave.setText(SAVE);
        menuSave.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        menuSave.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuSave);
        MenuItem menuCancel = new MenuItem();
        menuCancel.setText(CANCEL);
        menuCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getDelete()));
        menuCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuCancel);
        MenuItem menuResubmit = new MenuItem();
        menuResubmit.setText(RE_SUBMIT);
        menuResubmit.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getReSubmit()));
        menuResubmit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.setContextMenu(this.menu);
    }

    static /* synthetic */ void access$000(GisLayerGridJob x0) {
        x0.viewInfoJob();
    }

    static /* synthetic */ void access$100(GisLayerGridJob x0) {
        x0.cancelJob();
    }

    static /* synthetic */ void access$200(GisLayerGridJob x0) {
        x0.saveJob();
    }

    static /* synthetic */ void access$300(GisLayerGridJob x0) {
        x0.resubmitJob();
    }

    static /* synthetic */ EventBus access$400(GisLayerGridJob x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$500(GisLayerGridJob x0) {
        x0.openLayerSelectedWithGisViewerApp();
    }
}

