/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ChangeColumnTypeProgressUpdater extends Timer {

	protected ArrayList<ChangeColumnTypeProgressListener> listeners = new ArrayList<ChangeColumnTypeProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getChangeColumnTypeMonitor(new AsyncCallback<ChangeColumnTypeMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(ChangeColumnTypeMonitor result) {
						Log.info("retrieved CMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();
							break;
						case STOPPED:
							cancel();
							stopMessage(result);	
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Succeded TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

				});

	}

	protected void errorMessage(ChangeColumnTypeMonitor result) {
		Log.info("Change Column Type Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Changing Column Type";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Changing Column Type";
			details = "Error Changing Column Type";
		}

		fireOperationFailed(th, failure, details);
	}

	protected void stopMessage(ChangeColumnTypeMonitor result) {
		Log.info("Change Column Type Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped changing the column type";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped changing the column type";
			details = "Change the column type stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	
	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationGeneratingView();
	}
	

	protected void fireOperationUpdate(float elaborated) {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}
	
	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (ChangeColumnTypeProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}

	/**
	 * Add a new {@link ChangeColumnTypeProgressListener} to this
	 * {@link ChangeColumnTypeProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(ChangeColumnTypeProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link ChangeColumnTypeProgressListener} from this
	 * {@link ChangeColumnTypeProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(ChangeColumnTypeProgressListener listener) {
		listeners.remove(listener);
	}
}
