/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ReplaceBatchColumnProgressUpdater extends Timer {

	protected ArrayList<ReplaceBatchColumnProgressListener> listeners = new ArrayList<ReplaceBatchColumnProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getReplaceBatchColumnMonitor(new AsyncCallback<ReplaceBatchColumnMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(ReplaceBatchColumnMonitor result) {
						Log.info("retrieved ReplaceBatchColumnMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Replace Batch Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Replace Batch Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();	
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Replace Batch fisnish:"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(ReplaceBatchColumnMonitor result) {
		Log.info("Batch Replace Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library";
			details = "Batch replace failed";
		}
		
	
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(ReplaceBatchColumnMonitor result) {
		Log.info("Batch Replace Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped";
			details = "Stopped batch replace";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}
	
	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (ReplaceBatchColumnProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	

	/**
	 * Add a new {@link } to this
	 * {@link ReplaceBatchColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(ReplaceBatchColumnProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link } from this
	 * {@link ReplaceBatchColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(ReplaceColumnProgressListener listener) {
		listeners.remove(listener);
	}
}
