package org.gcube.portlets.user.td.columnwidget.client.mapping;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

public class ColumnMappingDialog extends Window {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";

	protected TRId trId;
	protected ColumnData selectedColumn;
	protected TabResource dimensionTR;
	protected ColumnData columnReference;
	protected EventBus eventBus;
	
	protected ArrayList<ColumnMappingListener> listeners;
	
	public ColumnMappingDialog(TRId trId, ColumnData selectedColumn,
			TabResource dimensionTR, ColumnData columnReference,
			EventBus eventBus) {
		this.trId = trId;
		this.selectedColumn = selectedColumn;
		this.dimensionTR = dimensionTR;
		this.columnReference= columnReference;
		this.eventBus = eventBus;
		Log.debug("ColumnMappingDialog: [trId:" + trId
				+ ", selectedColumn:" + selectedColumn + ", dimensionTR:"
				+ dimensionTR + ", columnReference:" + columnReference
				+ ", eventBus:" + eventBus
				+ "]");
		listeners=new ArrayList<ColumnMappingListener>();
		
		initWindow();
		ColumnMappingPanel columnMappingPanel = new ColumnMappingPanel(this,
				trId, selectedColumn,
				dimensionTR, columnReference,
				eventBus);
		add(columnMappingPanel);
	}
	
	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Column Mapping");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ResourceBundle.INSTANCE.replaceBatch());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();

	}
	
	/**
	 * 
	 * @param listener
	 */
	public void addColumnMappingListener(ColumnMappingListener listener) {
		listeners.add(listener);
	}

	/**
	 * 
	 * @param listener
	 */
	public void removeColumnMappingListener(ColumnMappingListener listener) {
		listeners.remove(listener);
	}


}
