package org.gcube.portlets.user.td.gwtservice.server.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class FilesStorage {

	public static final Logger logger = LoggerFactory
			.getLogger(FilesStorage.class);

	public String storageCSVTempFile(String user, File file) {
		IClient client = new StorageClient(user, AccessType.PUBLIC,
				MemoryType.VOLATILE).getClient();
		String remotePath = "/CSVimport/" + file.getName();
		logger.debug("remotePath: "+remotePath);
		client.put(true).LFile(file.getAbsolutePath()).RFile(remotePath);
		String url = client.getUrl().RFile(remotePath);
		return url;
	}

	/**
	 * user
	 * 
	 * @param user
	 *            User
	 * @param remotePath
	 *            File path on storage
	 * @param file
	 *            Destination file
	 * @throws TDGWTServiceException
	 */
	public void retriveFile(String user, WorkspaceItem wi, File file)
			throws TDGWTServiceException {
		InputStream is = null;
		try {

			org.gcube.common.homelibrary.home.workspace.folder.items.File gcubeItem = ((org.gcube.common.homelibrary.home.workspace.folder.items.File) wi);
			Handler.activateProtocol();
			URL smsHome = null;
			smsHome = new URL(gcubeItem.getPublicLink());
			logger.debug("smsHome: [host:" + smsHome.getHost() + " path:"
					+ smsHome.getPath() + " ref:" + smsHome.getRef()
					+ " userinfo:" + smsHome.getUserInfo() + " ]");
			URLConnection uc = null;
			uc = (URLConnection) smsHome.openConnection();
			is = uc.getInputStream();

		} catch (Exception e) {
			logger.error("Error retrieving file from storage", e);
			throw new TDGWTServiceException(
					"Error retrieving file from storage: "
							+ e.getLocalizedMessage(), e);
		}

		try {
			BufferedInputStream bis = new BufferedInputStream(is);
			FileOutputStream os = new FileOutputStream(file);
			BufferedOutputStream bos = new BufferedOutputStream(os);
			byte[] buffer = new byte[1024];
			int readCount;
			while ((readCount = bis.read(buffer)) > 0) {
				bos.write(buffer, 0, readCount);
			}
			bos.close();
		} catch (IOException e) {
			logger.error(
					"Error trasferring file from storage: "
							+ e.getLocalizedMessage(), e);
			throw new TDGWTServiceException(
					"Error trasferring file from storage: "
							+ e.getLocalizedMessage(), e);

		}
	}

	/**
	 * 
	 * @param user
	 *            User
	 * @param remotePath
	 *            File path on storage
	 * @return InputStream back to read the file
	 * @throws TDGWTServiceException
	 */
	public InputStream retriveImputStream(String user, WorkspaceItem wi)
			throws TDGWTServiceException {
		InputStream is = null;
		try {

			org.gcube.common.homelibrary.home.workspace.folder.items.File gcubeItem = ((org.gcube.common.homelibrary.home.workspace.folder.items.File) wi);
			Handler.activateProtocol();
			URL smsHome = null;
			smsHome = new URL(null, gcubeItem.getPublicLink(), new URLStreamHandler() {
				
		         @Override
		         protected URLConnection openConnection(URL u) throws IOException {
		             return new SMPURLConnection(u);
		         }
			
			});		
					
					
			//		new URL(gcubeItem.getPublicLink());
			logger.debug("smsHome: [host:" + smsHome.getHost() + " path:"
					+ smsHome.getPath() + " ref:" + smsHome.getRef()
					+ " userinfo:" + smsHome.getUserInfo() + " ]");
			URLConnection uc = null;
			uc = (URLConnection) smsHome.openConnection();
			is = uc.getInputStream();

		} catch (Exception e) {
			logger.error("Error retrieving file from storage", e);
			throw new TDGWTServiceException(
					"Error retrieving file from storage: "
							+ e.getLocalizedMessage(), e);
		}

		return is;

	}
	
	 
}
