/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * 
 * Implements the basic interfaces for access to the service.
 * 
 * <p>
 * Allows:  
 * <ul>
 * <li>Access to Tabular Resources</li>
 * <li>Import of CSV file</li>
 * <li>Import from SDMX Registry</li>
 * <ul>
 * </p>
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
@RemoteServiceRelativePath("TDGWTService")
public interface TDGWTService extends RemoteService {

	/**
	 * Get informations on the current tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource getTabResourceInformation() throws TDGWTServiceException;

	/**
	 * Get informations on tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource getTabResourceInformation(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Get creation date on tabular resource
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public String getTRCreationDate(TRId trId) throws TDGWTServiceException;

	/**
	 * Set current tabular resource
	 * 
	 * @param tr
	 * @throws TDGWTServiceException
	 */
	public void setTabResource(TabResource tabResource)
			throws TDGWTServiceException;

	/**
	 * Creates a TabResource on Service
	 * 
	 * @param tabResource
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TabResource createTabularResource(TabResource tabResource)
			throws TDGWTServiceException;

	/**
	 * Return Last Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TableData getLastTable(TRId trId) throws TDGWTServiceException;

	/**
	 * Return Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public TableData getTable(TRId trId) throws TDGWTServiceException;

	/**
	 * Return Metadata of Table
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TabMetadata> getTableMetadata(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Return Metadata of Tabular Resources
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TRMetadata> getTRMetadata(TRId trId)
			throws TDGWTServiceException;

	// Open

	/**
	 * Return all tabular resource of a user
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<TabResource> getTabularResources()
			throws TDGWTServiceException;

	/**
	 * Initialize Codelists Paging Loader
	 * 
	 * @throws TDGWTServiceException
	 */
	public void setCodelistsPagingLoader() throws TDGWTServiceException;

	/**
	 * Retrieves a portion of Codelists
	 * 
	 * @param codelistPagingLoadConfig
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CodelistPagingLoadResult getCodelistsPagingLoader(
			CodelistPagingLoadConfig codelistPagingLoadConfig)
			throws TDGWTServiceException;;

	/**
	 * Set open session for return all tabular resource of a user
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startTDOpen(TDOpenSession tdOpenSession)
			throws TDGWTServiceException;

	/**
	 * Retrieves the list of columns in the current table
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getColumns() throws TDGWTServiceException;

	/**
	 * Retrieves the list of columns in the table provided by trId
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<ColumnData> getColumns(TRId trId)
			throws TDGWTServiceException;

	/**
	 * Retrieves information about a specific column
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ColumnData getColumn(TRId trId, String columnName)
			throws TDGWTServiceException;

	/**
	 * Remove Tabular Resource From Service
	 * 
	 * @param trId
	 * @throws TDGWTServiceException
	 */
	public void removeTabularResource(TRId trId) throws TDGWTServiceException;

	// SDMX

	/**
	 * Get Codelist on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Codelist> getCodelists() throws TDGWTServiceException;

	/**
	 * Get Datasets on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Dataset> getDatasets() throws TDGWTServiceException;

	/**
	 * Get Agecies on a registry
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<Agencies> getAgencies() throws TDGWTServiceException;

	/**
	 * Set SDMX Registry Source
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource)
			throws TDGWTServiceException;

	// Import SDMX
	/**
	 * Start SDMX Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startSDMXImport(SDMXImportSession sdmxImportSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the SDMX Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public SDMXImportMonitor getSDMXImportMonitor()
			throws TDGWTServiceException;

	// Import CSV
	/**
	 * Get File Upload Monitor during the file upload operation in Import CSV
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public FileUploadMonitor getFileUploadMonitor()
			throws TDGWTServiceException;

	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void setCSVSession(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void getFileFromWorkspace(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public AvailableCharsetList getAvailableCharset()
			throws TDGWTServiceException;

	/**
	 * 
	 * @param encoding
	 * @param headerPresence
	 * @param delimiter
	 * @param comment
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<String> configureCSVParser(String encoding,
			HeaderPresence headerPresence, char delimiter, char comment)
			throws TDGWTServiceException;

	/**
	 * 
	 * @param errorsLimit
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ArrayList<CSVRowError> checkCSV(long errorsLimit)
			throws TDGWTServiceException;

	/**
	 * Start CSV Import and invokes the client library
	 * 
	 * @param s
	 * @throws TDGWTServiceException
	 */
	public void startCSVImport(CSVImportSession csvImportSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the CSV Import operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CSVImportMonitor getCSVImportMonitor() throws TDGWTServiceException;

	// Export CSV
	/**
	 * Get Operation Monitor during the CSV Export operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public CSVExportMonitor getCSVExportMonitor() throws TDGWTServiceException;

	/**
	 * Start CSV Export and invokes the client library
	 * 
	 * @param csvExportSession
	 * @throws TDGWTServiceException
	 */
	public void startCSVExport(CSVExportSession csvExportSession)
			throws TDGWTServiceException;

	// Export SDMX
	/**
	 * Get Operation Monitor during the SDMX Export operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public SDMXExportMonitor getSDMXExportMonitor()
			throws TDGWTServiceException;

	/**
	 * Start SDMX Export and invokes the client library
	 * 
	 * @param sdmxExportSession
	 * @throws TDGWTServiceException
	 */
	public void startSDMXExport(SDMXExportSession exportSession)
			throws TDGWTServiceException;

	// Change Table Type
	/**
	 * Get Operation Monitor during the Change Table Type operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ChangeTableTypeMonitor getChangeTableTypeMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change table type
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startChangeTableType(
			ChangeTableTypeSession changeTableTypeSession)
			throws TDGWTServiceException;

	// Column Operation

	/**
	 * Get Operation Monitor during the Change Column Type operation
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public ChangeColumnTypeMonitor getChangeColumnTypeMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change column type
	 * 
	 * @param changeColumnTypeSession
	 * @throws TDGWTServiceException
	 */
	public void startChangeColumnType(
			ChangeColumnTypeSession changeColumnTypeSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Delete Column operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public DeleteColumnMonitor getDeleteColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start delete column
	 * 
	 * 
	 * @param deleteColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startDeleteColumn(DeleteColumnSession deleteColumnSession)
			throws TDGWTServiceException;

	/**
	 * Get Operation Monitor during the Change the Column Label operation
	 * 
	 * 
	 * @return
	 * @throws TDGWTServiceException
	 */
	public LabelColumnMonitor getLabelColumnMonitor()
			throws TDGWTServiceException;

	/**
	 * Start change the column label
	 * 
	 * @param labelColumnSession
	 * @throws TDGWTServiceException
	 */
	public void startLabelColumn(LabelColumnSession labelColumnSession)
			throws TDGWTServiceException;

}
