package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExpressionGenerator;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ValueMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Operation Execution for edit and add row
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class OpExecution4EditRow extends OpExecutionBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(OpExecution4EditRow.class);

	private TabularDataService service;
	private EditRowSession editRowSession;

	public OpExecution4EditRow(TabularDataService service, EditRowSession editRowSession) {
		this.service = service;
		this.editRowSession = editRowSession;
	}

	@Override
	public void buildOpEx() throws TDGWTServiceException {
		OperationExecution invocation = null;

		logger.debug(editRowSession.toString());
		OperationDefinition operationDefinition;

		Map<String, Object> map = new HashMap<String, Object>();
		ValueMap valueMap = new ValueMap();
		ArrayList<Map<String, Object>> compositeValue = valueMap
				.genValueMap(editRowSession);

		if (editRowSession.isNewRow()) {
			logger.debug("Is a add row");
			operationDefinition = OperationDefinitionMap.map(
					OperationsId.AddRow.toString(), service);

			map.put(Constants.PARAMETER_ADD_ROW_COMPOSITE, compositeValue);

			invocation = new OperationExecution(
					operationDefinition.getOperationId(), map);

		} else {
			logger.debug("Is a edit row");

			Expression exp = ExpressionGenerator.genEditRowParamaterCondition(
					service, editRowSession);

			operationDefinition = OperationDefinitionMap.map(
					OperationsId.ModifyTuplesValuesByExpression.toString(),
					service);

			map.put(Constants.PARAMETER_ADD_ROW_COMPOSITE, compositeValue);
			map.put(Constants.PARAMETER_EDIT_ROW_CONDITION, exp);

			invocation = new OperationExecution(
					operationDefinition.getOperationId(), map);
		}

		operationExecutionSpec.setOp(invocation);

	}

}
