package org.gcube.portlets.user.td.gwtservice.shared.tr;

import java.io.Serializable;

import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.TimeDimensionType;

/**
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class DefNewColumn implements Serializable {

	private static final long serialVersionUID = 7467523779864189492L;

	protected String id;// For grid and combo only;
	protected ColumnTypeCode columnType;
	protected ColumnDataType columnDataType;
	protected String defaultValue;
	protected String label;
	protected String localeName;

	protected TimeDimensionType timeDimensionType;
	protected ColumnData codelistColumnReference;

	public DefNewColumn() {

	}

	/**
	 * For Code, CodeDescription and Annotation Column
	 * 
	 * @param label
	 * @param columnType
	 * @param localeName
	 * @param defaultValue
	 */
	public DefNewColumn(String label, ColumnTypeCode columnType,
			String defaultValue) {
		this.id = "1";
		this.label = label;
		this.columnType = columnType;
		this.defaultValue = defaultValue;
	}

	/**
	 * For Attribute and Measure Column
	 * 
	 * @param label
	 * @param columnType
	 * @param localeName
	 * @param defaultValue
	 */
	public DefNewColumn(String label, ColumnTypeCode columnType,
			ColumnDataType columnDataType, String defaultValue) {
		this.id = "1";
		this.label = label;
		this.columnType = columnType;
		this.columnDataType = columnDataType;
		this.defaultValue = defaultValue;
	}

	/**
	 * For CodeName Column
	 * 
	 * @param label
	 * @param columnType
	 * @param localeName
	 * @param defaultValue
	 */
	public DefNewColumn(String label, ColumnTypeCode columnType,
			String localeName, String defaultValue) {
		this.id = "1";
		this.label = label;
		this.columnType = columnType;
		this.localeName = localeName;
		this.defaultValue = defaultValue;
	}

	/**
	 * For Dimension
	 * 
	 * 
	 * @param label
	 * @param columnType
	 * @param timeDimensionType
	 * @param defaultValue
	 */
	public DefNewColumn(String label, ColumnTypeCode columnType,
			ColumnData codelistColumnReference, String defaultValue) {
		this.id = "1";
		this.label = label;
		this.columnType = columnType;
		this.codelistColumnReference = codelistColumnReference;
		this.defaultValue = defaultValue;

	}

	/**
	 * For TimeDimension
	 * 
	 * 
	 * @param label
	 * @param columnType
	 * @param timeDimensionType
	 * @param defaultValue
	 */
	public DefNewColumn(String label, ColumnTypeCode columnType,
			TimeDimensionType timeDimensionType, String defaultValue) {
		this.id = "1";
		this.label = label;
		this.columnType = columnType;
		this.timeDimensionType = timeDimensionType;
		this.defaultValue = defaultValue;

	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public ColumnTypeCode getColumnType() {
		return columnType;
	}

	public void setColumnType(ColumnTypeCode columnType) {
		this.columnType = columnType;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getLocaleName() {
		return localeName;
	}

	public void setLocaleName(String localeName) {
		this.localeName = localeName;
	}

	public ColumnDataType getColumnDataType() {
		return columnDataType;
	}

	public void setColumnDataType(ColumnDataType columnDataType) {
		this.columnDataType = columnDataType;
	}

	public TimeDimensionType getTimeDimensionType() {
		return timeDimensionType;
	}

	public void setTimeDimensionType(TimeDimensionType timeDimensionType) {
		this.timeDimensionType = timeDimensionType;
	}

	public ColumnData getCodelistColumnReference() {
		return codelistColumnReference;
	}

	public void setCodelistColumnReference(ColumnData codelistColumnReference) {
		this.codelistColumnReference = codelistColumnReference;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return "DefNewColumn [id=" + id + ", columnType=" + columnType
				+ ", columnDataType=" + columnDataType + ", defaultValue="
				+ defaultValue + ", label=" + label + ", localeName="
				+ localeName + ", timeDimensionType=" + timeDimensionType
				+ ", codelistColumnReference=" + codelistColumnReference + "]";
	}

}
