/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.shared.json;

import java.io.Serializable;
import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.destination.Destination;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class JSONExportSession implements Serializable {

	private static final long serialVersionUID = 407790340509190329L;

	protected String id;
	protected Destination destination;
	protected String itemId;
	protected String fileName;
	protected String fileDescription;
	protected ArrayList<ColumnData> columns;
	protected boolean exportViewColumns;

	public JSONExportSession() {
		super();
	}

	public ArrayList<ColumnData> getColumns() {
		return columns;
	}

	public void setColumns(ArrayList<ColumnData> columns) {
		this.columns = columns;
	}

	public ArrayList<String> getColumnsAsString() {
		ArrayList<String> columnsAsString = new ArrayList<String>();
		for (ColumnData cData : columns) {
			columnsAsString.add(cData.getColumnId());
		}
		return columnsAsString;
	}

	public String[] getColumnsAsArrayOfString() {
		ArrayList<String> columnsAsString = new ArrayList<String>();
		for (ColumnData cData : columns) {
			columnsAsString.add(cData.getColumnId());
		}
		return columnsAsString.toArray(new String[columnsAsString.size()]);
	}


	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Destination getDestination() {
		return destination;
	}

	public void setDestination(Destination destination) {
		this.destination = destination;
	}

	public String getItemId() {
		return itemId;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFileDescription() {
		return fileDescription;
	}

	public void setFileDescription(String fileDescription) {
		this.fileDescription = fileDescription;
	}

	public boolean isExportViewColumns() {
		return exportViewColumns;
	}

	public void setExportViewColumns(boolean exportViewColumns) {
		this.exportViewColumns = exportViewColumns;
	}

	@Override
	public String toString() {
		return "JSONExportSession [id=" + id + ", destination=" + destination
				+ ", itemId=" + itemId + ", fileName=" + fileName
				+ ", fileDescription=" + fileDescription + ", columns="
				+ columns + ", exportViewColumns=" + exportViewColumns + "]";
	}

	

}
