package org.gcube.portlets.user.td.gwtservice.shared.tr.rows;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

/**
 * 
 * @author giancarlo
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class EditRowSession implements Serializable {

	private static final long serialVersionUID = -4503878699159491057L;
	
	protected TRId trId;
	protected ArrayList<ColumnData> columns;
	protected HashMap<String, String> maps;
	protected boolean newRow;
	protected String rowId;
	
	public EditRowSession(){
		
	}
	
	public EditRowSession(TRId trId, ArrayList<ColumnData> columns,HashMap<String, String> maps){
		this.trId=trId;
		this.columns=columns;
		this.maps=maps;
		this.newRow=true;
	}
	
	public EditRowSession(TRId trId, ArrayList<ColumnData> columns,HashMap<String, String> maps, String rowId){
		this.trId=trId;
		this.columns=columns;
		this.maps=maps;
		this.newRow=false;
		this.rowId=rowId;
	}

	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}

	public ArrayList<ColumnData> getColumns() {
		return columns;
	}

	public void setColumns(ArrayList<ColumnData> columns) {
		this.columns = columns;
	}

	public HashMap<String, String> getMaps() {
		return maps;
	}

	public void setMaps(HashMap<String, String> maps) {
		this.maps = maps;
	}

	public boolean isNewRow() {
		return newRow;
	}

	public void setNewRow(boolean newRow) {
		this.newRow = newRow;
	}

	public String getRowId() {
		return rowId;
	}

	public void setRowId(String rowId) {
		this.rowId = rowId;
	}

	@Override
	public String toString() {
		return "EditRowSession [trId=" + trId + ", columns=" + columns
				+ ", maps=" + maps + ", newRow=" + newRow + ", rowId=" + rowId
				+ "]";
	}

	
	
	
}
