/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.wizardwidget.client.WizardCard;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.widget.core.client.Dialog.PredefinedButton;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.box.ConfirmMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TabResourcesSelectionCard extends WizardCard {
	protected final String GRIDWIDTH = "538px";
	protected final String GRIDHEIGHT = "430px";

	protected TabResourcesSelectionCard thisCard;
	protected TDOpenSession tdOpenSession;
	protected TabResourcesSelectionPanel tabResourcesSelectionPanel;
	protected TabResource selectedTabResource = null;

	public TabResourcesSelectionCard(final TDOpenSession tdOpenSession) {
		super("Select a Tabular Resource", "");

		this.tdOpenSession = tdOpenSession;
		thisCard = this;

		tabResourcesSelectionPanel = new TabResourcesSelectionPanel(res);

		// tabResourcesSelectionPanel.setResize(false);
		// tabResourcesSelectionPanel.setSize(GRIDWIDTH, GRIDHEIGHT);

		tabResourcesSelectionPanel
				.addSelectionHandler(new SelectionHandler<TabResource>() {

					public void onSelection(SelectionEvent<TabResource> event) {
						tdOpenSession
								.setSelectedTabResource(tabResourcesSelectionPanel
										.getSelectedItem());
						getWizardWindow().setEnableNextButton(true);
					}

				});

		setContent(tabResourcesSelectionPanel);

	}

	@Override
	public void setup() {
		Command sayFinish = new Command() {

			public void execute() {
				retrieveLastTable();
			}

		};

		getWizardWindow().setNextButtonCommand(sayFinish);
		// getWizardWindow().setFinishCommand(sayFinish);

	}

	protected void retrieveLastTable() {
		TDGWTServiceAsync.INSTANCE.getLastTable(tdOpenSession
				.getSelectedTabResource().getTrId(),
				new AsyncCallback<TableData>() {

					@Override
					public void onFailure(Throwable caught) {
						Log.debug("Attention",
								"This tabular resource does not have a valid table");
						AlertMessageBox d = new AlertMessageBox("Attention",
								"This tabular resource does not have a valid table");
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {
								removeTRWithLastTableNull();

							}
						});
						d.show();

					}

					@Override
					public void onSuccess(TableData result) {
						Log.debug("Retrieve last table: " + result);
						updateTDOpenSessionInfo(result);
					}

				});

	}

	protected void removeTRWithLastTableNull() {
		final ConfirmMessageBox mb = new ConfirmMessageBox("Remove",
				"Would you like to remove this tabular resource without table?");
		mb.addHideHandler(new HideHandler() {
			public void onHide(HideEvent event) {
				if (mb.getHideButton() == mb.getButtonById(PredefinedButton.YES
						.name())) {
					callRemoveLastTable();
				} else if (mb.getHideButton() == mb
						.getButtonById(PredefinedButton.NO.name())) {
					// perform NO action
				}
			}
		});
		mb.setWidth(300);
		mb.show();

	}
	
	protected void callRemoveLastTable(){
		Log.debug("Remove TR:" + tdOpenSession
				.getSelectedTabResource().getTrId());
		TDGWTServiceAsync.INSTANCE.removeTabularResource(tdOpenSession
				.getSelectedTabResource().getTrId(),
				new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						AlertMessageBox d = new AlertMessageBox("Error",
								"Error on remove TabResource: "
										+ caught.getLocalizedMessage());
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {
								// TODO Auto-generated method stub

							}
						});
						d.show();
						
					}

					public void onSuccess(Void result) {
						tabResourcesSelectionPanel.gridReload();
					}

				});
	}
	

	protected void updateTDOpenSessionInfo(TableData table) {
		TabResource tabResource = tdOpenSession.getSelectedTabResource();
		TRId trId = tabResource.getTrId();
		trId.setTableId(table.getTrId().getTableId());
		trId.setTableType(table.getTrId().getTableType());
		tabResource.setTrId(trId);
		tdOpenSession.setSelectedTabResource(tabResource);
		Log.debug("TdOpenSession: " + tdOpenSession);
		setTabularResource();
	}

	protected void setTabularResource() {
		TDGWTServiceAsync.INSTANCE.setTabResource(
				tdOpenSession.getSelectedTabResource(),
				new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						AlertMessageBox d = new AlertMessageBox("Error",
								"Error on set TabResource: "
										+ caught.getLocalizedMessage());
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {
								// TODO Auto-generated method stub

							}

						});
						d.show();

					}

					public void onSuccess(Void result) {
						getWizardWindow().fireCompleted(
								tdOpenSession.getSelectedTabResource()
										.getTrId());
						getWizardWindow().close(false);
						Log.info("OpenTD Tabular Resource selected :"
								+ tdOpenSession.getSelectedTabResource());
					}

				});

	}

}
