package org.gcube.portlets.user.td.tablewidget.client.history;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.tablewidget.client.progress.RollBackProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;

public class HistoryDiscard {
	protected TRId trId;
	protected EventBus eventBus;

	public HistoryDiscard(EventBus eventBus) {
		this.eventBus = eventBus;
	}

	public void discard() {
		retrieveCurrentTR();
	}

	protected void retrieveCurrentTR() {
		TDGWTServiceAsync.INSTANCE.getCurrentTRId(new AsyncCallback<TRId>() {

			public void onFailure(Throwable caught) {
				if (caught instanceof TDGWTSessionExpiredException) {
					eventBus.fireEvent(new SessionExpiredEvent(
							SessionExpiredType.EXPIREDONSERVER));
				} else {
					Log.error("Error retrieving trId: "
							+ caught.getLocalizedMessage());
					UtilsGXT3.alert("Error",
							"Error retrieving current tabular resource id");
				}
			}

			public void onSuccess(TRId result) {
				Log.debug("retrieved " + result);
				trId = result;
				callDiscard();
			}

		});
	}

	protected void callDiscard() {
		TDGWTServiceAsync.INSTANCE.discard(trId,
				new AsyncCallback<RollBackSession>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Error in discard: "
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error in discard",
									"Error: "+caught.getLocalizedMessage());
						}
					}

					public void onSuccess(RollBackSession result) {
						Log.debug("Discard Session " + result);
						if (result == null) {
							Log.info("Attention: undo not applicable");
							UtilsGXT3.info("Attention", "Undo not applicable");
						} else {
							callRollBackProgressDialog(result);
						}
					}

				});
	}

	protected void callRollBackProgressDialog(RollBackSession rollBackSession) {
		RollBackProgressDialog dialog = new RollBackProgressDialog(
				rollBackSession, eventBus);
		dialog.show();

	}

}
