package org.gcube.portlets.user.td.unionwizardwidget.client;

import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.wizardwidget.client.WizardWindow;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;

/**
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class UnionWizardTD extends WizardWindow {
	protected static final int WITHWIZARD = 800;
	protected static final int HEIGHTWIZARD = 520;

	protected UnionSession unionSession;
	protected TRId trId;

	/**
	 * 
	 * @param trId
	 * @param title
	 * @param eventBus
	 */
	public UnionWizardTD(TRId trId, String title, EventBus eventBus) {
		super(title, eventBus);
		Log.debug("UnionWizardTD: " + trId);
		setWidth(WITHWIZARD);
		setHeight(HEIGHTWIZARD);

		this.trId = trId;
		unionSession = new UnionSession();
		unionSession.setTrId(trId);

		TabResourcesSelectionCard tabResourcesSelection = new TabResourcesSelectionCard(
				unionSession);
		addCard(tabResourcesSelection);
		tabResourcesSelection.setup();

	}

}