package org.gcube.portlets.user.tdwx.datasource.td.map;

import java.util.List;

import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefinitionBuilder {
	protected Logger logger = LoggerFactory
			.getLogger(ColumnDefinitionBuilder.class);

	protected Column serviceColumn;
	protected String tooltipMessage;
	protected String columnName;
	protected String columnLocalId;
	protected boolean visible;
	protected org.gcube.portlets.user.tdwx.shared.model.ColumnType type;
	protected String columnLabel;
	protected int ordinalPosition;

	public ColumnDefinitionBuilder(Column serviceColumn, int ordinalPosition) {
		this.serviceColumn = serviceColumn;
		this.ordinalPosition = ordinalPosition;

		visible = true;
		type = org.gcube.portlets.user.tdwx.shared.model.ColumnType.USER;
		ColumnType ct = serviceColumn.getColumnType();
		if (ColumnTypeMap.isIdColumnType(ct)) {
			columnLabel = "Id";
			visible = false;
			type = org.gcube.portlets.user.tdwx.shared.model.ColumnType.SYSTEM;
		} else {
			if (ColumnTypeMap.isValidationColumnType(ct)) {
				type = org.gcube.portlets.user.tdwx.shared.model.ColumnType.VALIDATION;
			}

			NamesMetadata labelsMetadata = null;
			try {
				labelsMetadata = serviceColumn
						.getMetadata(NamesMetadata.class);
			} catch (NoSuchMetadataException e) {
				logger.debug("labelMetadata: NoSuchMetadataException "
						+ e.getLocalizedMessage());
			}

			if (labelsMetadata == null) {
				columnLabel = "nolabel";
			} else {
				LocalizedText cl = null;
				cl = labelsMetadata.getTextWithLocale("en");
				if (cl == null) {
					columnLabel = "nolabel";
					logger.debug("ColumnLabel no label in en");
				} else {
					columnLabel = cl.getValue();
				}
			}

		}

	}

	public boolean isVisible() {
		return visible;
	}

	public org.gcube.portlets.user.tdwx.shared.model.ColumnType getType() {
		return type;
	}

	public String getColumnLabel() {
		return columnLabel;
	}

	public String getColumnName() {
		columnName = serviceColumn.getName();
		return columnName;
	}

	public String getColumnLocalId() {
		columnLocalId = serviceColumn.getLocalId().getValue();
		return columnLocalId;
	}

	public ValidationReferencesMetadata getValidationReferencesMetadata() {
		ValidationReferencesMetadata refs = null;
		try {
			refs = serviceColumn
					.getMetadata(ValidationReferencesMetadata.class);
		} catch (NoSuchMetadataException e) {
			logger.debug("ValidationReferencesMetadata: NoSuchMetadataException "
					+ e.getLocalizedMessage());
		}

		return refs;
	}

	
	public String getTooltipMessage() {
		String valids = new String();
		ValidationsMetadata val=null;
		try {
			val = serviceColumn
					.getMetadata(ValidationsMetadata.class);
		} catch (NoSuchMetadataException e) {
			logger.debug("NamesMetadata: NoSuchMetadataException "
					+ e.getLocalizedMessage());
		}

		if (val != null) {
			List<Validation> listValidationsMetadata = ((ValidationsMetadata) val)
					.getValidations();
			for (Validation validation : listValidationsMetadata) {
				valids.concat(validation.getDescription() + "\n");
			}
		}
		tooltipMessage = valids;

		return tooltipMessage;
	}

	public ColumnDefinition build() {
		ColumnDefinition columnDefinition = new ColumnDefinition(
				getColumnName(), getColumnLocalId(), getColumnLabel());
		DataType dataType = serviceColumn.getDataType();
		columnDefinition.setValueType(DataTypeMap.getValueType(dataType));
		columnDefinition.setType(getType());
		columnDefinition.setPosition(ordinalPosition);
		columnDefinition.setTooltipMessage(getTooltipMessage());
		columnDefinition.setColumnTypeName(serviceColumn.getColumnType()
				.getName());
		columnDefinition.setColumnDataType(serviceColumn.getDataType()
				.getName());
		columnDefinition.setWidth(100);
		columnDefinition.setEditable(false);
		columnDefinition.setVisible(isVisible());

		return columnDefinition;
	}

}
