/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td;

import org.gcube.portlets.user.tdwx.datasource.td.TDXDataSource;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceX;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXFactory;
import org.gcube.portlets.user.tdwx.server.util.ServiceCredentials;
import org.gcube.portlets.user.tdwx.shared.model.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDXDataSourceFactory
implements DataSourceXFactory {
    private Logger logger = LoggerFactory.getLogger(TDXDataSourceFactory.class);
    private static final String ID = "TDXDataSourceFactory";

    public String getId() {
        return ID;
    }

    public DataSourceX openDataSource(ServiceCredentials serviceCredentials, TableId tableId) throws DataSourceXException {
        this.logger.debug("openDataSource: " + tableId);
        String table = tableId.getTableKey();
        TDXDataSource dataSource = new TDXDataSource(ID, serviceCredentials, table);
        return dataSource;
    }

    public void closeDataSource(ServiceCredentials serviceCredentials, DataSourceX dataSource) throws DataSourceXException {
        this.logger.debug("closeDataSource: " + dataSource);
        ((TDXDataSource)dataSource).close();
    }
}

