/**
 * 
 */
package org.gcube.portlets.user.td.wizardwidget.client;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public interface WizardListener {
	
	/**
	 * Called when the wizard is completed without errors
	 */
	public void completed(TRId id);

	
	/**
	 * Called when the operation is put in background
	 */
	public void putInBackground();
	
	/**
	 * Called when the wizard has been aborted by the user.
	 */
	public void aborted();
	
	/**
	 * Called when the something in the wizard is failed.
	 * @param title TODO
	 * @param message the failure reason or <code>null</code>.
	 * @param throwable the exception or <code>null</code>.
	 */
	public void failed(String title, String message, Throwable throwable);
	
}
