package org.gcube.data.analysis.tabulardata.client;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface TestServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.data.analysis.tabulardata.client.TestService
     */
    void testTable( org.gcube.data.analysis.tabulardata.model.table.Table table, AsyncCallback<org.gcube.data.analysis.tabulardata.model.table.Table> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static TestServiceAsync instance;

        public static final TestServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (TestServiceAsync) GWT.create( TestService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }


	void testColumn(Column column, AsyncCallback<Column> callback);
}
