package org.gcube.data.analysis.tabulardata.server;

import org.gcube.data.analysis.tabulardata.client.TestService;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class TestServiceImpl extends RemoteServiceServlet implements TestService {
	
	private static final Logger log = LoggerFactory.getLogger(TestServiceImpl.class);

	public Table testTable(org.gcube.data.analysis.tabulardata.model.table.Table table) throws IllegalArgumentException {
		System.out.println("Received table:\n"+ table);
		return table;
	}

	@Override
	public Column testColumn(Column column) throws IllegalArgumentException {
		System.out.println("Received column:\n"+ column);
		return column;
	}

}
