package org.gcube.portlets.user.templates.client.dialogs;

import java.util.ArrayList;

import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.user.templates.client.TGenConstants;
import org.gcube.portlets.user.templates.client.components.Coords;
import org.gcube.portlets.user.templates.client.components.D4sRichTextarea;
import org.gcube.portlets.user.templates.client.components.DroppingArea;
import org.gcube.portlets.user.templates.client.components.ExtButton;
import org.gcube.portlets.user.templates.client.components.images.Images;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

import com.extjs.gxt.ui.client.Style.IconAlign;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Padding;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.AccordionLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout.VBoxLayoutAlign;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;


/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 *
 */
public class ToolboxDialog extends Window {
	protected Images images = (Images) GWT.create(Images.class);
	Presenter presenter;
	final public static int buttonWidth = 125;
	
	protected static ExtButton titleb = new ExtButton("Title", ComponentType.TITLE);
	protected static ExtButton h1b = new ExtButton("Heading 1",  ComponentType.HEADING_1);
	protected static ExtButton h2b = new ExtButton("Heading 2",  ComponentType.HEADING_2);
	protected static ExtButton h3b = new ExtButton("Heading 3",  ComponentType.HEADING_3);
	protected static ExtButton h4b = new ExtButton("Heading 4",  ComponentType.HEADING_4);
	protected static ExtButton h5b = new ExtButton("Heading 5",  ComponentType.HEADING_5);
	protected static ExtButton imageb = new ExtButton("Image",  ComponentType.IMAGE);
	protected static ExtButton textb = new ExtButton("Text",  ComponentType.BODY);
	protected static ExtButton repeat = new ExtButton("Repetitive",  ComponentType.REPEAT_SEQUENCE);
	protected static ExtButton commentb = new ExtButton("Comment area",  ComponentType.COMMENT);
	protected static ExtButton instructionB = new ExtButton("Instruction area",  ComponentType.INSTRUCTION);
	protected static ExtButton attributeb = new ExtButton("Attribute",  ComponentType.ATTRIBUTE);
	protected static ExtButton pageB = new ExtButton("Page break",  ComponentType.PAGEBREAK);
	
	protected static ArrayList<ExtButton> repetitiveElements = new ArrayList<ExtButton>();
	
	public ToolboxDialog(final Presenter presenter, int left, int top) {
		super();
		this.presenter = presenter;
		
		
		setPosition(left, top);
	    setMaximizable(false);  
	    setResizable(false);
	    setHeading("Toolbox");  
	    setWidth(100);  
	    setHeight(640);  
	    //setIcon(Resources.ICONS.accordion());  
	    setLayout(new AccordionLayout());  
	    
	    VBoxLayout westLayout = new VBoxLayout();  
	    westLayout.setPadding(new Padding(5));  

	    westLayout.setVBoxLayoutAlign(VBoxLayoutAlign.CENTER);  
	    
	    VBoxLayout dcLayout = new VBoxLayout();  
	    dcLayout.setPadding(new Padding(5));  

	    dcLayout.setVBoxLayoutAlign(VBoxLayoutAlign.CENTER);  
	    
	    ContentPanel sc = new ContentPanel();  
	    sc.setSize(100, 400);
	    sc.setAnimCollapse(false);  
	    sc.setHeading("Fit layout");  
	    sc.setLayout(westLayout);  
	   // cp.getHeader().addTool(new ToolButton("x-tool-refresh"));  
	   
	
	    
	    ContentPanel dc = new ContentPanel();  
	    dc.setAnimCollapse(false);  
	    dc.setHeading("Double column layout");  
	    dc.setLayout(dcLayout);  
	   // cp.getHeader().addTool(new ToolButton("x-tool-refresh"));  
	  
	    add(sc); 
	    add(dc); 		
	    
	    
	    
	    
	    //
	  
	    titleb.setSize(buttonWidth, 25);
	    titleb.setIconAlign(IconAlign.LEFT); 
	    titleb.setIcon(AbstractImagePrototype.create(images.title()));
	    titleb.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.TITLE, TemplateModel.TEMPLATE_WIDTH - 50, 40);
			}
	    });
	  
	    h1b.setSize(buttonWidth, 25);
	    h1b.setIconAlign(IconAlign.LEFT); 
	    h1b.setIcon(AbstractImagePrototype.create(images.heading_1()));
	    h1b.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.HEADING_1, TemplateModel.TEMPLATE_WIDTH - 50, 35);
			}
	    });
	   
	    h2b.setSize(buttonWidth, 25);
	    h2b.setIconAlign(IconAlign.LEFT); 
	    h2b.setIcon(AbstractImagePrototype.create(images.heading_2()));
	    h2b.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.HEADING_2, TemplateModel.TEMPLATE_WIDTH - 50, 35);
			}
	    });
	   
	    h3b.setSize(buttonWidth, 25);
	    h3b.setIconAlign(IconAlign.LEFT); 
	    h3b.setIcon(AbstractImagePrototype.create(images.heading_3()));
	    h3b.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.HEADING_3, TemplateModel.TEMPLATE_WIDTH - 50, 35);
			}
	    });
	  
	    h4b.setSize(buttonWidth, 25);
	    h4b.setIconAlign(IconAlign.LEFT); 
	    h4b.setIcon(AbstractImagePrototype.create(images.heading_4()));
	    h4b.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.HEADING_4, TemplateModel.TEMPLATE_WIDTH - 50, 35);
			}
	    });
	  
	    h5b.setSize(buttonWidth, 25);
	    h5b.setIconAlign(IconAlign.LEFT); 
	    h5b.setIcon(AbstractImagePrototype.create(images.heading_5()));
	    h5b.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.HEADING_5, TemplateModel.TEMPLATE_WIDTH - 50, 35);
			}
	    });
	 
	    imageb.setSize(buttonWidth, 25);
	    imageb.setIconAlign(IconAlign.LEFT); 
	    imageb.setIcon(AbstractImagePrototype.create(images.image()));
	    imageb.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertDroppingArea(ComponentType.DYNA_IMAGE, TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT);
			}
	    });
	   
	    textb.setSize(buttonWidth, 25);
	    textb.setIconAlign(IconAlign.LEFT); 
	    textb.setIcon(AbstractImagePrototype.create(images.text()));
	    textb.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.insertStaticTextArea(ComponentType.BODY, TemplateModel.TEMPLATE_WIDTH - 50, 75);
			}
	    });
	   
	    repeat.setSize(buttonWidth, 25);
	    repeat.setIconAlign(IconAlign.LEFT); 
	    repeat.setIcon(AbstractImagePrototype.create(images.repetitive()));
	    repeat.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.openGroupingDialog();
			}
	    });
	   
	    commentb.setSize(buttonWidth, 25);
	    commentb.setIconAlign(IconAlign.LEFT); 
	    commentb.setIcon(AbstractImagePrototype.create(images.comment_area()));
	    commentb.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.addCommentArea(TemplateModel.TEMPLATE_WIDTH - 50, 60, false);
			}
	    });
	   
	    attributeb.setSize(buttonWidth, 25);
	    attributeb.setIconAlign(IconAlign.LEFT); 
	    attributeb.setIcon(AbstractImagePrototype.create(images.attribute_area()));
	    attributeb.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.openAttributeDialog(TemplateModel.TEMPLATE_WIDTH - 50, 40);
			}
	    });
	    
	    instructionB.setSize(buttonWidth, 25);
	    instructionB.setIconAlign(IconAlign.LEFT); 
	    instructionB.setIcon(AbstractImagePrototype.create(images.instruction_area()));
	    instructionB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.addInstructionArea(TemplateModel.TEMPLATE_WIDTH - 50, 60, false);				
			}
	    });
	    
	    pageB.setSize(buttonWidth, 25);
	    pageB.setIconAlign(IconAlign.LEFT); 
	    pageB.setIcon(AbstractImagePrototype.create(images.page_break()));
	    pageB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				presenter.addPageBreak();
			}
	    });
	    
	    sc.add(titleb);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(h1b);
	    repetitiveElements.add(h1b);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(h2b);
	    repetitiveElements.add(h2b);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(h3b);
	    repetitiveElements.add(h3b);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(h4b);
	    repetitiveElements.add(h4b);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(h5b);
	    repetitiveElements.add(h5b);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(imageb);
	    repetitiveElements.add(imageb);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(textb);
	    repetitiveElements.add(textb);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(repeat);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(attributeb);
	    sc.add(new HTML("&nbsp;"));
	    sc.add(commentb);
	   
	    sc.add(new HTML("&nbsp;"));
	    sc.add(instructionB);
	  
	    sc.add(new HTML("&nbsp;"));
	    sc.add(pageB);
	    
	    //**** Double Cols
	    
	    Button textextB = new Button("Text Text");
	    textextB.setSize(buttonWidth, 25);
	    textextB.setIconAlign(IconAlign.LEFT); 
	    textextB.setIcon(AbstractImagePrototype.create(images.text_text()));
	    textextB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				Coords start = presenter.getInsertionPoint();		
				D4sRichTextarea leftItem = new D4sRichTextarea(ComponentType.BODY, presenter, start.getX(), start.getY(), TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT);
				D4sRichTextarea rightItem = new D4sRichTextarea(ComponentType.BODY, presenter, start.getX(), start.getY(),  TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT);
				presenter.insertDoubleColumnItems(leftItem, rightItem);
			}
	    });
	    Button texImageB = new Button("Text Image");
	    texImageB.setSize(buttonWidth, 25);
	    texImageB.setIconAlign(IconAlign.LEFT); 
	    texImageB.setIcon(AbstractImagePrototype.create(images.text_image()));
	    texImageB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				Coords start = presenter.getInsertionPoint();
				D4sRichTextarea leftItem = new D4sRichTextarea(ComponentType.BODY, presenter, start.getX(), start.getY(),  TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT);
				leftItem.addStyleName("titleArea");
				DroppingArea rightItem = new DroppingArea(presenter, start.getX(), start.getY(), TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT, true);
				presenter.insertDoubleColumnItems(leftItem, rightItem);
			}
	    });
	    Button imageTextB = new Button("Image Text");
	    imageTextB.setSize(buttonWidth, 25);
	    imageTextB.setIconAlign(IconAlign.LEFT); 
	    imageTextB.setIcon(AbstractImagePrototype.create(images.text_image()));
	    imageTextB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				Coords start = presenter.getInsertionPoint();		
				DroppingArea leftItem = new DroppingArea(presenter, start.getX(), start.getX(), TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT, true);
				D4sRichTextarea rightItem = new D4sRichTextarea(ComponentType.BODY, presenter, start.getX(), start.getY(),  TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT);
				presenter.insertDoubleColumnItems(leftItem, rightItem);
			}
	    });
	    Button imageimageB = new Button("Image Image");
	    imageimageB.setSize(buttonWidth, 25);
	    imageimageB.setIconAlign(IconAlign.LEFT); 
	    imageimageB.setIcon(AbstractImagePrototype.create(images.image()));
	    imageimageB.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				Coords start = presenter.getInsertionPoint();		
				DroppingArea leftItem = new DroppingArea(presenter, start.getX(), start.getX(), TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT, true);
				DroppingArea rightItem = new DroppingArea(presenter, start.getX(), start.getY(), TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT, true);
				presenter.insertDoubleColumnItems(leftItem, rightItem);
			}
	    });
	    
	    
	    dc.add(textextB);
	    dc.add(new HTML("&nbsp;"));
	    dc.add(texImageB);
	    dc.add(new HTML("&nbsp;"));
	    dc.add(imageTextB);
	    dc.add(new HTML("&nbsp;"));
	    dc.add(imageimageB);
	    dc.add(new HTML("&nbsp;"));

	}
	

}
