/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.gcube.portlets.user.templates.client.TGenConstants;
import org.gcube.portlets.user.templates.client.TitleBar;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class TitleBar
extends Composite {
    private Presenter controller;
    private TemplateModel templateModel;
    private CellPanel mainLayout = new HorizontalPanel();
    private HTML templateNameBox = new HTML();
    private HTML editedOn = new HTML();
    private HTML pageDisplayer = new HTML();
    private HTML prevButton = new HTML("<img src=\"" + TGenConstants.IMAGE_PREV_PAGE + "\" />&nbsp;", true);
    private HTML nextButton = new HTML("&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"" + TGenConstants.IMAGE_NEXT_PAGE + "\" />", true);

    public TitleBar(Presenter c) {
        this.controller = c;
        this.templateModel = this.controller.getModel();
        this.setTemplateName(this.templateModel.getTemplateName());
        this.setPageDisplayer(1, 1);
        this.mainLayout.setSize("100%", "24px");
        HorizontalPanel captionPanel = new HorizontalPanel();
        HorizontalPanel innerCaptionPanel = new HorizontalPanel();
        captionPanel.setWidth("100%");
        this.nextButton.addStyleName("setVisibilityOff");
        this.prevButton.addStyleName("setVisibilityOff");
        HorizontalPanel pageHandlerPanel = new HorizontalPanel();
        pageHandlerPanel.setHeight("24");
        pageHandlerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        pageHandlerPanel.add((Widget)this.prevButton);
        pageHandlerPanel.add((Widget)this.pageDisplayer);
        pageHandlerPanel.add((Widget)this.nextButton);
        pageHandlerPanel.setWidth("100%");
        this.templateNameBox.setStyleName("menubar-font");
        captionPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        innerCaptionPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        innerCaptionPanel.setVerticalAlignment(HasAlignment.ALIGN_BOTTOM);
        innerCaptionPanel.add((Widget)this.templateNameBox);
        innerCaptionPanel.add((Widget)this.editedOn);
        captionPanel.add((Widget)innerCaptionPanel);
        this.mainLayout.add((Widget)captionPanel);
        this.mainLayout.add((Widget)pageHandlerPanel);
        this.editedOn.setStyleName("docEditedBy");
        this.mainLayout.setCellHorizontalAlignment((Widget)captionPanel, HasHorizontalAlignment.ALIGN_LEFT);
        this.mainLayout.setCellWidth((Widget)pageHandlerPanel, "200");
        this.initWidget((Widget)this.mainLayout);
        this.nextButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.prevButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPageDisplayer(int currentPage, int totalPages) {
        this.pageDisplayer.setHTML("Section " + currentPage + " of " + totalPages);
    }

    public void setTemplateName(String name) {
        this.templateNameBox.setHTML("&nbsp;&nbsp;" + name);
    }

    public void clearEditedOnBy() {
        this.editedOn.setHTML("&nbsp;&nbsp;");
    }

    public void setEditedOnBy(Date date, String username) {
        if (username == null) {
            this.editedOn.setHTML("&nbsp;&nbsp;");
        } else {
            String dt = "";
            if (date != null) {
                dt = DateTimeFormat.getShortDateFormat().format(date);
            }
            this.editedOn.setHTML("&nbsp;&nbsp;edited on " + dt + "&nbsp;&nbsp;by " + username);
        }
    }

    public void showPrevButton() {
        this.prevButton.removeStyleName("setVisibilityOff");
        this.prevButton.addStyleName("setVisibilityOn");
    }

    public void showNextButton() {
        this.nextButton.removeStyleName("setVisibilityOff");
        this.nextButton.addStyleName("setVisibilityOn");
    }

    public void hidePrevButton() {
        this.prevButton.removeStyleName("setVisibilityOn");
        this.prevButton.addStyleName("setVisibilityOff");
    }

    public void hideNextButton() {
        this.nextButton.removeStyleName("setVisibilityOn");
        this.nextButton.addStyleName("setVisibilityOff");
    }

    public Command getNullCommand() {
        3 openNothing = new /* Unavailable Anonymous Inner Class!! */;
        return openNothing;
    }

    static /* synthetic */ Presenter access$0(TitleBar titleBar) {
        return titleBar.controller;
    }
}

